/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.project.wizards;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.linuxtools.internal.tmf.ui.TmfUiPlugin;
import org.eclipse.linuxtools.internal.tmf.ui.parsers.custom.CustomTraceDefinition;
import org.eclipse.linuxtools.internal.tmf.ui.parsers.custom.CustomTxtTrace;
import org.eclipse.linuxtools.internal.tmf.ui.parsers.custom.CustomTxtTraceDefinition;
import org.eclipse.linuxtools.internal.tmf.ui.parsers.custom.CustomXmlTrace;
import org.eclipse.linuxtools.internal.tmf.ui.parsers.custom.CustomXmlTraceDefinition;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfProjectRegistry;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.linuxtools.tmf.ui.project.wizards.Messages;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.FileSystemElement;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.dialogs.WizardResourceImportPage;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;

public class ImportTraceWizardPage
extends WizardResourceImportPage
implements Listener {
    private static final String IMPORT_WIZARD_PAGE = "ImportTraceWizardPage";
    private static final String CUSTOM_TXT_CATEGORY = "Custom Text";
    private static final String CUSTOM_XML_CATEGORY = "Custom XML";
    private static final String DEFAULT_TRACE_ICON_PATH = "icons/elcl16/trace.gif";
    private static String fRootDirectory = null;
    private CheckboxTreeViewer fFolderViewer;
    private IProject fProject;
    private IFolder fTargetFolder;
    protected Combo directoryNameField;
    protected Button directoryBrowseButton;
    private boolean entryChanged = false;
    private Combo fTraceTypes;
    private Map<String, IConfigurationElement> fTraceTypeAttributes = new HashMap<String, IConfigurationElement>();
    private Map<String, IConfigurationElement> fTraceCategories = new HashMap<String, IConfigurationElement>();
    private final Map<String, IConfigurationElement> fTraceAttributes = new HashMap<String, IConfigurationElement>();
    private Button overwriteExistingResourcesCheckbox;
    private Button createLinksInWorkspaceButton;

    protected ImportTraceWizardPage(String name, IStructuredSelection selection) {
        super(name, selection);
    }

    public ImportTraceWizardPage(IWorkbench workbench, IStructuredSelection selection) {
        this(IMPORT_WIZARD_PAGE, selection);
        this.setTitle(Messages.ImportTraceWizard_FileSystemTitle);
        this.setDescription(Messages.ImportTraceWizard_ImportTrace);
        IFolder traceFolder = null;
        Object element = selection.getFirstElement();
        if (element instanceof TmfTraceFolder) {
            TmfTraceFolder tmfTraceFolder = (TmfTraceFolder)element;
            this.fProject = tmfTraceFolder.getProject().getResource();
            traceFolder = tmfTraceFolder.getResource();
        } else if (element instanceof IProject) {
            IProject project = (IProject)element;
            try {
                if (project.hasNature("org.eclipse.linuxtools.tmf.project.nature")) {
                    traceFolder = (IFolder)project.findMember("Traces");
                }
            }
            catch (CoreException coreException) {}
        }
        if (traceFolder != null) {
            this.fTargetFolder = traceFolder;
            String path = traceFolder.getFullPath().toOSString();
            this.setContainerFieldValue(path);
        }
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        if (fRootDirectory != null) {
            this.directoryNameField.setText(fRootDirectory);
            this.updateFromSourceField();
        }
    }

    protected void createSourceGroup(Composite parent) {
        this.createDirectorySelectionGroup(parent);
        this.createFileSelectionGroup(parent);
        this.createTraceTypeGroup(parent);
        this.validateSourceGroup();
    }

    protected void createFileSelectionGroup(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.fFolderViewer = new CheckboxTreeViewer(composite, 2048);
        GridData data = new GridData(1808);
        data.heightHint = 150;
        this.fFolderViewer.getTree().setLayoutData((Object)data);
        this.fFolderViewer.getTree().setFont(parent.getFont());
        this.fFolderViewer.setContentProvider((IContentProvider)this.getFileProvider());
        this.fFolderViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.fFolderViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object elem = event.getElement();
                if (elem instanceof FileSystemElement) {
                    FileSystemElement element = (FileSystemElement)elem;
                    if (ImportTraceWizardPage.this.fFolderViewer.getGrayed((Object)element)) {
                        ImportTraceWizardPage.this.fFolderViewer.setSubtreeChecked((Object)element, false);
                        ImportTraceWizardPage.this.fFolderViewer.setGrayed((Object)element, false);
                    } else if (event.getChecked()) {
                        ImportTraceWizardPage.this.fFolderViewer.setSubtreeChecked(event.getElement(), true);
                    } else {
                        ImportTraceWizardPage.this.fFolderViewer.setParentsGrayed((Object)element, true);
                        if (!element.isDirectory()) {
                            ImportTraceWizardPage.this.fFolderViewer.setGrayed((Object)element, false);
                        }
                    }
                    ImportTraceWizardPage.this.updateWidgetEnablements();
                }
            }
        });
    }

    protected ITreeContentProvider getFolderProvider() {
        return null;
    }

    protected ITreeContentProvider getFileProvider() {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object o) {
                if (o instanceof FileSystemElement) {
                    FileSystemElement element = (FileSystemElement)o;
                    ImportTraceWizardPage.this.populateChildren(element);
                    Object[] folders = element.getFolders().getChildren();
                    Object[] files = element.getFiles().getChildren();
                    LinkedList<Object> result = new LinkedList<Object>();
                    Object[] objectArray = folders;
                    int n = folders.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object folder = objectArray[n2];
                        result.add(folder);
                        ++n2;
                    }
                    objectArray = files;
                    n = files.length;
                    n2 = 0;
                    while (n2 < n) {
                        Object file = objectArray[n2];
                        result.add(file);
                        ++n2;
                    }
                    return result.toArray();
                }
                return new Object[0];
            }
        };
    }

    private void populateChildren(FileSystemElement parent) {
        Object fileSystemObject;
        List children;
        FileSystemStructureProvider provider = FileSystemStructureProvider.INSTANCE;
        if (parent.getFolders().size() == 0 && parent.getFiles().size() == 0 && (children = provider.getChildren(fileSystemObject = parent.getFileSystemObject())) != null) {
            for (Object child : children) {
                String label = provider.getLabel(child);
                FileSystemElement element = new FileSystemElement(label, parent, provider.isFolder(child));
                element.setFileSystemObject(child);
            }
        }
    }

    protected List<FileSystemElement> getSelectedResources() {
        Object[] checkedItems;
        ArrayList<FileSystemElement> resources = new ArrayList<FileSystemElement>();
        Object[] objectArray = checkedItems = this.fFolderViewer.getCheckedElements();
        int n = checkedItems.length;
        int n2 = 0;
        while (n2 < n) {
            Object item = objectArray[n2];
            if (item instanceof FileSystemElement && !this.fFolderViewer.getGrayed(item)) {
                resources.add((FileSystemElement)item);
            }
            ++n2;
        }
        return resources;
    }

    protected void createDirectorySelectionGroup(Composite parent) {
        Composite directoryContainerGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        directoryContainerGroup.setLayout((Layout)layout);
        directoryContainerGroup.setFont(parent.getFont());
        directoryContainerGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        Label groupLabel = new Label(directoryContainerGroup, 0);
        groupLabel.setText(Messages.ImportTraceWizard_DirectoryLocation);
        groupLabel.setFont(parent.getFont());
        this.directoryNameField = new Combo(directoryContainerGroup, 2048);
        GridData data = new GridData(4, 4, true, false);
        data.widthHint = 250;
        this.directoryNameField.setLayoutData((Object)data);
        this.directoryNameField.setFont(parent.getFont());
        this.directoryNameField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportTraceWizardPage.this.updateFromSourceField();
            }
        });
        this.directoryNameField.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                ImportTraceWizardPage.this.entryChanged = true;
                if (e.character == '\r') {
                    ImportTraceWizardPage.this.entryChanged = false;
                    ImportTraceWizardPage.this.updateFromSourceField();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.directoryNameField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                if (ImportTraceWizardPage.this.entryChanged) {
                    ImportTraceWizardPage.this.entryChanged = false;
                    ImportTraceWizardPage.this.updateFromSourceField();
                }
            }
        });
        this.directoryBrowseButton = new Button(directoryContainerGroup, 8);
        this.directoryBrowseButton.setText(Messages.ImportTraceWizard_BrowseButton);
        this.directoryBrowseButton.addListener(13, (Listener)this);
        this.directoryBrowseButton.setLayoutData((Object)new GridData(4, 4, false, false));
        this.directoryBrowseButton.setFont(parent.getFont());
        this.setButtonLayoutData(this.directoryBrowseButton);
    }

    public void handleEvent(Event event) {
        if (event.widget == this.directoryBrowseButton) {
            this.handleSourceDirectoryBrowseButtonPressed();
        }
        super.handleEvent(event);
    }

    protected void handleSourceDirectoryBrowseButtonPressed() {
        String currentSource = this.directoryNameField.getText();
        DirectoryDialog dialog = new DirectoryDialog(this.directoryNameField.getShell(), 0x10002000);
        dialog.setText(Messages.ImportTraceWizard_SelectTraceDirectoryTitle);
        dialog.setMessage(Messages.ImportTraceWizard_SelectTraceDirectoryMessage);
        dialog.setFilterPath(this.getSourceDirectoryName(currentSource));
        String selectedDirectory = dialog.open();
        if (selectedDirectory != null) {
            if (this.getSourceDirectory(selectedDirectory) == null || selectedDirectory.equals(currentSource)) {
                return;
            }
            this.setErrorMessage(null);
            this.setSourceName(selectedDirectory);
        }
    }

    private File getSourceDirectory() {
        return this.getSourceDirectory(this.directoryNameField.getText());
    }

    private File getSourceDirectory(String path) {
        File sourceDirectory = new File(this.getSourceDirectoryName(path));
        if (!sourceDirectory.exists() || !sourceDirectory.isDirectory()) {
            return null;
        }
        return sourceDirectory;
    }

    private String getSourceDirectoryName(String sourceName) {
        Path result = new Path(sourceName.trim());
        result = result.getDevice() != null && result.segmentCount() == 0 ? result.addTrailingSeparator() : result.removeTrailingSeparator();
        return result.toOSString();
    }

    private String getSourceDirectoryName() {
        return this.getSourceDirectoryName(this.directoryNameField.getText());
    }

    private void updateFromSourceField() {
        this.setSourceName(this.directoryNameField.getText());
        this.updateWidgetEnablements();
    }

    private void setSourceName(String path) {
        if (path.length() > 0) {
            String[] currentItems = this.directoryNameField.getItems();
            int selectionIndex = -1;
            int i = 0;
            while (i < currentItems.length) {
                if (currentItems[i].equals(path)) {
                    selectionIndex = i;
                }
                ++i;
            }
            if (selectionIndex < 0) {
                int oldLength = currentItems.length;
                String[] newItems = new String[oldLength + 1];
                System.arraycopy(currentItems, 0, newItems, 0, oldLength);
                newItems[oldLength] = path;
                this.directoryNameField.setItems(newItems);
                selectionIndex = oldLength;
            }
            this.directoryNameField.select(selectionIndex);
        }
        this.resetSelection();
    }

    private void resetSelection() {
        FileSystemElement root = this.getFileSystemTree();
        this.populateListViewer(root);
    }

    private void populateListViewer(Object treeElement) {
        this.fFolderViewer.setInput(treeElement);
    }

    private FileSystemElement getFileSystemTree() {
        File sourceDirectory = this.getSourceDirectory();
        if (sourceDirectory == null) {
            return null;
        }
        return this.selectFiles(sourceDirectory, (IImportStructureProvider)FileSystemStructureProvider.INSTANCE);
    }

    private FileSystemElement selectFiles(final Object rootFileSystemObject, final IImportStructureProvider structureProvider) {
        final FileSystemElement[] results = new FileSystemElement[1];
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                results[0] = ImportTraceWizardPage.this.createRootElement(rootFileSystemObject, structureProvider);
            }
        });
        return results[0];
    }

    private FileSystemElement createRootElement(Object fileSystemObject, IImportStructureProvider provider) {
        boolean isContainer = provider.isFolder(fileSystemObject);
        String elementLabel = provider.getLabel(fileSystemObject);
        FileSystemElement dummyParent = new FileSystemElement("", null, true);
        FileSystemElement element = new FileSystemElement(elementLabel, dummyParent, isContainer);
        element.setFileSystemObject(fileSystemObject);
        this.populateChildren(element);
        return dummyParent;
    }

    private final void createTraceTypeGroup(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = false;
        composite.setLayout((Layout)layout);
        composite.setFont(parent.getFont());
        GridData buttonData = new GridData(4, 4, true, false);
        composite.setLayoutData((Object)buttonData);
        Label typeLabel = new Label(composite, 0);
        typeLabel.setText(Messages.ImportTraceWizard_TraceType);
        typeLabel.setFont(parent.getFont());
        this.fTraceTypes = new Combo(composite, 2048);
        GridData data = new GridData(4, 4, true, false, 2, 1);
        this.fTraceTypes.setLayoutData((Object)data);
        this.fTraceTypes.setFont(parent.getFont());
        String[] availableTraceTypes = this.getAvailableTraceTypes();
        this.fTraceTypes.setItems(availableTraceTypes);
        this.fTraceTypes.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ImportTraceWizardPage.this.validateSourceGroup();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private String[] getAvailableTraceTypes() {
        String traceTypeName;
        IConfigurationElement[] config;
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.linuxtools.tmf.ui.tracetype");
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            String elementName = ce.getName();
            if (elementName.equals("type")) {
                String traceTypeId = ce.getAttribute("id");
                this.fTraceTypeAttributes.put(traceTypeId, ce);
            } else if (elementName.equals("category")) {
                String categoryId = ce.getAttribute("id");
                this.fTraceCategories.put(categoryId, ce);
            }
            ++n2;
        }
        ArrayList<String> traceTypes = new ArrayList<String>();
        for (String typeId : this.fTraceTypeAttributes.keySet()) {
            IConfigurationElement ce = this.fTraceTypeAttributes.get(typeId);
            String traceTypeName2 = String.valueOf(this.getCategory(ce)) + " : " + ce.getAttribute("name");
            this.fTraceAttributes.put(traceTypeName2, ce);
            traceTypes.add(traceTypeName2);
        }
        Collections.sort(traceTypes);
        CustomTraceDefinition[] customTraceDefinitionArray = CustomTxtTraceDefinition.loadAll();
        int n3 = customTraceDefinitionArray.length;
        int n4 = 0;
        while (n4 < n3) {
            CustomTxtTraceDefinition def = customTraceDefinitionArray[n4];
            traceTypeName = "Custom Text : " + def.definitionName;
            traceTypes.add(traceTypeName);
            ++n4;
        }
        customTraceDefinitionArray = CustomXmlTraceDefinition.loadAll();
        n3 = customTraceDefinitionArray.length;
        n4 = 0;
        while (n4 < n3) {
            CustomTraceDefinition def = customTraceDefinitionArray[n4];
            traceTypeName = "Custom XML : " + ((CustomXmlTraceDefinition)def).definitionName;
            traceTypes.add(traceTypeName);
            ++n4;
        }
        return traceTypes.toArray(new String[traceTypes.size()]);
    }

    private String getCategory(IConfigurationElement ce) {
        IConfigurationElement category;
        String categoryId = ce.getAttribute("category");
        if (categoryId != null && (category = this.fTraceCategories.get(categoryId)) != null && !category.getName().equals("")) {
            return category.getAttribute("name");
        }
        return "[no category]";
    }

    protected void createOptionsGroupButtons(Group optionsGroup) {
        this.overwriteExistingResourcesCheckbox = new Button((Composite)optionsGroup, 32);
        this.overwriteExistingResourcesCheckbox.setFont(optionsGroup.getFont());
        this.overwriteExistingResourcesCheckbox.setText(Messages.ImportTraceWizard_OverwriteExistingTrace);
        this.overwriteExistingResourcesCheckbox.setSelection(false);
        this.createLinksInWorkspaceButton = new Button((Composite)optionsGroup, 32);
        this.createLinksInWorkspaceButton.setFont(optionsGroup.getFont());
        this.createLinksInWorkspaceButton.setText(Messages.ImportTraceWizard_CreateLinksInWorkspace);
        this.createLinksInWorkspaceButton.setSelection(true);
        this.createLinksInWorkspaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportTraceWizardPage.this.updateWidgetEnablements();
            }
        });
        this.updateWidgetEnablements();
    }

    public boolean validateSourceGroup() {
        String traceTypeName;
        File sourceDirectory = this.getSourceDirectory();
        if (sourceDirectory == null) {
            this.setMessage(Messages.ImportTraceWizard_SelectTraceSourceEmpty);
            return false;
        }
        if (this.sourceConflictsWithDestination((IPath)new Path(sourceDirectory.getPath()))) {
            this.setMessage(null);
            this.setErrorMessage(this.getSourceConflictMessage());
            return false;
        }
        List<FileSystemElement> resourcesToImport = this.getSelectedResources();
        if (resourcesToImport.size() == 0) {
            this.setMessage(null);
            this.setErrorMessage(Messages.ImportTraceWizard_SelectTraceNoneSelected);
            return false;
        }
        IContainer container = this.getSpecifiedContainer();
        if (container != null && container.isVirtual()) {
            if (Platform.getPreferencesService().getBoolean("org.eclipse.linuxtools.tmf.ui", "description.disableLinking", false, null)) {
                this.setMessage(null);
                this.setErrorMessage(Messages.ImportTraceWizard_CannotImportFilesUnderAVirtualFolder);
                return false;
            }
            if (this.createLinksInWorkspaceButton == null || !this.createLinksInWorkspaceButton.getSelection()) {
                this.setMessage(null);
                this.setErrorMessage(Messages.ImportTraceWizard_HaveToCreateLinksUnderAVirtualFolder);
                return false;
            }
        }
        if (!((traceTypeName = this.fTraceTypes.getText()) == null || "".equals(traceTypeName) || traceTypeName.startsWith(CUSTOM_TXT_CATEGORY) || traceTypeName.startsWith(CUSTOM_XML_CATEGORY))) {
            List<File> traces = this.isolateTraces();
            for (File trace : traces) {
                ITmfTrace tmfTrace = null;
                try {
                    IConfigurationElement ce = this.fTraceAttributes.get(traceTypeName);
                    tmfTrace = (ITmfTrace)ce.createExecutableExtension("trace_type");
                    if (tmfTrace == null || tmfTrace.validate(this.fProject, trace.getAbsolutePath())) continue;
                    this.setMessage(null);
                    this.setErrorMessage(Messages.ImportTraceWizard_TraceValidationFailed);
                    tmfTrace.dispose();
                    return false;
                }
                catch (CoreException coreException) {
                }
                finally {
                    if (tmfTrace != null) {
                        tmfTrace.dispose();
                    }
                }
            }
        }
        this.setErrorMessage(null);
        return true;
    }

    private List<File> isolateTraces() {
        ArrayList<File> traces = new ArrayList<File>();
        List<FileSystemElement> selectedResources = this.getSelectedResources();
        Iterator<FileSystemElement> resources = selectedResources.iterator();
        HashMap<String, File> fileSystemObjects = new HashMap<String, File>();
        while (resources.hasNext()) {
            File resource = (File)resources.next().getFileSystemObject();
            String key = resource.getAbsolutePath();
            fileSystemObjects.put(key, resource);
        }
        ArrayList files = new ArrayList(fileSystemObjects.keySet());
        Collections.sort(files);
        String prefix = null;
        int i = 0;
        while (i < files.size()) {
            File file = (File)fileSystemObjects.get(files.get(i));
            String name = file.getAbsolutePath();
            if (prefix == null || !name.startsWith(prefix)) {
                prefix = name;
                traces.add(file);
            }
            ++i;
        }
        return traces;
    }

    public boolean finish() {
        String sourceDirPath;
        File sourceDir = new File(this.getSourceDirectoryName());
        if (!sourceDir.isDirectory()) {
            this.setErrorMessage(Messages.ImportTraceWizard_InvalidTraceDirectory);
            return false;
        }
        try {
            sourceDirPath = sourceDir.getCanonicalPath();
        }
        catch (IOException iOException) {
            MessageDialog.openInformation((Shell)this.getContainer().getShell(), (String)Messages.ImportTraceWizard_Information, (String)Messages.ImportTraceWizard_InvalidTraceDirectory);
            return false;
        }
        fRootDirectory = this.getSourceDirectoryName();
        List<FileSystemElement> selectedResources = this.getSelectedResources();
        Iterator<FileSystemElement> resources = selectedResources.iterator();
        HashMap<String, File> fileSystemObjects = new HashMap<String, File>();
        while (resources.hasNext()) {
            File file = (File)resources.next().getFileSystemObject();
            String key = file.getAbsolutePath();
            fileSystemObjects.put(key, file);
        }
        if (fileSystemObjects.size() > 0) {
            CustomTraceDefinition def;
            int n;
            int n2;
            CustomTraceDefinition[] customTraceDefinitionArray;
            boolean ok = this.importResources(sourceDirPath, fileSystemObjects);
            String traceBundle = null;
            String traceTypeId = null;
            String traceIcon = null;
            String traceType = this.fTraceTypes.getText();
            boolean traceTypeOK = false;
            if (traceType.startsWith(CUSTOM_TXT_CATEGORY)) {
                customTraceDefinitionArray = CustomTxtTraceDefinition.loadAll();
                n2 = customTraceDefinitionArray.length;
                n = 0;
                while (n < n2) {
                    def = customTraceDefinitionArray[n];
                    if (traceType.equals("Custom Text : " + ((CustomTxtTraceDefinition)def).definitionName)) {
                        traceTypeOK = true;
                        traceBundle = TmfUiPlugin.getDefault().getBundle().getSymbolicName();
                        traceTypeId = String.valueOf(CustomTxtTrace.class.getCanonicalName()) + ":" + ((CustomTxtTraceDefinition)def).definitionName;
                        traceIcon = DEFAULT_TRACE_ICON_PATH;
                        break;
                    }
                    ++n;
                }
            } else if (traceType.startsWith(CUSTOM_XML_CATEGORY)) {
                customTraceDefinitionArray = CustomXmlTraceDefinition.loadAll();
                n2 = customTraceDefinitionArray.length;
                n = 0;
                while (n < n2) {
                    def = customTraceDefinitionArray[n];
                    if (traceType.equals("Custom XML : " + ((CustomXmlTraceDefinition)def).definitionName)) {
                        traceTypeOK = true;
                        traceBundle = TmfUiPlugin.getDefault().getBundle().getSymbolicName();
                        traceTypeId = String.valueOf(CustomXmlTrace.class.getCanonicalName()) + ":" + ((CustomXmlTraceDefinition)def).definitionName;
                        traceIcon = DEFAULT_TRACE_ICON_PATH;
                        break;
                    }
                    ++n;
                }
            } else {
                IConfigurationElement ce = this.fTraceAttributes.get(traceType);
                if (ce != null) {
                    traceTypeOK = true;
                    traceBundle = ce.getContributor().getName();
                    traceTypeId = ce.getAttribute("id");
                    traceIcon = ce.getAttribute("icon");
                }
            }
            if (ok && traceTypeOK && !traceType.equals("")) {
                ArrayList files = new ArrayList(fileSystemObjects.keySet());
                Collections.sort(files);
                String prefix = null;
                int i = 0;
                while (i < files.size()) {
                    File file = (File)fileSystemObjects.get(files.get(i));
                    String name = file.getAbsolutePath();
                    if (prefix == null || !name.startsWith(prefix)) {
                        prefix = name;
                        IResource resource = this.fTargetFolder.findMember(file.getName());
                        if (resource != null) {
                            try {
                                resource.setPersistentProperty(TmfTraceElement.TRACEBUNDLE, traceBundle);
                                resource.setPersistentProperty(TmfTraceElement.TRACETYPE, traceTypeId);
                                resource.setPersistentProperty(TmfTraceElement.TRACEICON, traceIcon);
                                for (TmfTraceElement traceElement : TmfProjectRegistry.getProject(resource.getProject()).getTracesFolder().getTraces()) {
                                    if (!traceElement.getName().equals(resource.getName())) continue;
                                    traceElement.refreshTraceType();
                                    break;
                                }
                            }
                            catch (CoreException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    ++i;
                }
            }
            return ok;
        }
        MessageDialog.openInformation((Shell)this.getContainer().getShell(), (String)Messages.ImportTraceWizard_Information, (String)Messages.ImportTraceWizard_SelectTraceNoneSelected);
        return false;
    }

    private boolean importResources(String rootDirectory, Map<String, File> fileSystemObjects) {
        ArrayList<File> fileList = new ArrayList<File>();
        for (Map.Entry<String, File> entry : fileSystemObjects.entrySet()) {
            fileList.add(entry.getValue());
        }
        Collections.sort(fileList);
        boolean ok = true;
        boolean isLinked = this.createLinksInWorkspaceButton.getSelection();
        int i = 0;
        while (i < fileList.size()) {
            File resource = (File)fileList.get(i);
            File parentFolder = new File(resource.getParent());
            ArrayList<File> subList = new ArrayList<File>();
            subList.add(resource);
            if (resource.isDirectory()) {
                String prefix = resource.getAbsolutePath();
                boolean hasSamePrefix = true;
                int j = i;
                while (j < fileList.size() && hasSamePrefix) {
                    File res = (File)fileList.get(j);
                    hasSamePrefix = res.getAbsolutePath().startsWith(prefix);
                    if (hasSamePrefix) {
                        if (!isLinked) {
                            subList.add(res);
                        }
                        i = j;
                    }
                    ++j;
                }
            }
            FileSystemStructureProvider fileSystemStructureProvider = FileSystemStructureProvider.INSTANCE;
            ImportOperation operation = new ImportOperation(this.getContainerFullPath(), (Object)parentFolder, (IImportStructureProvider)fileSystemStructureProvider, (IOverwriteQuery)this, subList);
            operation.setContext(this.getShell());
            ok = this.executeImportOperation(operation);
            ++i;
        }
        return ok;
    }

    private boolean executeImportOperation(ImportOperation op) {
        this.initializeOperation(op);
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            this.displayErrorDialog(e.getTargetException());
            return false;
        }
        IStatus status = op.getStatus();
        if (!status.isOK()) {
            ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)Messages.ImportTraceWizard_ImportProblem, null, (IStatus)status);
            return false;
        }
        return true;
    }

    private void initializeOperation(ImportOperation op) {
        op.setCreateContainerStructure(false);
        op.setOverwriteResources(this.overwriteExistingResourcesCheckbox.getSelection());
        op.setCreateLinks(this.createLinksInWorkspaceButton.getSelection());
        op.setVirtualFolders(false);
    }
}

