/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.statesystem;

import java.io.IOException;
import org.eclipse.linuxtools.internal.tmf.core.statesystem.StateHistorySystem;
import org.eclipse.linuxtools.tmf.core.statesystem.IStateChangeInput;
import org.eclipse.linuxtools.tmf.core.statesystem.IStateHistoryBackend;
import org.eclipse.linuxtools.tmf.core.statesystem.IStateSystemBuilder;
import org.eclipse.linuxtools.tmf.core.statesystem.IStateSystemQuerier;

public class HistoryBuilder
implements Runnable {
    private final IStateChangeInput sci;
    private final StateHistorySystem shs;
    private final IStateHistoryBackend hb;
    private final Thread sciThread;

    public HistoryBuilder(IStateChangeInput stateChangeInput, IStateHistoryBackend backend) throws IOException {
        assert (stateChangeInput != null);
        assert (backend != null);
        this.sci = stateChangeInput;
        this.hb = backend;
        this.shs = new StateHistorySystem(this.hb, true);
        this.sci.assignTargetStateSystem(this.shs);
        this.sciThread = new Thread((Runnable)this.sci, "Input Plugin");
    }

    public static IStateSystemBuilder openExistingHistory(IStateHistoryBackend hb) throws IOException {
        return new StateHistorySystem(hb, false);
    }

    @Override
    public void run() {
        this.sciThread.start();
    }

    public void close() {
        try {
            this.sciThread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public IStateSystemBuilder getStateSystemBuilder() {
        return this.shs;
    }

    public IStateSystemQuerier getStateSystemQuerier() {
        return this.shs;
    }
}

