/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.event;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.linuxtools.tmf.core.event.ITmfEventField;

public class TmfEventField
implements ITmfEventField {
    private String fName;
    private Object fValue;
    private ITmfEventField[] fFields;
    private String[] fFieldNames;
    private Map<String, ITmfEventField> fNameMapping;

    private TmfEventField() {
    }

    public TmfEventField(String name, ITmfEventField[] fields) {
        this(name, null, fields);
    }

    public TmfEventField(String name, Object value) {
        this(name, value, null);
    }

    public TmfEventField(String name, Object value, ITmfEventField[] fields) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        this.fName = name;
        this.fValue = value;
        this.fFields = fields != null ? Arrays.copyOf(fields, fields.length) : null;
        this.populateStructs();
    }

    public TmfEventField(TmfEventField field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        this.fName = field.fName;
        this.fValue = field.fValue;
        this.fFields = field.fFields;
        this.fFieldNames = field.fFieldNames;
        this.populateStructs();
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public Object getValue() {
        return this.fValue;
    }

    @Override
    public String[] getFieldNames() {
        return Arrays.copyOf(this.fFieldNames, this.fFieldNames.length);
    }

    @Override
    public String getFieldName(int index) {
        ITmfEventField field = this.getField(index);
        if (field != null) {
            return field.getName();
        }
        return null;
    }

    @Override
    public ITmfEventField[] getFields() {
        return this.fFields != null ? Arrays.copyOf(this.fFields, this.fFields.length) : null;
    }

    @Override
    public ITmfEventField getField(String name) {
        return this.fNameMapping.get(name);
    }

    @Override
    public ITmfEventField getField(int index) {
        if (this.fFields != null && index >= 0 && index < this.fFields.length) {
            return this.fFields[index];
        }
        return null;
    }

    protected void setValue(Object value, ITmfEventField[] fields) {
        this.fValue = value;
        this.fFields = fields != null ? Arrays.copyOf(fields, fields.length) : null;
        this.populateStructs();
    }

    public static final ITmfEventField makeRoot(String[] labels) {
        ITmfEventField[] fields = new ITmfEventField[labels.length];
        int i = 0;
        while (i < labels.length) {
            fields[i] = new TmfEventField(labels[i], null);
            ++i;
        }
        return new TmfEventField(":root:", fields);
    }

    private void populateStructs() {
        int nbFields = this.fFields != null ? this.fFields.length : 0;
        this.fFieldNames = new String[nbFields];
        this.fNameMapping = new HashMap<String, ITmfEventField>();
        int i = 0;
        while (i < nbFields) {
            String name;
            this.fFieldNames[i] = name = this.fFields[i].getName();
            this.fNameMapping.put(name, this.fFields[i]);
            ++i;
        }
    }

    @Override
    public TmfEventField clone() {
        TmfEventField clone = null;
        try {
            clone = (TmfEventField)super.clone();
            clone.fName = this.fName;
            clone.fValue = this.fValue;
            clone.fFields = this.fFields != null ? (ITmfEventField[])this.fFields.clone() : null;
            clone.populateStructs();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return clone;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.fName.hashCode();
        result = 31 * result + (this.fValue == null ? 0 : this.fValue.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TmfEventField)) {
            return false;
        }
        TmfEventField other = (TmfEventField)obj;
        if (!this.fName.equals(other.fName)) {
            return false;
        }
        return !(this.fValue == null ? other.fValue != null : !this.fValue.equals(other.fValue));
    }

    public String toString() {
        return "TmfEventField [fFieldId=" + this.fName + ", fValue=" + this.fValue + "]";
    }
}

