/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.editor;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.linuxtools.internal.systemtap.ui.editor.Localization;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.ILocationProvider;

public class PathEditorInput
implements IPathEditorInput,
ILocationProvider {
    private IPath fPath;
    private IWorkbenchWindow fMainWindow;
    public boolean temp = false;
    private static int tempcount = 0;

    public PathEditorInput(IPath path) {
        if (path == null) {
            throw new IllegalArgumentException();
        }
        this.fPath = path;
    }

    public PathEditorInput(IPath path, IWorkbenchWindow window) {
        this(path);
        this.fMainWindow = window;
    }

    public PathEditorInput() throws IOException {
        this.temp = true;
        ++tempcount;
        File file = File.createTempFile(Localization.getString("PathEditorInput.Untitled"), ".stp");
        this.fPath = new Path(file.getAbsolutePath());
    }

    public int hashCode() {
        return this.fPath.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PathEditorInput)) {
            return false;
        }
        PathEditorInput other = (PathEditorInput)obj;
        return this.fPath.equals((Object)other.fPath);
    }

    public boolean exists() {
        return this.fPath.toFile().exists();
    }

    public ImageDescriptor getImageDescriptor() {
        return PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(this.fPath.toString());
    }

    public String getName() {
        String[] substr = this.fPath.segments();
        return substr[substr.length - 1];
    }

    public String getToolTipText() {
        return this.fPath.makeRelative().toOSString();
    }

    public IPath getPath() {
        return this.fPath;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public IWorkbenchWindow getMainWindow() {
        return this.fMainWindow;
    }

    public IPath getPath(Object element) {
        if (element instanceof PathEditorInput) {
            return ((PathEditorInput)element).getPath();
        }
        return null;
    }

    public void setPath(IPath newPath) {
        this.fPath = newPath;
    }
}

