/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.oprofile.ui.view;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.linuxtools.internal.oprofile.core.Oprofile;
import org.eclipse.linuxtools.internal.oprofile.ui.OprofileUiMessages;

class LogReader
implements Runnable,
IRunnableWithProgress {
    private static long lastModified = -1L;
    private static String contents = null;

    LogReader() {
    }

    public void run() {
        File logFile = new File(Oprofile.getLogFile());
        long modified = logFile.lastModified();
        if (modified != lastModified) {
            lastModified = modified;
            contents = "";
            try {
                String line;
                BufferedReader reader = new BufferedReader(new FileReader(logFile));
                while ((line = reader.readLine()) != null) {
                    contents = String.valueOf(contents) + line + "\n";
                }
                reader.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                contents = OprofileUiMessages.getString("oprofiled.logreader.error.fileNotFound");
            }
            catch (IOException iOException) {
                lastModified = 0L;
                contents = OprofileUiMessages.getString("oprofiled.logreader.error.io");
            }
        }
    }

    public String getLogContents() {
        return contents;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        this.run();
    }
}

