/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.statesystem;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.linuxtools.tmf.core.statesystem.AlphaNumAttribute;
import org.eclipse.linuxtools.tmf.core.statesystem.Attribute;
import org.eclipse.linuxtools.tmf.core.statesystem.AttributeNotFoundException;
import org.eclipse.linuxtools.tmf.core.statesystem.StateSystem;

final class AttributeTree {
    private static final int ATTRIB_TREE_MAGIC_NUMBER = 116143729;
    private final StateSystem ss;
    private final List<Attribute> attributeList;
    private final Attribute attributeTreeRoot;

    AttributeTree(StateSystem ss) {
        this.ss = ss;
        this.attributeList = Collections.synchronizedList(new ArrayList());
        this.attributeTreeRoot = new AlphaNumAttribute(null, "root", -1);
    }

    AttributeTree(StateSystem ss, FileInputStream fis) throws IOException {
        this(ss);
        DataInputStream in = new DataInputStream(new BufferedInputStream(fis));
        ArrayList<String[]> list = new ArrayList<String[]>();
        int expectedSize = 0;
        int total = 0;
        int res = in.readInt();
        if (res != 116143729) {
            throw new IOException("The attribute tree file section is either invalid or corrupted.");
        }
        expectedSize = in.readInt();
        if (expectedSize <= 12) {
            throw new IOException("The attribute tree file section is either invalid or corrupted.");
        }
        int remain = in.readInt();
        total += 12;
        while (remain > 0) {
            byte size = in.readByte();
            byte[] curByteArray = new byte[size];
            in.read(curByteArray);
            String curFullString = new String(curByteArray);
            String[] curStringArray = curFullString.split("/");
            list.add(curStringArray);
            res = in.readByte();
            if (res != 0) {
                throw new IOException("The attribute tree file section is either invalid or corrupted.");
            }
            total += curByteArray.length + 2;
            --remain;
        }
        if (total != expectedSize) {
            throw new IOException("The attribute tree file section is either invalid or corrupted.");
        }
        for (String[] attrib : list) {
            this.getQuarkAndAdd(-1, attrib);
        }
    }

    int writeSelf(File file, long pos) {
        int total = 0;
        try {
            RandomAccessFile raf = new RandomAccessFile(file, "rw");
            raf.seek(pos);
            raf.writeInt(116143729);
            raf.writeInt(-8000);
            raf.writeInt(this.attributeList.size());
            total += 12;
            for (Attribute entry : this.attributeList) {
                byte[] curByteArray = entry.getFullAttributeName().getBytes();
                if (curByteArray.length > 127) {
                    throw new IOException("Attribute with name \"" + Arrays.toString(curByteArray) + "\" is too long.");
                }
                raf.writeByte((byte)curByteArray.length);
                raf.write(curByteArray);
                raf.writeByte(0);
                total += curByteArray.length + 2;
            }
            raf.seek(pos + 4L);
            raf.writeInt(total);
            raf.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return total;
    }

    int getNbAttributes() {
        return this.attributeList.size();
    }

    int getQuarkDontAdd(int startingNodeQuark, String ... subPath) throws AttributeNotFoundException {
        assert (subPath != null && subPath.length > 0);
        assert (startingNodeQuark >= -1);
        Attribute prevNode = startingNodeQuark == -1 ? this.attributeTreeRoot : this.attributeList.get(startingNodeQuark);
        int knownQuark = prevNode.getSubAttributeQuark(subPath);
        if (knownQuark == -1) {
            throw new AttributeNotFoundException();
        }
        return knownQuark;
    }

    synchronized int getQuarkAndAdd(int startingNodeQuark, String ... subPath) {
        assert (subPath != null && subPath.length > 0);
        assert (startingNodeQuark >= -1);
        Attribute nextNode = null;
        Attribute prevNode = startingNodeQuark == -1 ? this.attributeTreeRoot : this.attributeList.get(startingNodeQuark);
        int knownQuark = prevNode.getSubAttributeQuark(subPath);
        if (knownQuark == -1) {
            String[] stringArray = subPath;
            int n = subPath.length;
            int n2 = 0;
            while (n2 < n) {
                String curDirectory = stringArray[n2];
                nextNode = prevNode.getSubAttributeNode(curDirectory);
                if (nextNode == null) {
                    nextNode = new AlphaNumAttribute(prevNode, curDirectory, this.attributeList.size());
                    prevNode.addSubAttribute(nextNode);
                    this.attributeList.add(nextNode);
                    this.ss.transState.addEmptyEntry();
                }
                prevNode = nextNode;
                ++n2;
            }
            return this.attributeList.size() - 1;
        }
        return knownQuark;
    }

    int getSubAttributesCount(int quark) {
        return this.attributeList.get(quark).getSubAttributesList().size();
    }

    ArrayList<Integer> getSubAttributes(int attributeQuark) {
        ArrayList<Integer> listOfChildren = new ArrayList<Integer>();
        for (Attribute childNode : this.attributeList.get(attributeQuark).getSubAttributesList()) {
            listOfChildren.add(childNode.getQuark());
        }
        return listOfChildren;
    }

    String getFullAttributeName(int quark) {
        if (quark >= this.attributeList.size() || quark < 0) {
            return null;
        }
        return this.attributeList.get(quark).getFullAttributeName();
    }

    void debugPrint(PrintWriter writer) {
        this.attributeTreeRoot.debugPrint(writer);
    }
}

