/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.statesystem;

import java.io.PrintWriter;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

abstract class Attribute {
    private final Attribute parent;
    private final String name;
    private final int quark;
    protected final Vector<Attribute> subAttributes;
    private int curDepth;

    Attribute(Attribute parent, String name, int quark) {
        this.parent = parent;
        this.quark = quark;
        this.name = name;
        this.subAttributes = new Vector();
    }

    int getQuark() {
        return this.quark;
    }

    Attribute getParent() {
        return this.parent;
    }

    List<Attribute> getSubAttributesList() {
        return this.subAttributes;
    }

    String getName() {
        return this.name;
    }

    int getSubAttributeQuark(String ... path) {
        return this.getSubAttributeQuark(path, 0);
    }

    Attribute getSubAttributeNode(String ... path) {
        return this.getSubAttributeNode(path, 0);
    }

    private int getSubAttributeQuark(String[] path, int index) {
        Attribute targetNode = this.getSubAttributeNode(path, index);
        if (targetNode == null) {
            return -1;
        }
        return targetNode.getQuark();
    }

    abstract void addSubAttribute(Attribute var1);

    abstract Attribute getSubAttributeNode(String[] var1, int var2);

    String[] getFullAttribute() {
        LinkedList<String> list = new LinkedList<String>();
        Attribute curNode = this;
        while (curNode.getParent() != null) {
            list.add(curNode.getName());
            curNode = curNode.getParent();
        }
        Collections.reverse(list);
        return list.toArray(new String[0]);
    }

    String getFullAttributeName() {
        String ret = "";
        String[] array = this.getFullAttribute();
        int i = 0;
        while (i < array.length - 1) {
            ret = String.valueOf(ret) + array[i] + '/';
            ++i;
        }
        ret = String.valueOf(ret) + array[array.length - 1];
        return ret;
    }

    public String toString() {
        return String.valueOf(this.getFullAttributeName()) + " (" + this.quark + ')';
    }

    private void attributeNodeToString(PrintWriter writer, Attribute currentNode) {
        writer.println(String.valueOf(currentNode.getName()) + " (" + currentNode.quark + ')');
        ++this.curDepth;
        for (Attribute nextNode : currentNode.getSubAttributesList()) {
            if (nextNode == null) continue;
            int j = 0;
            while (j < this.curDepth - 1) {
                writer.print("  ");
                ++j;
            }
            writer.print("  ");
            this.attributeNodeToString(writer, nextNode);
        }
        --this.curDepth;
    }

    void debugPrint(PrintWriter writer) {
        writer.println("------------------------------");
        writer.println("Attribute tree: (quark)\n");
        this.curDepth = 0;
        this.attributeNodeToString(writer, this);
        writer.print('\n');
    }
}

