/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng.ui.tracecontrol.utility;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.eclipse.linuxtools.internal.lttng.core.tracecontrol.model.TraceResource;
import org.eclipse.linuxtools.internal.lttng.core.tracecontrol.model.config.TraceConfig;
import org.eclipse.linuxtools.internal.lttng.ui.tracecontrol.subsystems.TraceSubSystem;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.tm.tcf.protocol.JSON;

public class DownloadProxy {
    TraceSubSystem fSubSystem;

    public DownloadProxy(TraceSubSystem subSystem) {
        this.fSubSystem = subSystem;
    }

    public void writeDownloadedTrace(byte[] data) {
        Object[] args = null;
        try {
            args = JSON.parseSequence((byte[])data);
        }
        catch (IOException e) {
            SystemBasePlugin.logError((String)"DownloadProxy", (Throwable)e);
        }
        if (args != null) {
            byte[] traceData = JSON.toByteArray((Object)args[4]);
            TraceResource trace = this.fSubSystem.findTrace(args[0].toString(), args[1].toString(), args[2].toString());
            if (trace != null) {
                TraceConfig conf = trace.getTraceConfig();
                FileOutputStream fos = null;
                if (conf != null && !"network".equals(conf.getTracePath())) {
                    String fileName = String.valueOf(conf.getTracePath()) + "/" + args[3].toString();
                    try {
                        fos = new FileOutputStream(fileName, true);
                        fos.write(traceData);
                        fos.close();
                    }
                    catch (FileNotFoundException e) {
                        SystemBasePlugin.logError((String)"DownloadProxy", (Throwable)e);
                    }
                    catch (IOException e) {
                        SystemBasePlugin.logError((String)"DownloadProxy", (Throwable)e);
                    }
                }
            }
        }
    }

    public void handleUnwriteTraceDataEvent(byte[] data) {
        try {
            Object[] args = null;
            args = JSON.parseSequence((byte[])data);
            TraceResource trace = this.fSubSystem.findTrace(args[0].toString(), args[1].toString(), args[2].toString());
            if (trace != null) {
                trace.isUst();
            }
        }
        catch (IOException e) {
            SystemBasePlugin.logError((String)"DownloadProxy", (Throwable)e);
        }
    }

    public void handleTraceDoneEvent(byte[] data) {
    }
}

