/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.ctf.core.event.metadata;

import java.util.HashMap;
import org.eclipse.linuxtools.ctf.core.event.metadata.exceptions.ParseException;
import org.eclipse.linuxtools.ctf.core.event.types.EnumDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.IDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.StructDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.VariantDeclaration;

public class DeclarationScope {
    private DeclarationScope parentScope = null;
    private final HashMap<String, StructDeclaration> structs = new HashMap();
    private final HashMap<String, EnumDeclaration> enums = new HashMap();
    private final HashMap<String, VariantDeclaration> variants = new HashMap();
    private final HashMap<String, IDeclaration> types = new HashMap();

    public DeclarationScope() {
    }

    public DeclarationScope(DeclarationScope parentScope) {
        this.parentScope = parentScope;
    }

    public DeclarationScope getParentScope() {
        return this.parentScope;
    }

    public void registerType(String name, IDeclaration declaration) throws ParseException {
        if (this.types.containsKey(name)) {
            throw new ParseException("Type " + name + " has already been defined.");
        }
        this.types.put(name, declaration);
    }

    public void registerStruct(String name, StructDeclaration declaration) throws ParseException {
        if (this.structs.containsKey(name)) {
            throw new ParseException("struct " + name + " has already been defined.");
        }
        this.structs.put(name, declaration);
        String struct_prefix = "struct ";
        this.registerType(String.valueOf(struct_prefix) + name, declaration);
    }

    public void registerEnum(String name, EnumDeclaration declaration) throws ParseException {
        if (this.lookupEnum(name) != null) {
            throw new ParseException("enum " + name + " has already been defined.");
        }
        this.enums.put(name, declaration);
        String enum_prefix = "enum ";
        this.registerType(String.valueOf(enum_prefix) + name, declaration);
    }

    public void registerVariant(String name, VariantDeclaration declaration) throws ParseException {
        if (this.lookupVariant(name) != null) {
            throw new ParseException("variant " + name + " has already been defined.");
        }
        this.variants.put(name, declaration);
        String variant_prefix = "variant ";
        this.registerType(String.valueOf(variant_prefix) + name, declaration);
    }

    public IDeclaration lookupType(String name) {
        return this.types.get(name);
    }

    public IDeclaration rlookupType(String name) {
        IDeclaration declaration = this.lookupType(name);
        if (declaration != null) {
            return declaration;
        }
        if (this.parentScope != null) {
            return this.parentScope.rlookupType(name);
        }
        return null;
    }

    public StructDeclaration lookupStruct(String name) {
        return this.structs.get(name);
    }

    public StructDeclaration rlookupStruct(String name) {
        StructDeclaration declaration = this.lookupStruct(name);
        if (declaration != null) {
            return declaration;
        }
        if (this.parentScope != null) {
            return this.parentScope.rlookupStruct(name);
        }
        return null;
    }

    public EnumDeclaration lookupEnum(String name) {
        return this.enums.get(name);
    }

    public EnumDeclaration rlookupEnum(String name) {
        EnumDeclaration declaration = this.lookupEnum(name);
        if (declaration != null) {
            return declaration;
        }
        if (this.parentScope != null) {
            return this.parentScope.rlookupEnum(name);
        }
        return null;
    }

    public VariantDeclaration lookupVariant(String name) {
        return this.variants.get(name);
    }

    public VariantDeclaration rlookupVariant(String name) {
        VariantDeclaration declaration = this.lookupVariant(name);
        if (declaration != null) {
            return declaration;
        }
        if (this.parentScope != null) {
            return this.parentScope.rlookupVariant(name);
        }
        return null;
    }
}

