/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.viewers.timeAnalysis;

import java.util.Vector;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.linuxtools.tmf.ui.viewers.timeAnalysis.GridUtil;
import org.eclipse.linuxtools.tmf.ui.viewers.timeAnalysis.ITimeAnalysisViewer;
import org.eclipse.linuxtools.tmf.ui.viewers.timeAnalysis.ITmfTimeFilterSelectionListener;
import org.eclipse.linuxtools.tmf.ui.viewers.timeAnalysis.ITmfTimeScaleSelectionListener;
import org.eclipse.linuxtools.tmf.ui.viewers.timeAnalysis.ITmfTimeSelectionListener;
import org.eclipse.linuxtools.tmf.ui.viewers.timeAnalysis.TmfTimeAnalysisProvider;
import org.eclipse.linuxtools.tmf.ui.viewers.timeAnalysis.TmfTimeFilterSelectionEvent;
import org.eclipse.linuxtools.tmf.ui.viewers.timeAnalysis.TmfTimeScaleSelectionEvent;
import org.eclipse.linuxtools.tmf.ui.viewers.timeAnalysis.TmfTimeSelectionEvent;
import org.eclipse.linuxtools.tmf.ui.viewers.timeAnalysis.dialogs.TmfTimeFilterDialog;
import org.eclipse.linuxtools.tmf.ui.viewers.timeAnalysis.dialogs.TmfTimeLegend;
import org.eclipse.linuxtools.tmf.ui.viewers.timeAnalysis.model.ITimeEvent;
import org.eclipse.linuxtools.tmf.ui.viewers.timeAnalysis.model.ITmfTimeAnalysisEntry;
import org.eclipse.linuxtools.tmf.ui.viewers.timeAnalysis.model.TimeEvent;
import org.eclipse.linuxtools.tmf.ui.viewers.timeAnalysis.widgets.ITimeDataProvider;
import org.eclipse.linuxtools.tmf.ui.viewers.timeAnalysis.widgets.TimeScaleCtrl;
import org.eclipse.linuxtools.tmf.ui.viewers.timeAnalysis.widgets.TmfTimeStatesCtrl;
import org.eclipse.linuxtools.tmf.ui.viewers.timeAnalysis.widgets.TmfTimeTipHandler;
import org.eclipse.linuxtools.tmf.ui.viewers.timeAnalysis.widgets.TraceColorScheme;
import org.eclipse.linuxtools.tmf.ui.viewers.timeAnalysis.widgets.Utils;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class TmfTimeAnalysisViewer
implements ITimeAnalysisViewer,
ITimeDataProvider,
SelectionListener {
    private long _minTimeInterval;
    private long _selectedTime;
    private long _beginTime;
    private long _endTime;
    private long _time0;
    private long _time1;
    private long _time0_;
    private long _time1_;
    private long _time0_extSynch = 0L;
    private long _time1_extSynch = 0L;
    private boolean _timeRangeFixed;
    private int _nameWidthPref = 200;
    private int _minNameWidth = 6;
    private int _nameWidth;
    private Composite _dataViewer;
    private TmfTimeStatesCtrl _stateCtrl;
    private TimeScaleCtrl _timeScaleCtrl;
    private TmfTimeTipHandler _threadTip;
    private TraceColorScheme _colors;
    private TmfTimeAnalysisProvider _utilImplm;
    private boolean _acceptSetSelAPICalls = false;
    Vector<ITmfTimeSelectionListener> widgetSelectionListners = new Vector();
    Vector<ITmfTimeScaleSelectionListener> widgetTimeScaleSelectionListners = new Vector();
    Vector<ITmfTimeFilterSelectionListener> widgetFilterSelectionListeners = new Vector();
    private boolean calendarTimeFormat = false;
    private int borderWidth = 4;
    private int timeScaleHeight = 22;

    public TmfTimeAnalysisViewer(Composite parent, TmfTimeAnalysisProvider provider) {
        this.createDataViewer(parent, provider);
    }

    @Override
    public void display(ITmfTimeAnalysisEntry[] traceArr) {
        this.modelUpdate(traceArr);
    }

    @Override
    public void display(ITmfTimeAnalysisEntry[] traceArr, long start, long end, boolean updateTimeBounds) {
        this.modelUpdate(traceArr, start, end, updateTimeBounds);
    }

    public void controlMoved(ControlEvent e) {
    }

    @Override
    public void controlResized(ControlEvent e) {
        this.resizeControls();
    }

    public void modelUpdate(ITmfTimeAnalysisEntry[] traces) {
        if (this._stateCtrl != null) {
            this.updateInternalData(traces);
            this._stateCtrl.redraw();
            this._timeScaleCtrl.redraw();
        }
    }

    public void modelUpdate(ITmfTimeAnalysisEntry[] traces, long start, long end, boolean updateTimeBounds) {
        if (this._stateCtrl != null) {
            this.updateInternalData(traces, start, end);
            if (updateTimeBounds) {
                this._timeRangeFixed = true;
                this.setStartFinishTime(this._time0_, this._time1_);
            } else {
                this._stateCtrl.redraw();
                this._timeScaleCtrl.redraw();
            }
        }
    }

    @Override
    public void itemUpdate(ITmfTimeAnalysisEntry parent, TimeEvent item) {
        if (parent != null && item != null) {
            this._stateCtrl.refreshPartial(parent, item);
            this._stateCtrl.redraw();
            this._timeScaleCtrl.redraw();
        }
    }

    public void selectionChanged() {
    }

    protected String getViewTypeStr() {
        return "viewoption.threads";
    }

    int getMarginWidth(int idx) {
        return 0;
    }

    int getMarginHeight(int idx) {
        return 0;
    }

    void loadOptions() {
        this._minTimeInterval = 1L;
        this._selectedTime = -1L;
        this._nameWidth = Utils.loadIntOption(this.getPreferenceString("namewidth"), this._nameWidthPref, this._minNameWidth, 1000);
    }

    void saveOptions() {
        Utils.saveIntOption(this.getPreferenceString("namewidth"), this._nameWidth);
    }

    protected Control createDataViewer(Composite parent, TmfTimeAnalysisProvider utilImplm) {
        this.loadOptions();
        this._utilImplm = utilImplm;
        this._colors = new TraceColorScheme();
        this._dataViewer = new Composite(parent, 0);
        this._dataViewer.setLayoutData((Object)GridUtil.createFill());
        GridLayout gl = new GridLayout();
        gl.marginHeight = this.borderWidth;
        gl.marginWidth = 0;
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 0;
        this._dataViewer.setLayout((Layout)gl);
        this._timeScaleCtrl = new TimeScaleCtrl(this._dataViewer, this._colors);
        this._timeScaleCtrl.setTimeProvider(this);
        this._timeScaleCtrl.setLayoutData(GridUtil.createHorizontalFill());
        this._timeScaleCtrl.setHeight(this.timeScaleHeight);
        this._stateCtrl = new TmfTimeStatesCtrl(this._dataViewer, this._colors, this._utilImplm);
        this._stateCtrl.setTimeProvider(this);
        this._stateCtrl.addSelectionListener(this);
        this._stateCtrl.setLayoutData(GridUtil.createFill());
        this._dataViewer.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                TmfTimeAnalysisViewer.this.resizeControls();
            }
        });
        this.resizeControls();
        this._dataViewer.update();
        this._threadTip = new TmfTimeTipHandler(parent.getShell(), this._utilImplm, this);
        this._threadTip.activateHoverHelp((Control)this._stateCtrl);
        return this._dataViewer;
    }

    public void dispose() {
        this.saveOptions();
        this._stateCtrl.dispose();
        this._dataViewer.dispose();
        this._colors.dispose();
    }

    @Override
    public void resizeControls() {
        Rectangle r = this._dataViewer.getClientArea();
        if (r.isEmpty()) {
            return;
        }
        int width = r.width;
        if (this._nameWidth > width - this._minNameWidth) {
            this._nameWidth = width - this._minNameWidth;
        }
        if (this._nameWidth < this._minNameWidth) {
            this._nameWidth = this._minNameWidth;
        }
    }

    void setTimeRange(Object[] traces) {
        this._endTime = 0L;
        this._beginTime = -1L;
        int i = 0;
        while (i < traces.length) {
            ITmfTimeAnalysisEntry entry = (ITmfTimeAnalysisEntry)traces[i];
            if (entry.getStopTime() >= entry.getStartTime() && entry.getStopTime() > 0L) {
                if (this._beginTime < 0L || entry.getStartTime() < this._beginTime) {
                    this._beginTime = entry.getStartTime();
                }
                if (entry.getStopTime() > this._endTime) {
                    this._endTime = entry.getStopTime();
                }
            }
            ++i;
        }
        if (this._beginTime < 0L) {
            this._beginTime = 0L;
        }
    }

    void setTimeBounds() {
        this._time0_ = this._beginTime;
        if (this._time0_ < 0L) {
            this._time0_ = 0L;
        }
        this._time1_ = this._endTime;
        if (!this._timeRangeFixed) {
            this._time0 = this._time0_;
            this._time1 = this._time1_;
        }
        if (this._time1 - this._time0 < this._minTimeInterval) {
            this._time1 = this._time0 + this._minTimeInterval;
        }
    }

    void updateInternalData(ITmfTimeAnalysisEntry[] traces) {
        if (traces == null) {
            traces = new ITmfTimeAnalysisEntry[]{};
        }
        this.setTimeRange(traces);
        this.refreshAllData(traces);
    }

    void updateInternalData(ITmfTimeAnalysisEntry[] traces, long start, long end) {
        if (traces == null) {
            traces = new ITmfTimeAnalysisEntry[]{};
        }
        if (start == 0L && end == 0L || start < 0L || end < 0L) {
            this.setTimeRange(traces);
        } else {
            this._beginTime = start;
            this._endTime = end;
        }
        this.refreshAllData(traces);
    }

    private void refreshAllData(ITmfTimeAnalysisEntry[] traces) {
        this.setTimeBounds();
        if (this._selectedTime < this._beginTime) {
            this._selectedTime = this._beginTime;
        } else if (this._selectedTime > this._endTime) {
            this._selectedTime = this._endTime;
        }
        this._stateCtrl.refreshData(traces);
        this.filterOutNotification();
    }

    @Override
    public void setFocus() {
        if (this._stateCtrl != null) {
            this._stateCtrl.setFocus();
        }
    }

    @Override
    public boolean isInFocus() {
        return this._stateCtrl.isInFocus();
    }

    @Override
    public ITmfTimeAnalysisEntry getSelectedTrace() {
        return this._stateCtrl.getSelectedTrace();
    }

    @Override
    public ISelection getSelection() {
        return this._stateCtrl.getSelection();
    }

    @Override
    public ISelection getSelectionTrace() {
        return this._stateCtrl.getSelectionTrace();
    }

    @Override
    public long getTime0() {
        return this._time0;
    }

    @Override
    public long getTime1() {
        return this._time1;
    }

    @Override
    public long getMinTimeInterval() {
        return this._minTimeInterval;
    }

    @Override
    public int getNameSpace() {
        return this._nameWidth;
    }

    @Override
    public void setNameSpace(int width) {
        this._nameWidth = width;
        width = this._stateCtrl.getClientArea().width;
        if (this._nameWidth > width - 6) {
            this._nameWidth = width - 6;
        }
        if (this._nameWidth < 6) {
            this._nameWidth = 6;
        }
        this._stateCtrl.adjustScrolls();
        this._stateCtrl.redraw();
        this._timeScaleCtrl.redraw();
    }

    @Override
    public int getTimeSpace() {
        int w = this._stateCtrl.getClientArea().width;
        return w - this._nameWidth;
    }

    @Override
    public long getSelectedTime() {
        return this._selectedTime;
    }

    @Override
    public long getBeginTime() {
        return this._beginTime;
    }

    @Override
    public long getEndTime() {
        return this._endTime;
    }

    @Override
    public long getMaxTime() {
        return this._time1_;
    }

    @Override
    public long getMinTime() {
        return this._time0_;
    }

    @Override
    public void setStartFinishTimeNotify(long time0, long time1) {
        this.setStartFinishTime(time0, time1);
        this.notifyStartFinishTimeSelectionListeners(time0, time1);
    }

    @Override
    public void notifyStartFinishTime() {
        this.notifyStartFinishTimeSelectionListeners(this._time0, this._time1);
    }

    @Override
    public void setStartFinishTime(long time0, long time1) {
        this._time0 = time0;
        if (this._time0 < this._time0_) {
            this._time0 = this._time0_;
        }
        if (this._time0 > this._time1_) {
            this._time0 = this._time1_;
        }
        this._time1 = time1;
        if (this._time1 < this._time0_) {
            this._time1 = this._time0_;
        }
        if (this._time1 > this._time1_) {
            this._time1 = this._time1_;
        }
        if (this._time1 - this._time0 < this._minTimeInterval) {
            this._time1 = this._time0 + this._minTimeInterval;
        }
        this._timeRangeFixed = true;
        this._stateCtrl.adjustScrolls();
        this._stateCtrl.redraw();
        this._timeScaleCtrl.redraw();
    }

    @Override
    public void resetStartFinishTime() {
        this.setStartFinishTimeNotify(this._time0_, this._time1_);
        this._timeRangeFixed = false;
    }

    @Override
    public void setSelectedTimeInt(long time, boolean ensureVisible) {
        this._selectedTime = time;
        if (this._selectedTime > this._endTime) {
            this._endTime = this._selectedTime;
            this._time1_ = this._selectedTime;
        }
        if (this._selectedTime < this._beginTime) {
            this._beginTime = this._selectedTime;
            this._time0_ = this._selectedTime;
        }
        long time0 = this._time0;
        long time1 = this._time1;
        if (ensureVisible) {
            double timeSpace = (double)(this._time1 - this._time0) * 0.02;
            double timeMid = (double)(this._time1 - this._time0) * 0.1;
            if ((double)this._selectedTime < (double)this._time0 + timeSpace) {
                long dt = (long)((double)(this._time0 - this._selectedTime) + timeMid);
                this._time0 -= dt;
                this._time1 -= dt;
            } else if ((double)this._selectedTime > (double)this._time1 - timeSpace) {
                long dt = (long)((double)(this._selectedTime - this._time1) + timeMid);
                this._time0 += dt;
                this._time1 += dt;
            }
            if (this._time0 < this._time0_) {
                this._time1 = Math.min(this._time1_, this._time1 + (this._time0_ - this._time0));
                this._time0 = this._time0_;
            } else if (this._time1 > this._time1_) {
                this._time0 = Math.max(this._time0_, this._time0 - (this._time1 - this._time1_));
                this._time1 = this._time1_;
            }
        }
        if (this._time1 - this._time0 < this._minTimeInterval) {
            this._time1 = this._time0 + this._minTimeInterval;
        }
        this._stateCtrl.adjustScrolls();
        this._stateCtrl.redraw();
        this._timeScaleCtrl.redraw();
        if (time0 != this._time0 || time1 != this._time1) {
            this.notifyStartFinishTimeSelectionListeners(this._time0, this._time1);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.notifySelectionListeners(TmfTimeSelectionEvent.type.WIDGET_DEF_SEL);
    }

    public void widgetSelected(SelectionEvent e) {
        this.notifySelectionListeners(TmfTimeSelectionEvent.type.WIDGET_SEL);
    }

    @Override
    public void selectNextEvent() {
        this._stateCtrl.selectNextEvent();
    }

    @Override
    public void selectPrevEvent() {
        this._stateCtrl.selectPrevEvent();
    }

    @Override
    public void selectNextTrace() {
        this._stateCtrl.selectNextTrace();
    }

    @Override
    public void selectPrevTrace() {
        this._stateCtrl.selectPrevTrace();
    }

    @Override
    public void groupTraces(boolean on) {
        this._stateCtrl.groupTraces(on);
    }

    @Override
    public void filterTraces() {
        if (this._dataViewer == null || this._dataViewer.isDisposed()) {
            return;
        }
        if (TmfTimeFilterDialog.getTraceFilter(this._dataViewer.getShell(), this._stateCtrl.getTraces(), this._stateCtrl.getTraceFilter())) {
            this._stateCtrl.refreshData();
            this.filterOutNotification();
        }
    }

    @Override
    public void showLegend() {
        if (this._dataViewer == null || this._dataViewer.isDisposed()) {
            return;
        }
        TmfTimeLegend.open(this._dataViewer.getShell(), this._utilImplm);
    }

    public void toggleThreadsInteractionDrawing() {
        this._stateCtrl.toggleTraceInteractionDrawing();
    }

    public void setThreadJoinDrawing(boolean on) {
        this._stateCtrl.setTraceJoinDrawing(on);
    }

    public void setThreadWaitDrawing(boolean on) {
        this._stateCtrl.setTraceWaitDrawing(on);
    }

    public void setThreadReleaseDrawing(boolean on) {
        this._stateCtrl.setTraceReleaseDrawing(on);
    }

    public boolean getThreadInteractionDrawing() {
        return this._stateCtrl.getTracesInteractionDrawing();
    }

    public boolean getThreadJoinDrawing() {
        return this._stateCtrl.getTraceJoinDrawing();
    }

    public boolean getThreadWaitDrawing() {
        return this._stateCtrl.getTraceWaitDrawing();
    }

    public boolean getThreadReleaseDrawing() {
        return this._stateCtrl.getTraceReleaseDrawing();
    }

    protected void select(Object obj) {
        if (obj == null) {
            return;
        }
        boolean cfr_ignored_0 = obj instanceof ITmfTimeAnalysisEntry;
    }

    @Override
    public void zoomIn() {
        this._stateCtrl.zoomIn();
    }

    @Override
    public void zoomOut() {
        this._stateCtrl.zoomOut();
    }

    private String getPreferenceString(String string) {
        return String.valueOf(this.getViewTypeStr()) + "." + string;
    }

    @Override
    public void addWidgetSelectionListner(ITmfTimeSelectionListener listener) {
        this.widgetSelectionListners.add(listener);
    }

    @Override
    public void removeWidgetSelectionListner(ITmfTimeSelectionListener listener) {
        this.widgetSelectionListners.removeElement(listener);
    }

    @Override
    public void addWidgetTimeScaleSelectionListner(ITmfTimeScaleSelectionListener listener) {
        this.widgetTimeScaleSelectionListners.add(listener);
    }

    @Override
    public void removeWidgetTimeScaleSelectionListner(ITmfTimeScaleSelectionListener listener) {
        this.widgetTimeScaleSelectionListners.removeElement(listener);
    }

    @Override
    public void setSelectedTime(long time, boolean ensureVisible, Object source) {
        if (!this._acceptSetSelAPICalls || this == source) {
            return;
        }
        this.setSelectedTimeInt(time, ensureVisible);
    }

    @Override
    public void setSelectedEvent(ITimeEvent event, Object source) {
        if (!this._acceptSetSelAPICalls || event == null || source == this) {
            return;
        }
        ITmfTimeAnalysisEntry trace = event.getEntry();
        if (trace != null) {
            this._stateCtrl.selectItem(trace, false);
        }
        this.setSelectedTimeInt(event.getTime(), true);
    }

    @Override
    public void setSelectedTraceTime(ITmfTimeAnalysisEntry trace, long time, Object source) {
        if (!this._acceptSetSelAPICalls || trace == null || source == this) {
            return;
        }
        if (trace != null) {
            this._stateCtrl.selectItem(trace, false);
        }
        this.setSelectedTimeInt(time, true);
    }

    @Override
    public void setSelectedTrace(ITmfTimeAnalysisEntry trace) {
        if (trace == null) {
            return;
        }
        this._stateCtrl.selectItem(trace, false);
    }

    @Override
    public void setSelectVisTimeWindow(long time0, long time1, Object source) {
        if (!this._acceptSetSelAPICalls || source == this) {
            return;
        }
        this.setStartFinishTime(time0, time1);
        this.updateExtSynchTimers();
    }

    @Override
    public void setAcceptSelectionAPIcalls(boolean acceptCalls) {
        this._acceptSetSelAPICalls = acceptCalls;
    }

    private synchronized void notifySelectionListeners(TmfTimeSelectionEvent.type rtype) {
        if (this.widgetSelectionListners.size() > 0) {
            ISelection selection = this.getSelection();
            Object sel = null;
            if (selection != null && !selection.isEmpty()) {
                sel = ((IStructuredSelection)selection).getFirstElement();
            }
            if (sel != null) {
                TmfTimeSelectionEvent event = new TmfTimeSelectionEvent(this, rtype, sel, this.getSelectedTime());
                for (ITmfTimeSelectionListener listener : this.widgetSelectionListners) {
                    listener.tsfTmProcessSelEvent(event);
                }
            }
        }
    }

    public void notifyStartFinishTimeSelectionListeners(long _time0, long _time1) {
        if (this.widgetTimeScaleSelectionListners.size() > 0 && (_time0 != this._time0_extSynch || _time1 != this._time1_extSynch)) {
            TmfTimeScaleSelectionEvent event = new TmfTimeScaleSelectionEvent(this, _time0, _time1, this.getTimeSpace(), this.getSelectedTime());
            for (ITmfTimeScaleSelectionListener listener : this.widgetTimeScaleSelectionListners) {
                listener.tsfTmProcessTimeScaleEvent(event);
            }
            this.updateExtSynchTimers();
        }
    }

    private void updateExtSynchTimers() {
        this._time0_extSynch = this._time0;
        this._time1_extSynch = this._time1;
    }

    @Override
    public void setTimeCalendarFormat(boolean toAbsoluteCaltime) {
        this.calendarTimeFormat = toAbsoluteCaltime;
    }

    @Override
    public boolean isCalendarFormat() {
        return this.calendarTimeFormat;
    }

    @Override
    public int getBorderWidth() {
        return this.borderWidth;
    }

    @Override
    public void setBorderWidth(int borderWidth) {
        if (borderWidth > -1) {
            this.borderWidth = borderWidth;
            GridLayout gl = (GridLayout)this._dataViewer.getLayout();
            gl.marginHeight = borderWidth;
        }
    }

    @Override
    public int getHeaderHeight() {
        return this.timeScaleHeight;
    }

    @Override
    public void setHeaderHeight(int headerHeight) {
        if (headerHeight > -1) {
            this.timeScaleHeight = headerHeight;
            this._timeScaleCtrl.setHeight(headerHeight);
        }
    }

    @Override
    public int getItemHeight() {
        if (this._stateCtrl != null) {
            return this._stateCtrl.getItemHeight();
        }
        return 0;
    }

    @Override
    public void setItemHeight(int rowHeight) {
        if (this._stateCtrl != null) {
            this._stateCtrl.setItemHeight(rowHeight);
        }
    }

    @Override
    public void setMinimumItemWidth(int width) {
        if (this._stateCtrl != null) {
            this._stateCtrl.setMinimumItemWidth(width);
        }
    }

    @Override
    public boolean isVisibleVerticalScroll() {
        if (this._stateCtrl != null) {
            this._stateCtrl.isVisibleVerticalScroll();
        }
        return false;
    }

    @Override
    public void setVisibleVerticalScroll(boolean visibleVerticalScroll) {
        if (this._stateCtrl != null) {
            this._stateCtrl.setVisibleVerticalScroll(visibleVerticalScroll);
        }
    }

    @Override
    public void setNameWidthPref(int width) {
        this._nameWidthPref = width;
        if (width == 0) {
            this._minNameWidth = 0;
            this._nameWidth = 0;
        }
    }

    @Override
    public int getNameWidthPref(int width) {
        return this._nameWidthPref;
    }

    @Override
    public void addFilterSelectionListner(ITmfTimeFilterSelectionListener listener) {
        this.widgetFilterSelectionListeners.add(listener);
    }

    @Override
    public void removeFilterSelectionListner(ITmfTimeFilterSelectionListener listener) {
        this.widgetFilterSelectionListeners.remove(listener);
    }

    private void filterOutNotification() {
        TmfTimeFilterSelectionEvent event = new TmfTimeFilterSelectionEvent(this);
        event.setFilteredOut(this._stateCtrl.getFilteredOut());
        for (ITmfTimeFilterSelectionListener listener : this.widgetFilterSelectionListeners) {
            listener.tmfTaProcessFilterSelection(event);
        }
    }

    @Override
    public Control getControl() {
        return this._stateCtrl;
    }

    @Override
    public ISelectionProvider getSelectionProvider() {
        return this._stateCtrl;
    }

    @Override
    public void waitCursor(boolean waitInd) {
        this._stateCtrl.waitCursor(waitInd);
    }
}

