/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.project.model;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.linuxtools.tmf.event.TmfEvent;
import org.eclipse.linuxtools.tmf.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfExperimentElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfExperimentFolder;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfProjectElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfProjectModelElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.ui.IActionFilter;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource2;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class TmfTraceElement
extends TmfProjectModelElement
implements IActionFilter,
IPropertySource2 {
    public static final QualifiedName TRACEBUNDLE = new QualifiedName("org.eclipse.linuxtools.tmf", "tracetype.bundle");
    public static final QualifiedName TRACETYPE = new QualifiedName("org.eclipse.linuxtools.tmf", "tracetype.id");
    public static final QualifiedName TRACEICON = new QualifiedName("org.eclipse.linuxtools.tmf", "tracetype.icon");
    public static final String TYPE = "type";
    public static final String ID = "id";
    public static final String CATEGORY = "category";
    public static final String NAME = "name";
    public static final String TRACE_TYPE = "trace_type";
    public static final String EVENT_TYPE = "event_type";
    public static final String ICON = "icon";
    public static final String DEFAULT_EDITOR = "defaultEditor";
    public static final String EVENTS_TABLE_TYPE = "eventsTableType";
    public static final String CLASS = "class";
    public static final String BUNDLE = "bundle";
    public static final String IS_LINKED = "isLinked";
    private static final String sfInfoCategory = "Info";
    private static final String sfName = "name";
    private static final String sfPath = "path";
    private static final String sfLocation = "location";
    private static final String sfEventType = "type";
    private static final String sfIsLinked = "linked";
    private static final TextPropertyDescriptor sfNameDescriptor = new TextPropertyDescriptor((Object)"name", "name");
    private static final TextPropertyDescriptor sfPathDescriptor = new TextPropertyDescriptor((Object)"path", "path");
    private static final TextPropertyDescriptor sfLocationDescriptor = new TextPropertyDescriptor((Object)"location", "location");
    private static final TextPropertyDescriptor sfTypeDescriptor = new TextPropertyDescriptor((Object)"type", "type");
    private static final TextPropertyDescriptor sfIsLinkedDescriptor = new TextPropertyDescriptor((Object)"linked", "linked");
    private static final IPropertyDescriptor[] sfDescriptors = new IPropertyDescriptor[]{sfNameDescriptor, sfPathDescriptor, sfLocationDescriptor, sfTypeDescriptor, sfIsLinkedDescriptor};
    private String fTraceTypeId = null;
    private static final Map<String, IConfigurationElement> sfTraceTypeAttributes;
    private static final Map<String, IConfigurationElement> sfTraceCategories;

    static {
        sfNameDescriptor.setCategory(sfInfoCategory);
        sfPathDescriptor.setCategory(sfInfoCategory);
        sfLocationDescriptor.setCategory(sfInfoCategory);
        sfTypeDescriptor.setCategory(sfInfoCategory);
        sfIsLinkedDescriptor.setCategory(sfInfoCategory);
        sfTraceTypeAttributes = new HashMap<String, IConfigurationElement>();
        sfTraceCategories = new HashMap<String, IConfigurationElement>();
    }

    public static void init() {
        IConfigurationElement[] config;
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.linuxtools.tmf.tracetype");
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            String attribute = ce.getName();
            if (attribute.equals("type")) {
                String traceTypeId = ce.getAttribute(ID);
                sfTraceTypeAttributes.put(traceTypeId, ce);
            } else if (attribute.equals(CATEGORY)) {
                String categoryId = ce.getAttribute(ID);
                sfTraceCategories.put(categoryId, ce);
            }
            ++n2;
        }
    }

    public TmfTraceElement(String name, IResource trace, TmfTraceFolder parent) {
        this(name, trace, (TmfProjectModelElement)parent);
    }

    public TmfTraceElement(String name, IResource trace, TmfExperimentElement parent) {
        this(name, trace, (TmfProjectModelElement)parent);
    }

    private TmfTraceElement(String name, IResource trace, TmfProjectModelElement parent) {
        super(name, trace, parent);
        parent.addChild(this);
        this.refreshTraceType();
    }

    public String getTraceType() {
        return this.fTraceTypeId;
    }

    public void refreshTraceType() {
        try {
            this.fTraceTypeId = this.getResource().getPersistentProperty(TRACETYPE);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public ITmfTrace<?> instantiateTrace() {
        try {
            if (this.fTraceTypeId != null) {
                IConfigurationElement ce = sfTraceTypeAttributes.get(this.fTraceTypeId);
                ITmfTrace trace = (ITmfTrace)ce.createExecutableExtension(TRACE_TYPE);
                return trace;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return null;
    }

    public TmfEvent instantiateEvent() {
        try {
            if (this.fTraceTypeId != null) {
                IConfigurationElement ce = sfTraceTypeAttributes.get(this.fTraceTypeId);
                TmfEvent event = (TmfEvent)ce.createExecutableExtension(EVENT_TYPE);
                return event;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String getEditorId() {
        IConfigurationElement ce;
        IConfigurationElement[] defaultEditorCE;
        if (this.fTraceTypeId != null && (defaultEditorCE = (ce = sfTraceTypeAttributes.get(this.fTraceTypeId)).getChildren(DEFAULT_EDITOR)).length == 1) {
            return defaultEditorCE[0].getAttribute(ID);
        }
        return null;
    }

    public boolean testAttribute(Object target, String name, String value) {
        if (name.equals(IS_LINKED)) {
            boolean isLinked = this.getResource().isLinked();
            return Boolean.toString(isLinked).equals(value);
        }
        return false;
    }

    @Override
    public TmfProjectElement getProject() {
        if (this.getParent() instanceof TmfTraceFolder) {
            TmfTraceFolder folder = (TmfTraceFolder)this.getParent();
            TmfProjectElement project = (TmfProjectElement)folder.getParent();
            return project;
        }
        if (this.getParent() instanceof TmfExperimentElement) {
            TmfExperimentElement experiment = (TmfExperimentElement)this.getParent();
            TmfExperimentFolder folder = (TmfExperimentFolder)experiment.getParent();
            TmfProjectElement project = (TmfProjectElement)folder.getParent();
            return project;
        }
        return null;
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return sfDescriptors;
    }

    public Object getPropertyValue(Object id) {
        if ("name".equals(id)) {
            return this.getName();
        }
        if (sfPath.equals(id)) {
            return this.getPath().toString();
        }
        if (sfLocation.equals(id)) {
            return this.getLocation().toString();
        }
        if (sfIsLinked.equals(id)) {
            return Boolean.valueOf(this.getResource().isLinked()).toString();
        }
        if ("type".equals(id) && this.fTraceTypeId != null) {
            IConfigurationElement ce = sfTraceTypeAttributes.get(this.fTraceTypeId);
            return ce != null ? String.valueOf(this.getCategory(ce)) + " : " + ce.getAttribute("name") : "";
        }
        return null;
    }

    private String getCategory(IConfigurationElement ce) {
        IConfigurationElement category;
        String categoryId = ce.getAttribute(CATEGORY);
        if (categoryId != null && (category = sfTraceCategories.get(categoryId)) != null && !category.equals((Object)"")) {
            return category.getAttribute("name");
        }
        return "[no category]";
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }

    public boolean isPropertyResettable(Object id) {
        return false;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }
}

