/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.parsers;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.linuxtools.tmf.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.ui.parsers.IParserProvider;
import org.eclipse.linuxtools.tmf.ui.viewers.events.TmfEventsTable;
import org.eclipse.swt.widgets.Composite;

public class ParserProviderManager {
    public static final QualifiedName PARSER_PROPERTY = new QualifiedName("org.eclipse.linuxtools.tmf.ui", "PARSER");
    private static List<IParserProvider> fParserProviders = new ArrayList<IParserProvider>();

    public static void init() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] extensions = reg.getConfigurationElementsFor("org.eclipse.linuxtools.tmf.ui.parserProviders");
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement element = extensions[i];
            try {
                IParserProvider parserProvider = (IParserProvider)element.createExecutableExtension("class");
                ParserProviderManager.addParserProvider(parserProvider);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    public static void addParserProvider(IParserProvider parserProvider) {
        fParserProviders.add(parserProvider);
    }

    public static void removeParserProvider(IParserProvider parserProvider) {
        fParserProviders.remove(parserProvider);
    }

    public static ITmfTrace getTrace(IResource resource) {
        if (resource == null) {
            return null;
        }
        try {
            IContentType contentType;
            String parser = resource.getPersistentProperty(PARSER_PROPERTY);
            if (parser != null) {
                for (IParserProvider parserProvider : fParserProviders) {
                    ITmfTrace<?> trace;
                    if (parserProvider == null || (trace = parserProvider.getTraceForParser(parser, resource)) == null) continue;
                    return trace;
                }
            }
            if ((contentType = Platform.getContentTypeManager().findContentTypeFor(resource.getName())) != null) {
                for (IParserProvider parserProvider : fParserProviders) {
                    ITmfTrace<?> trace;
                    if (parserProvider == null || (trace = parserProvider.getTraceForContentType(contentType.getId(), resource)) == null) continue;
                    resource.setPersistentProperty(PARSER_PROPERTY, trace.getClass().getCanonicalName());
                    return trace;
                }
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String getEditorId(IResource resource) {
        if (resource == null) {
            return null;
        }
        try {
            String parser = resource.getPersistentProperty(PARSER_PROPERTY);
            if (parser != null) {
                for (IParserProvider parserProvider : fParserProviders) {
                    String editorId;
                    if (parserProvider == null || (editorId = parserProvider.getEditorIdForParser(parser)) == null) continue;
                    return editorId;
                }
            }
            return "org.eclipse.linuxtools.tmf.ui.editors.events";
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Map<String, Map<String, String>> getParserMap() {
        LinkedHashMap<String, Map<String, String>> parserMap = new LinkedHashMap<String, Map<String, String>>();
        for (IParserProvider parserProvider : fParserProviders) {
            parserMap.put(parserProvider.getCategory(), parserProvider.getParserMap());
        }
        return parserMap;
    }

    public static Map<String, String> getEventTypeMapForParser(String parser) {
        for (IParserProvider parserProvider : fParserProviders) {
            Map<String, String> map = parserProvider.getEventTypeMapForParser(parser);
            if (map == null) continue;
            return map;
        }
        return new LinkedHashMap<String, String>(0);
    }

    public static String[] getFieldLabelsForEventType(String eventType) {
        for (IParserProvider parserProvider : fParserProviders) {
            String[] fieldLabels = parserProvider.getFieldLabelsForEventType(eventType);
            if (fieldLabels == null) continue;
            return fieldLabels;
        }
        return new String[0];
    }

    public static TmfEventsTable getEventsTable(ITmfTrace trace, Composite parent, int cacheSize) {
        for (IParserProvider parserProvider : fParserProviders) {
            TmfEventsTable eventsTable;
            if (parserProvider == null || (eventsTable = parserProvider.getEventsTable(trace, parent, cacheSize)) == null) continue;
            return eventsTable;
        }
        return null;
    }
}

