/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.wizards.graph;

import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.internal.Localization;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.wizards.graph.GraphFactory;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.wizards.graph.GraphModel;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.wizards.graph.SelectGraphWizard;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.forms.widgets.ColumnLayout;

public class SelectGraphWizardPage
extends WizardPage
implements Listener {
    private Button[] btnGraphs;
    private Label lblDesc;
    private SelectGraphWizard wizard;

    public SelectGraphWizardPage() {
        super("selectGraph");
        this.setTitle(Localization.getString("SelectGraphWizardPage.SelectGraph"));
        this.btnGraphs = null;
    }

    public void createControl(Composite parent) {
        this.wizard = (SelectGraphWizard)this.getWizard();
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new FormLayout());
        FormData data1 = new FormData();
        data1.left = new FormAttachment(0, 0);
        data1.top = new FormAttachment(0, 0);
        data1.right = new FormAttachment(40, 0);
        data1.bottom = new FormAttachment(100, 0);
        Composite cmpGraphOpts = new Composite(comp, 0);
        cmpGraphOpts.setLayoutData((Object)data1);
        ColumnLayout colLayout = new ColumnLayout();
        colLayout.maxNumColumns = 1;
        cmpGraphOpts.setLayout((Layout)colLayout);
        String[] graphIDs = GraphFactory.getAvailableGraphs(this.wizard.model.getDataSet());
        this.btnGraphs = new Button[graphIDs.length];
        int i = 0;
        while (i < this.btnGraphs.length) {
            this.btnGraphs[i] = new Button(cmpGraphOpts, 0);
            this.btnGraphs[i].setImage(GraphFactory.getGraphImage(graphIDs[i]));
            this.btnGraphs[i].addListener(13, (Listener)this);
            this.btnGraphs[i].setData((Object)graphIDs[i]);
            ++i;
        }
        FormData data2 = new FormData();
        data2.left = new FormAttachment((Control)cmpGraphOpts);
        data2.top = new FormAttachment(0, 0);
        data2.right = new FormAttachment(100, 0);
        data2.bottom = new FormAttachment(100, 0);
        this.lblDesc = new Label(comp, 64);
        this.lblDesc.setLayoutData((Object)data2);
        this.setControl((Control)comp);
    }

    public void handleEvent(Event event) {
        if (event.widget instanceof Button) {
            Button target = (Button)event.widget;
            int i = 0;
            while (i < this.btnGraphs.length) {
                if (target == this.btnGraphs[i]) {
                    this.lblDesc.setText(String.valueOf(GraphFactory.getGraphName(this.btnGraphs[i].getData().toString())) + "\n\n" + GraphFactory.getGraphDescription(this.btnGraphs[i].getData().toString()));
                    this.saveDataToModel(this.btnGraphs[i].getData().toString());
                    this.wizard.getContainer().updateButtons();
                }
                ++i;
            }
        }
    }

    public IWizardPage getNextPage() {
        return this.wizard.selectSeriesPage;
    }

    public boolean canFlipToNextPage() {
        return this.wizard.model.isGraphSet();
    }

    private void saveDataToModel(String selected) {
        GraphModel model = this.wizard.model;
        model.setGraph(selected);
        this.wizard.selectSeriesPage.setKeyEnablement(GraphFactory.isKeyRequired(model.getGraphID(), model.getDataSet()), GraphFactory.isKeyOptional(model.getGraphID(), model.getDataSet()));
    }

    public void dispose() {
        super.dispose();
        if (this.btnGraphs != null) {
            int i = 0;
            while (i < this.btnGraphs.length) {
                this.btnGraphs[i] = null;
                ++i;
            }
        }
        this.btnGraphs = null;
        this.lblDesc = null;
    }
}

