/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.graphing.views;

import java.util.ArrayList;
import org.eclipse.linuxtools.systemtap.ui.graphing.structures.GraphDisplaySet;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.nonui.datasets.IDataSet;
import org.eclipse.linuxtools.systemtap.ui.logging.LogManager;
import org.eclipse.linuxtools.systemtap.ui.structures.listeners.ITabListener;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.ViewPart;

public class GraphSelectorView
extends ViewPart {
    private CTabFolder scriptFolder;
    private ArrayList<GraphDisplaySet> displaySets;
    private ArrayList<ITabListener> tabListeners;
    public static final String ID = "org.eclipse.linuxtools.systemtap.ui.graphing.views.GraphSelectorView";

    public GraphSelectorView() {
        LogManager.logDebug((String)"Start GraphSelectorView:", (Object)((Object)this));
        LogManager.logInfo((String)"Initializing", (Object)((Object)this));
        this.displaySets = new ArrayList();
        this.tabListeners = new ArrayList();
        LogManager.logDebug((String)"End GraphSelectorView:", (Object)((Object)this));
    }

    public void createScriptSet(String title, IDataSet dataSet) {
        CTabItem item = new CTabItem(this.scriptFolder, 64);
        item.setText(title);
        Composite parent = new Composite((Composite)this.scriptFolder, 0);
        parent.setBackground(new Color((Device)parent.getDisplay(), 0, 0, 255));
        GraphDisplaySet gds = new GraphDisplaySet(parent, dataSet);
        this.displaySets.add(gds);
        item.setControl((Control)parent);
        this.scriptFolder.setSelection(item);
        this.fireTabOpenEvent();
    }

    public void createPartControl(Composite parent) {
        LogManager.logDebug((String)("Start createPartControl: parent-" + parent), (Object)((Object)this));
        FormData data2 = new FormData();
        data2.left = new FormAttachment(0, 0);
        data2.top = new FormAttachment(0, 0);
        data2.right = new FormAttachment(100, 0);
        data2.bottom = new FormAttachment(100, 0);
        Composite cmpGraph = new Composite(parent, 0);
        cmpGraph.setLayoutData((Object)data2);
        cmpGraph.setLayout((Layout)new FormLayout());
        this.scriptFolder = new CTabFolder(cmpGraph, 0);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, 0);
        this.scriptFolder.setLayoutData((Object)data);
        this.scriptFolder.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GraphSelectorView.this.fireTabChangedEvent();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.scriptFolder.addCTabFolder2Listener(new CTabFolder2Listener(){

            public void restore(CTabFolderEvent e) {
            }

            public void showList(CTabFolderEvent e) {
            }

            public void minimize(CTabFolderEvent e) {
            }

            public void maximize(CTabFolderEvent e) {
            }

            public void close(CTabFolderEvent e) {
                GraphSelectorView.this.displaySets.remove(GraphSelectorView.this.scriptFolder.indexOf((CTabItem)e.item));
                GraphSelectorView.this.fireTabCloseEvent();
            }
        });
        LogManager.logDebug((String)"End createPartControl", (Object)((Object)this));
    }

    public GraphDisplaySet getActiveDisplaySet() {
        int index = this.scriptFolder.getSelectionIndex();
        if (index >= 0 && index < this.displaySets.size()) {
            return this.displaySets.get(index);
        }
        return null;
    }

    public void setFocus() {
    }

    public void addTabListener(ITabListener listener) {
        this.tabListeners.add(listener);
    }

    public void removeTabListener(ITabListener listener) {
        this.tabListeners.remove(listener);
    }

    private void fireTabCloseEvent() {
        int i = 0;
        while (i < this.tabListeners.size()) {
            this.tabListeners.get(i).tabClosed();
            ++i;
        }
    }

    private void fireTabOpenEvent() {
        int i = 0;
        while (i < this.tabListeners.size()) {
            this.tabListeners.get(i).tabOpened();
            ++i;
        }
    }

    private void fireTabChangedEvent() {
        int i = 0;
        while (i < this.tabListeners.size()) {
            this.tabListeners.get(i).tabChanged();
            ++i;
        }
    }

    public void dispose() {
        LogManager.logDebug((String)"Start dispose:", (Object)((Object)this));
        LogManager.logInfo((String)"Disposing", (Object)((Object)this));
        super.dispose();
        if (this.scriptFolder != null) {
            this.scriptFolder.dispose();
        }
        this.scriptFolder = null;
        if (this.tabListeners != null) {
            this.tabListeners.removeAll(this.tabListeners);
        }
        this.tabListeners = null;
        LogManager.logDebug((String)"End dispose:", (Object)((Object)this));
    }
}

