/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.control;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.linuxtools.lttng.control.LttngSyntheticEventProvider;
import org.eclipse.linuxtools.lttng.event.LttngSyntheticEvent;
import org.eclipse.linuxtools.lttng.model.LTTngTreeNode;

public class LttngCoreProviderFactory {
    public static final int STATISTICS_LTTNG_SYTH_EVENT_PROVIDER = 0;
    public static final int CONTROL_FLOW_LTTNG_SYTH_EVENT_PROVIDER = 1;
    public static final int RESOURCE_LTTNG_SYTH_EVENT_PROVIDER = 2;
    private static final Map<Integer, LttngSyntheticEventProvider> fSyntheticEventProviders = new HashMap<Integer, LttngSyntheticEventProvider>();

    public static void initialize() {
        LttngCoreProviderFactory.getEventProvider(0);
        LttngCoreProviderFactory.getEventProvider(1);
        LttngCoreProviderFactory.getEventProvider(2);
    }

    public static LttngSyntheticEventProvider getEventProvider(int providerId) {
        if (!fSyntheticEventProviders.containsKey(providerId)) {
            LttngSyntheticEventProvider synEventProvider = new LttngSyntheticEventProvider(LttngSyntheticEvent.class);
            fSyntheticEventProviders.put(providerId, synEventProvider);
        }
        return fSyntheticEventProviders.get(providerId);
    }

    public static void reset(LTTngTreeNode experimentNode) {
        for (LttngSyntheticEventProvider provider : fSyntheticEventProviders.values()) {
            provider.reset(experimentNode);
        }
    }
}

