/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.callgraph.graphlisteners;

import org.eclipse.linuxtools.callgraph.StapGraph;

public class AutoScrollHelper {
    public static void scrollUp(StapGraph graph) {
        if (graph.getDrawMode() == 0) {
            int parent = graph.getNodeData((int)graph.getRootVisibleNodeNumber()).parent;
            if (graph.isCollapseMode()) {
                parent = graph.getNodeData((int)graph.getRootVisibleNodeNumber()).collapsedParent;
            }
            if (graph.getNodeData(parent) != null && graph.getNodeData((int)parent).levelOfRecursion > 0) {
                int animMode = graph.getAnimationMode();
                graph.draw(graph.getDrawMode(), 3, parent);
                graph.setAnimationMode(animMode);
            }
        } else if (graph.getDrawMode() == 2) {
            graph.shrinkTree();
        }
    }

    public static void scrollDown(StapGraph graph) {
        if (graph.getDrawMode() == 0) {
            if (graph.getTopLevel() + StapGraph.levelBuffer < graph.getLowestLevelOfNodesAdded()) {
                int newLevel = graph.getTopLevel() + 1;
                if (graph.levels.get(newLevel).get(0) == null) {
                    return;
                }
                graph.setTopLevelTo(newLevel);
                int animMode = graph.getAnimationMode();
                graph.setAnimationMode(3);
                graph.draw(graph.getDrawMode(), 3, graph.levels.get(newLevel).get(0));
                graph.setAnimationMode(animMode);
            }
        } else if (graph.getDrawMode() == 2) {
            graph.extendTree();
        }
    }
}

