/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.callgraph.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class XMLParser {
    private HashMap<Integer, HashMap<String, String>> keyValues;
    private ArrayList<Integer> idList;
    private int id = 0;
    private int currentlyIn = 0;
    private static final String ATTR_NAME = "name";
    private static final String ATTR_TEXT = "text";
    public static final String noName = "NoName";
    private boolean textMode;
    private int counter;

    XMLParser() {
        if (this.keyValues != null) {
            this.keyValues.clear();
        }
        this.keyValues = new HashMap();
        if (this.idList != null) {
            this.idList.clear();
        }
        this.idList = new ArrayList();
        this.textMode = false;
        this.counter = 0;
    }

    public void parse(File file) {
        this.parse(XMLParser.getContents(file));
    }

    public void parse(String message) {
        String[] lines;
        String tabstrip = message.replaceAll("\t", "");
        String[] stringArray = lines = tabstrip.split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.length() >= 1) {
                String[] tokens;
                if (line.charAt(0) == '<') {
                    HashMap<String, String> map;
                    if (line.charAt(1) == '/') {
                        this.idList.remove((Object)this.currentlyIn);
                        this.currentlyIn = -1;
                        if (this.idList.size() > 0) {
                            this.currentlyIn = this.idList.get(this.idList.size() - 1);
                        }
                        this.setTextMode(true);
                    } else if (line.substring(line.length() - 2, line.length() - 1) == "/>") {
                        ++this.id;
                        tokens = line.split(" ");
                        map = new HashMap<String, String>();
                        map.put(ATTR_NAME, tokens[0]);
                        this.keyValues.put(this.id, map);
                        this.textMode = false;
                        this.addAttributes(this.currentlyIn, tokens, 1);
                    } else {
                        this.idList.add(this.id);
                        this.currentlyIn = ++this.id;
                        tokens = line.split(" ");
                        map = new HashMap();
                        map.put(ATTR_NAME, tokens[0]);
                        this.keyValues.put(this.id, map);
                        this.addAttributes(this.currentlyIn, tokens, 1);
                    }
                } else if (this.currentlyIn >= 0) {
                    if (this.textMode) {
                        HashMap<String, String> map = this.keyValues.get(this.currentlyIn);
                        map.put(ATTR_TEXT, line);
                        ++this.counter;
                    }
                    tokens = line.split(" ");
                    this.addAttributes(this.currentlyIn, tokens, 0);
                }
            }
            ++n2;
        }
    }

    public void addAttributes(int id, String[] tokens, int start) {
        HashMap<String, String> map = this.keyValues.get(id);
        int nameless = 0;
        int j = start;
        while (j < tokens.length) {
            String[] kvPair = tokens[j].split("=");
            String value = "";
            String key = "";
            if (kvPair.length >= 1) {
                if (kvPair.length < 2) {
                    value = kvPair[0];
                    if (value.charAt(value.length() - 1) == '>') {
                        this.setTextMode(true);
                        value = value.substring(0, value.length() - 1);
                    }
                    map.put(noName + nameless, value);
                    ++nameless;
                } else {
                    value = kvPair[0];
                    key = kvPair[1];
                    if (value.charAt(value.length() - 1) == '>') {
                        this.setTextMode(true);
                        value = value.substring(0, value.length() - 1);
                    }
                    map.put(key, value);
                }
            }
            ++j;
        }
        this.keyValues.put(id, map);
    }

    public HashMap<Integer, HashMap<String, String>> getKeyValues() {
        return this.keyValues;
    }

    public static String getContents(File file) {
        StringBuilder contents = new StringBuilder();
        try {
            BufferedReader input = new BufferedReader(new FileReader(file));
            try {
                String line = null;
                while ((line = input.readLine()) != null) {
                    contents.append(line);
                    contents.append("\n");
                }
            }
            finally {
                input.close();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return contents.toString();
    }

    public void setTextMode(boolean val) {
        this.counter = 0;
        this.textMode = val;
    }
}

