/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.core.state.evProcessor.state;

import org.eclipse.linuxtools.lttng.core.TraceDebug;
import org.eclipse.linuxtools.lttng.core.event.LttngEvent;
import org.eclipse.linuxtools.lttng.core.state.StateStrings;
import org.eclipse.linuxtools.lttng.core.state.evProcessor.ILttngEventProcessor;
import org.eclipse.linuxtools.lttng.core.state.evProcessor.state.AbsStateProcessing;
import org.eclipse.linuxtools.lttng.core.state.model.LTTngCPUState;
import org.eclipse.linuxtools.lttng.core.state.model.LttngBdevState;
import org.eclipse.linuxtools.lttng.core.state.model.LttngExecutionState;
import org.eclipse.linuxtools.lttng.core.state.model.LttngIRQState;
import org.eclipse.linuxtools.lttng.core.state.model.LttngProcessState;
import org.eclipse.linuxtools.lttng.core.state.model.LttngTraceState;
import org.eclipse.linuxtools.tmf.core.event.ITmfTimestamp;

public abstract class AbsStateUpdate
extends AbsStateProcessing
implements ILttngEventProcessor {
    protected static final Long ANY_CPU = 0L;

    protected void push_state(Long cpu, StateStrings.ExecutionMode execMode, String submode, int subModeId, ITmfTimestamp eventTime, LttngTraceState traceSt) {
        LttngProcessState process = traceSt.getRunning_process().get(cpu);
        LttngExecutionState exe_state = new LttngExecutionState();
        exe_state.setExec_mode(execMode);
        exe_state.setExec_submode(submode);
        exe_state.setExec_submode_id(subModeId);
        exe_state.setEntry_Time(eventTime.getValue());
        exe_state.setChange_Time(eventTime.getValue());
        exe_state.setCum_cpu_time(0L);
        exe_state.setProc_status(process.getState().getProc_status());
        process.pushToExecutionStack(exe_state);
    }

    protected void pop_state(Long cpu, StateStrings.ExecutionMode execMode, LttngTraceState traceSt, ITmfTimestamp eventTime) {
        LttngProcessState process = traceSt.getRunning_process().get(cpu);
        if (!process.getState().getExec_mode().equals((Object)execMode)) {
            TraceDebug.debug("Different Execution Mode type \n\tTime:" + eventTime.toString() + "\n\tprocess state has: \n\t" + process.getState().getExec_mode().toString() + "\n\twhen pop_int is:\n\t" + execMode.toString());
            return;
        }
        process.popFromExecutionStack();
        process.getState().setChange_Time(eventTime.getValue());
    }

    protected void irq_push_mode(LttngIRQState irqst, StateStrings.IRQMode state) {
        irqst.pushToIrqStack(state);
    }

    protected void irq_set_base_mode(LttngIRQState irqst, StateStrings.IRQMode state) {
        irqst.clearAndSetBaseToIrqStack(state);
    }

    protected void irq_pop_mode(LttngIRQState irqst) {
        irqst.popFromIrqStack();
    }

    protected void cpu_push_mode(LTTngCPUState cpust, StateStrings.CpuMode state) {
        cpust.pushToCpuStack(state);
    }

    protected void cpu_pop_mode(LTTngCPUState cpust) {
        cpust.popFromCpuStack();
    }

    protected void cpu_set_base_mode(LTTngCPUState cpust, StateStrings.CpuMode state) {
        cpust.clearAndSetBaseToCpuStack(state);
    }

    protected void bdev_pop_mode(LttngBdevState bdevst) {
        bdevst.popFromBdevStack();
    }

    protected void push_function(LttngTraceState traceSt, Long funcptr, Long cpu) {
        LttngProcessState process = traceSt.getRunning_process().get(cpu);
        process.pushToUserStack(funcptr);
        process.setCurrent_function(funcptr);
    }

    protected void pop_function(LttngTraceState traceSt, LttngEvent trcEvent, Long funcptr) {
        Long cpu = trcEvent.getCpuId();
        LttngProcessState process = traceSt.getRunning_process().get(cpu);
        Long curr_function = process.getCurrent_function();
        if (curr_function != null && !curr_function.equals(funcptr)) {
            TraceDebug.debug("Different functions: " + funcptr + " current: " + curr_function + " time stamp: " + trcEvent.getTimestamp().toString());
            return;
        }
        process.popFromUserStack();
        process.setCurrent_function(process.peekFromUserStack());
    }

    protected Long mkdev(Long major, Long minor) {
        Long result = null;
        if (major != null && minor != null) {
            result = major << 20 | minor;
        }
        return result;
    }

    protected boolean exit_process(LttngTraceState ts, LttngProcessState process) {
        process.incrementFree_events();
        if (process.getFree_events() < 2L) {
            return false;
        }
        process.clearExecutionStack();
        process.clearUserStack();
        ts.removeProcessState(process);
        return true;
    }

    protected LttngProcessState create_process(LttngTraceState traceSt, Long cpu, Long pid, Long tgid, ITmfTimestamp timestamp) {
        LttngProcessState process = this.create_process(traceSt, cpu, pid, tgid, StateStrings.ProcessStatus.LTTV_STATE_UNNAMED.getInName(), timestamp);
        return process;
    }

    protected LttngProcessState create_process(LttngTraceState traceSt, Long cpu, Long pid, Long tgid, String name, ITmfTimestamp timestamp) {
        LttngProcessState process = new LttngProcessState(cpu, pid, tgid, name, timestamp.getValue(), traceSt.getTraceId());
        traceSt.addProcessState(process);
        return process;
    }

    protected LttngProcessState lttv_state_find_process_or_create(LttngTraceState ts, Long cpu, Long pid, ITmfTimestamp timestamp) {
        LttngProcessState process = this.lttv_state_find_process(ts, cpu, pid);
        if (process == null) {
            process = this.create_process(ts, cpu, pid, 0L, timestamp);
            process.popFromExecutionStack();
            LttngExecutionState es = process.getState();
            es.setExec_mode(StateStrings.ExecutionMode.LTTV_STATE_MODE_UNKNOWN);
            es.setProc_status(StateStrings.ProcessStatus.LTTV_STATE_UNNAMED);
        }
        return process;
    }
}

