/*
 * Decompiled with CFR 0.152.
 */
package groovy.servlet;

import groovy.servlet.AbstractHttpServlet;
import groovy.servlet.ServletBinding;
import groovy.text.SimpleTemplateEngine;
import groovy.text.Template;
import groovy.text.TemplateEngine;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.Date;
import java.util.Map;
import java.util.WeakHashMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TemplateServlet
extends AbstractHttpServlet {
    private final Map cache = new WeakHashMap();
    private TemplateEngine engine = null;
    private boolean generateBy = true;
    private String fileEncodingParamVal = null;
    private static final String GROOVY_SOURCE_ENCODING = "groovy.source.encoding";

    protected Template getTemplate(File file) throws ServletException {
        TemplateCacheEntry entry;
        String key = file.getAbsolutePath();
        Template template = null;
        if (this.verbose) {
            this.log("Looking for cached template by key \"" + key + "\"");
        }
        if ((entry = (TemplateCacheEntry)this.cache.get(key)) != null) {
            if (entry.validate(file)) {
                if (this.verbose) {
                    this.log("Cache hit! " + entry);
                }
                template = entry.template;
            } else if (this.verbose) {
                this.log("Cached template needs recompilation!");
            }
        } else if (this.verbose) {
            this.log("Cache miss.");
        }
        if (template == null) {
            if (this.verbose) {
                this.log("Creating new template from file " + file + "...");
            }
            String fileEncoding = this.fileEncodingParamVal != null ? this.fileEncodingParamVal : System.getProperty(GROOVY_SOURCE_ENCODING);
            Reader reader = null;
            try {
                reader = fileEncoding == null ? new FileReader(file) : new InputStreamReader((InputStream)new FileInputStream(file), fileEncoding);
                template = this.engine.createTemplate(reader);
            }
            catch (Exception e) {
                throw new ServletException("Creation of template failed: " + e, (Throwable)e);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException ignore) {}
                }
            }
            this.cache.put(key, new TemplateCacheEntry(file, template, this.verbose));
            if (this.verbose) {
                this.log("Created and added template to cache. [key=" + key + "]");
            }
        }
        if (template == null) {
            throw new ServletException("Template is null? Should not happen here!");
        }
        return template;
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.engine = this.initTemplateEngine(config);
        if (this.engine == null) {
            throw new ServletException("Template engine not instantiated.");
        }
        String value = config.getInitParameter("generated.by");
        if (value != null) {
            this.generateBy = Boolean.valueOf(value);
        }
        if ((value = config.getInitParameter(GROOVY_SOURCE_ENCODING)) != null) {
            this.fileEncodingParamVal = value;
        }
        this.log("Servlet " + this.getClass().getName() + " initialized on " + this.engine.getClass());
    }

    protected TemplateEngine initTemplateEngine(ServletConfig config) {
        String name = config.getInitParameter("template.engine");
        if (name == null) {
            return new SimpleTemplateEngine();
        }
        try {
            return (TemplateEngine)Class.forName(name).newInstance();
        }
        catch (InstantiationException e) {
            this.log("Could not instantiate template engine: " + name, e);
        }
        catch (IllegalAccessException e) {
            this.log("Could not access template engine class: " + name, e);
        }
        catch (ClassNotFoundException e) {
            this.log("Could not find template engine class: " + name, e);
        }
        return null;
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.verbose) {
            this.log("Creating/getting cached template...");
        }
        File file = super.getScriptUriAsFile(request);
        String name = file.getName();
        if (!file.exists()) {
            response.sendError(404);
            return;
        }
        if (!file.canRead()) {
            response.sendError(403, "Can not read \"" + name + "\"!");
            return;
        }
        long getMillis = System.currentTimeMillis();
        Template template = this.getTemplate(file);
        getMillis = System.currentTimeMillis() - getMillis;
        ServletBinding binding = new ServletBinding(request, response, this.servletContext);
        this.setVariables(binding);
        response.setContentType("text/html; charset=" + this.encoding);
        response.setStatus(200);
        Writer out = (Writer)binding.getVariable("out");
        if (out == null) {
            out = response.getWriter();
        }
        if (this.verbose) {
            this.log("Making template \"" + name + "\"...");
        }
        long makeMillis = System.currentTimeMillis();
        template.make(binding.getVariables()).writeTo(out);
        makeMillis = System.currentTimeMillis() - makeMillis;
        if (this.generateBy) {
            StringBuffer sb = new StringBuffer(100);
            sb.append("\n<!-- Generated by Groovy TemplateServlet [create/get=");
            sb.append(Long.toString(getMillis));
            sb.append(" ms, make=");
            sb.append(Long.toString(makeMillis));
            sb.append(" ms] -->\n");
            out.write(sb.toString());
        }
        response.flushBuffer();
        if (this.verbose) {
            this.log("Template \"" + name + "\" request responded. [create/get=" + getMillis + " ms, make=" + makeMillis + " ms]");
        }
    }

    private static class TemplateCacheEntry {
        Date date;
        long hit;
        long lastModified;
        long length;
        Template template;

        public TemplateCacheEntry(File file, Template template) {
            this(file, template, false);
        }

        public TemplateCacheEntry(File file, Template template, boolean timestamp) {
            if (file == null) {
                throw new NullPointerException("file");
            }
            if (template == null) {
                throw new NullPointerException("template");
            }
            this.date = timestamp ? new Date(System.currentTimeMillis()) : null;
            this.hit = 0L;
            this.lastModified = file.lastModified();
            this.length = file.length();
            this.template = template;
        }

        public boolean validate(File file) {
            if (file == null) {
                throw new NullPointerException("file");
            }
            if (file.lastModified() != this.lastModified) {
                return false;
            }
            if (file.length() != this.length) {
                return false;
            }
            ++this.hit;
            return true;
        }

        public String toString() {
            if (this.date == null) {
                return "Hit #" + this.hit;
            }
            return "Hit #" + this.hit + " since " + this.date;
        }
    }
}

