/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.checker;

import org.eclipse.actf.visualization.internal.engines.lowvision.checker.ColorChecker;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorIRGB;

public class W3CColorChecker
extends ColorChecker {
    private static final double THRESHOLD_Y = 125.0;
    private static final int THRESHOLD_C = 500;
    private double diffY;
    private int diffC;
    private double sevY;
    private double sevC;
    private double sevL;
    private double severity;
    private double contrastRatio;

    public W3CColorChecker(ColorIRGB colorIRGB, ColorIRGB colorIRGB2) {
        super(colorIRGB, colorIRGB2);
        int n = this.color1.getR();
        int n2 = this.color1.getG();
        int n3 = this.color1.getB();
        int n4 = this.color2.getR();
        int n5 = this.color2.getG();
        int n6 = this.color2.getB();
        double d = W3CColorChecker.calcY(n, n2, n3);
        double d2 = W3CColorChecker.calcY(n4, n5, n6);
        double d3 = W3CColorChecker.calcL(n, n2, n3);
        double d4 = W3CColorChecker.calcL(n4, n5, n6);
        this.contrastRatio = d3 > d4 ? (d3 + 0.05) / (d4 + 0.05) : (d4 + 0.05) / (d3 + 0.05);
        this.diffY = Math.abs(d - d2);
        this.diffC = Math.abs(n - n4) + Math.abs(n2 - n5) + Math.abs(n3 - n6);
        this.sevY = W3CColorChecker.calcSevY(this.diffY);
        this.sevC = W3CColorChecker.calcSevC(this.diffC);
        this.severity = this.sevL = W3CColorChecker.calcSevL(this.contrastRatio);
    }

    public W3CColorChecker(int n, int n2) {
        this(new ColorIRGB(n), new ColorIRGB(n2));
    }

    public double calcSeverity() {
        return this.severity;
    }

    public static double calcSeverity(ColorIRGB colorIRGB, ColorIRGB colorIRGB2) {
        return new W3CColorChecker(colorIRGB, colorIRGB2).calcSeverity();
    }

    public double calcLuminanceSeverity() {
        return this.sevY;
    }

    public static double calcLuminanceSeverity(ColorIRGB colorIRGB, ColorIRGB colorIRGB2) {
        return new W3CColorChecker(colorIRGB, colorIRGB2).calcLuminanceSeverity();
    }

    public double calcChrominanceSeverity() {
        return this.sevC;
    }

    public static double calcChrominanceSeverity(ColorIRGB colorIRGB, ColorIRGB colorIRGB2) {
        return new W3CColorChecker(colorIRGB, colorIRGB2).calcChrominanceSeverity();
    }

    public int calcLuminanceDifference() {
        int n = (int)Math.round(this.diffY);
        if (n < 0) {
            n = 0;
        } else if (255 < n) {
            n = 255;
        }
        return n;
    }

    public static int calcLuminanceDifference(ColorIRGB colorIRGB, ColorIRGB colorIRGB2) {
        return new W3CColorChecker(colorIRGB, colorIRGB2).calcLuminanceDifference();
    }

    public int calcChrominanceDifference() {
        return this.diffC;
    }

    public static int calcChrominanceDifference(ColorIRGB colorIRGB, ColorIRGB colorIRGB2) {
        return new W3CColorChecker(colorIRGB, colorIRGB2).calcChrominanceDifference();
    }

    private static double calcL(int n, int n2, int n3) {
        return 0.2126 * W3CColorChecker.calcRGB(n) + 0.7152 * W3CColorChecker.calcRGB(n2) + 0.0722 * W3CColorChecker.calcRGB(n3);
    }

    private static double calcY(int n, int n2, int n3) {
        return (double)(n * 299 + n2 * 587 + n3 * 114) / 1000.0;
    }

    private static double calcRGB(int n) {
        double d = (double)n / 255.0;
        if (d <= 0.03928) {
            return d / 12.92;
        }
        return Math.pow((d + 0.055) / 1.055, 2.4);
    }

    private static double calcSevY(double d) {
        double d2 = 0.0;
        if (d < 125.0) {
            d2 = -d / 125.0 + 1.0;
        }
        if (d2 < 0.0) {
            d2 = 0.0;
        } else if (1.0 < d2) {
            d2 = 1.0;
        }
        return d2;
    }

    private static double calcSevC(int n) {
        double d = 0.0;
        if (n < 500) {
            d = -((double)n) / 500.0 + 1.0;
        }
        if (d < 0.0) {
            d = 0.0;
        } else if (1.0 < d) {
            d = 1.0;
        }
        return d;
    }

    private static double calcSevL(double d) {
        double d2 = 0.0;
        if (d > 7.0) {
            return d2;
        }
        if (d < 3.0) {
            return 1.0;
        }
        return 1.0 - (d - 3.0) / 4.0;
    }

    public double calcContrast() {
        return this.contrastRatio;
    }
}

