/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision;

import org.eclipse.actf.visualization.engines.lowvision.LowVisionException;
import org.eclipse.actf.visualization.engines.lowvision.image.IPageImage;
import org.eclipse.actf.visualization.engines.lowvision.image.ImageException;
import org.eclipse.actf.visualization.internal.engines.lowvision.character.CharacterMS;
import org.eclipse.actf.visualization.internal.engines.lowvision.character.CharacterSM;
import org.eclipse.actf.visualization.internal.engines.lowvision.character.CharacterSS;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorException;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorIRGB;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorLAB;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.BinaryImage;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.ConnectedComponent;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.LineSegment;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.PageComponent;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.Topology;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.Vector3D;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.ColorProblem;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.LowVisionProblem;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.LowVisionProblemException;

public class DecisionMaker {
    public static final double THRESHOLD_MIN_CHAR_RATIO = 0.1;
    public static final double THRESHOLD_MAX_CHAR_RATIO = 10.0;
    public static final double THRESHOLD_MIN_CONTAINER_DENSITY = 0.4;
    public static final double THRESHOLD_MAX_CHARACTER_DENSITY = 0.75;
    public static final double THRESHOLD_MIN_THINNING_RATIO = 0.25;
    public static final double THRESHOLD_MIN_UNDERLINE_POSITION = 0.85;
    public static final double THRESHOLD_MIN_UNDERLINE_WIDTH_RATIO = 0.95;
    public static final double THRESHOLD_MIN_UNDERLINE_RATIO = 3.0;
    public static final int THRESHOLD_MIN_CHAR_WIDTH = 5;
    public static final int THRESHOLD_MAX_CHAR_WIDTH = 72;
    public static final int THRESHOLD_MIN_CHAR_HEIGHT = 5;
    public static final int THRESHOLD_MAX_CHAR_HEIGHT = 100;
    public static final int THRESHOLD_MAX_THINNED_BRANCHES = 8;
    public static final int THRESHOLD_MAX_THINNED_CROSSES = 8;
    public static final int THRESHOLD_MIN_MSCHAR_WIDTH = 10;
    public static final int THRESHOLD_MIN_MSCHAR_HEIGHT = 10;
    public static final int THRESHOLD_MAX_MSCHAR_HEIGHT = 100;
    public static final int THRESHOLD_MIN_SMCHAR_WIDTH = 10;
    public static final int THRESHOLD_MIN_SMCHAR_HEIGHT = 10;
    public static final int THRESHOLD_MAX_SMCHAR_HEIGHT = 100;
    public static final double THRESHOLD_FOREGROUND_RATIO = 0.25;
    public static final double THRESHOLD_FOREGROUND_ERROR_MARGIN = 1.5;
    public static final float THRESHOLD_LIMIT_BLURRED_WIDTH_RATIO = 3.0f;
    public static final float THRESHOLD_LIMIT_BLURRED_HEIGHT_RATIO = 3.0f;
    public static final int THRESHOLD_MAX_CHARACTER_SPACE = 7;
    public static final int THRESHOLD_MAX_REGION_ELEMENT_SPACE = 80;
    public static final int THRESHOLD_MAX_GROUPED_CONTAINER_WIDTH = 300;
    public static final int THRESHOLD_MAX_GROUPED_CONTAINER_HEIGHT = 300;
    public static final double SCORE_ORANGE = 0.5;
    public static final double SCORE_RED = 1.0;
    public static final float ENOUGH_DELTA_E_FOR_IMAGE = 40.0f;
    public static final float MIN_ENOUGH_DELTA_L_FOR_TEXT = 20.0f;
    public static final float MAX_ENOUGH_DELTA_L_FOR_TEXT = 40.0f;
    public static final float ENOUGH_DELTA_E_FOR_TEXT = 100.0f;
    public static final float ENOUGH_DELTA_H_FOR_TEXT = 100.0f;

    public static short judgeComponentType(ConnectedComponent connectedComponent, IPageImage iPageImage) throws ImageException {
        return DecisionMaker.judgeComponentType(connectedComponent, iPageImage, false);
    }

    public static short judgeComponentType(ConnectedComponent connectedComponent, IPageImage iPageImage, boolean bl) throws ImageException {
        BinaryImage binaryImage = connectedComponent.getShape();
        int n = binaryImage.getWidth();
        int n2 = binaryImage.getHeight();
        if (n < 5 || n2 < 5) {
            return 100;
        }
        double d = connectedComponent.getDensity();
        LineSegment lineSegment = binaryImage.detectLongestHorizontalLine();
        if (lineSegment.isVertical() || lineSegment.isDiagonal()) {
            throw new ImageException("detectLongestHorizontalLine() does not work.");
        }
        double d2 = lineSegment.getLength() / (double)n;
        double d3 = (double)lineSegment.getLeftPoint().getY() / (double)n2;
        double d4 = (double)n / (double)n2;
        if (d2 >= 0.95 && d3 >= 0.85 && d4 >= 3.0 && d < 0.4) {
            return 3;
        }
        if (n > 72 || n2 > 100) {
            return 1;
        }
        if (d4 < 0.1 || 10.0 < d4) {
            return 100;
        }
        ConnectedComponent connectedComponent2 = connectedComponent.thinning();
        if ((double)connectedComponent2.getCount() / (double)connectedComponent.getCount() < 0.25) {
            return 100;
        }
        Topology topology = new Topology(connectedComponent2);
        if (topology.getNumBranches() > 8) {
            return 100;
        }
        if (topology.getNumCrosses() > 8) {
            return 100;
        }
        return 2;
    }

    public static boolean isMSCharacter(ConnectedComponent connectedComponent) throws ImageException {
        BinaryImage binaryImage = connectedComponent.getShape();
        int n = binaryImage.getWidth();
        int n2 = binaryImage.getHeight();
        if (n < 10 || n2 < 10) {
            return false;
        }
        return n2 <= 100;
    }

    public static boolean isTooSmallThinedMSCharacter(CharacterMS characterMS) throws ImageException {
        ConnectedComponent connectedComponent = characterMS.getConnectedComponent();
        ConnectedComponent connectedComponent2 = connectedComponent.thinning();
        double d = (double)connectedComponent2.getCount() / (double)connectedComponent.getCount();
        return d < 0.25;
    }

    public static boolean isSMCharacter(CharacterSM characterSM) {
        int n = characterSM.getForegroundColor();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = characterSM.getWidth();
        int n6 = characterSM.getHeight();
        if (n5 < 10 || n6 < 10 || n6 > 100) {
            return false;
        }
        ConnectedComponent connectedComponent = characterSM.getConnectedComponent();
        byte[][] byArray = connectedComponent.getShape().getData();
        int[][] nArray = characterSM.getImage();
        int n7 = 0;
        int n8 = 0;
        while (n8 < n6) {
            int n9 = 0;
            while (n9 < n5) {
                if (byArray[n8][n9] == 0) {
                    int n10 = nArray[n8][n9];
                    n2 += n10 >> 16 & 0xFF;
                    n3 += n10 >> 8 & 0xFF;
                    n4 += n10 & 0xFF;
                    ++n7;
                }
                ++n9;
            }
            ++n8;
        }
        n8 = ((n2 /= n7) & 0xFF) << 16 | ((n3 /= n7) & 0xFF) << 8 | (n4 /= n7) & 0xFF;
        try {
            return DecisionMaker.distinguishableTextColors(n, n8);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return true;
        }
    }

    public static boolean distinguishableTextColors(ColorLAB colorLAB, ColorLAB colorLAB2) {
        double d = ColorLAB.deltaL(colorLAB, colorLAB2);
        double d2 = ColorLAB.deltaE(colorLAB, colorLAB2);
        if (d < 20.0) {
            return false;
        }
        if (d2 >= 100.0) {
            return true;
        }
        double d3 = DecisionMaker.calcThresholdLforText(colorLAB, colorLAB2);
        return !(d < d3);
    }

    public static boolean distinguishableTextColors(int n, int n2) throws LowVisionException {
        ColorLAB colorLAB = null;
        ColorLAB colorLAB2 = null;
        try {
            colorLAB = new ColorIRGB(n).toXYZ().toLAB();
            colorLAB2 = new ColorIRGB(n2).toXYZ().toLAB();
        }
        catch (ColorException colorException) {
            colorException.printStackTrace();
            throw new LowVisionException("ColorException occurred while converting int into ColorLAB");
        }
        return DecisionMaker.distinguishableTextColors(colorLAB, colorLAB2);
    }

    public static double calcThresholdLforText(ColorLAB colorLAB, ColorLAB colorLAB2) {
        double d = ColorLAB.deltaE(colorLAB, colorLAB2);
        double d2 = (double)-0.2f * d + 40.0;
        if (d2 < 0.0) {
            d2 = 0.0;
        }
        return d2;
    }

    public static double calcThresholdLforText(int n, int n2) throws LowVisionException {
        ColorLAB colorLAB = null;
        ColorLAB colorLAB2 = null;
        try {
            colorLAB = new ColorIRGB(n).toXYZ().toLAB();
            colorLAB2 = new ColorIRGB(n2).toXYZ().toLAB();
        }
        catch (ColorException colorException) {
            colorException.printStackTrace();
            throw new LowVisionException("ColorException occurred while converting int into ColorLAB");
        }
        return DecisionMaker.calcThresholdLforText(colorLAB, colorLAB2);
    }

    public static boolean distinguishableImageColors(ColorLAB colorLAB, ColorLAB colorLAB2) {
        return DecisionMaker.calcColorDistanceForImage(colorLAB, colorLAB2) >= 1.0;
    }

    public static boolean distinguishableImageColors(int n, int n2) throws LowVisionException {
        ColorLAB colorLAB = null;
        ColorLAB colorLAB2 = null;
        try {
            colorLAB = new ColorIRGB(n).toXYZ().toLAB();
            colorLAB2 = new ColorIRGB(n2).toXYZ().toLAB();
        }
        catch (ColorException colorException) {
            colorException.printStackTrace();
            throw new LowVisionException("ColorException occurred while converting int into ColorLAB");
        }
        return DecisionMaker.distinguishableImageColors(colorLAB, colorLAB2);
    }

    public static double calcColorDistanceForImage(ColorLAB colorLAB, ColorLAB colorLAB2) {
        return ColorLAB.deltaE(colorLAB, colorLAB2) / 40.0f;
    }

    public static double calcColorDistanceForImage(int n, int n2) throws LowVisionException {
        ColorLAB colorLAB = null;
        ColorLAB colorLAB2 = null;
        try {
            colorLAB = new ColorIRGB(n).toXYZ().toLAB();
            colorLAB2 = new ColorIRGB(n2).toXYZ().toLAB();
        }
        catch (ColorException colorException) {
            colorException.printStackTrace();
            throw new LowVisionException("ColorException occurred while converting int into ColorLAB");
        }
        return DecisionMaker.calcColorDistanceForImage(colorLAB, colorLAB2);
    }

    public static boolean isForegroundColor(int n, int n2, int n3) {
        Vector3D vector3D = DecisionMaker.colorToVector3D(n);
        Vector3D vector3D2 = DecisionMaker.colorToVector3D(n2);
        Vector3D vector3D3 = DecisionMaker.colorToVector3D(n3);
        Vector3D vector3D4 = Vector3D.subtract(vector3D, vector3D3);
        Vector3D vector3D5 = Vector3D.subtract(vector3D2, vector3D3);
        if (vector3D5.isZeroVector() || vector3D4.isZeroVector()) {
            double d = Vector3D.magnitude(Vector3D.subtract(vector3D2, vector3D));
            return d <= 1.5;
        }
        double d = vector3D4.magnitude();
        double d2 = vector3D5.magnitude();
        double d3 = 0.0;
        double d4 = 0.0;
        try {
            d3 = Vector3D.sine(vector3D5, vector3D4);
            d4 = Vector3D.cosine(vector3D5, vector3D4);
        }
        catch (ImageException imageException) {
            imageException.printStackTrace();
        }
        if (d * d3 > 1.5) {
            return false;
        }
        double d5 = d * d4 / d2;
        return !(d5 < 0.25) && !(1.0 < d5);
    }

    private static Vector3D colorToVector3D(int n) {
        ColorIRGB colorIRGB = new ColorIRGB(n);
        return new Vector3D(colorIRGB.getR(), colorIRGB.getG(), colorIRGB.getB());
    }

    public static int calcSearchMinX(int n, int n2, int n3) {
        int n4 = n - Math.round(1.0f * (float)n2);
        if (n4 < 0) {
            n4 = 0;
        }
        return n4;
    }

    public static int calcSearchMaxX(int n, int n2, int n3) {
        int n4 = n + n2 + Math.round(1.0f * (float)n2);
        if (n4 > n3 - 1) {
            n4 = n3 - 1;
        }
        return n4;
    }

    public static int calcSearchMinY(int n, int n2, int n3) {
        int n4 = n - Math.round(1.0f * (float)n2);
        if (n4 < 0) {
            n4 = 0;
        }
        return n4;
    }

    public static int calcSearchMaxY(int n, int n2, int n3) {
        int n4 = n + n2 + Math.round(1.0f * (float)n2);
        if (n4 > n3 - 1) {
            n4 = n3 - 1;
        }
        return n4;
    }

    public static boolean areSameGroupProblems(LowVisionProblem lowVisionProblem, LowVisionProblem lowVisionProblem2) throws LowVisionProblemException {
        Object object;
        Object object2;
        short s;
        if (lowVisionProblem.isGroup() || lowVisionProblem2.isGroup()) {
            throw new LowVisionProblemException("ProblemGroup cannot be grouped any more.");
        }
        PageComponent pageComponent = lowVisionProblem.getPageComponent();
        PageComponent pageComponent2 = lowVisionProblem2.getPageComponent();
        short s2 = pageComponent.getType();
        if (s2 != (s = pageComponent2.getType())) {
            return false;
        }
        int n = lowVisionProblem.getLowVisionProblemType();
        if (n != lowVisionProblem2.getLowVisionProblemType()) {
            return false;
        }
        if (n == 1) {
            object2 = (ColorProblem)lowVisionProblem;
            object = (ColorProblem)lowVisionProblem2;
            if (s2 == 4) {
                if (((ColorProblem)object2).getBackgroundColor() != ((ColorProblem)object).getBackgroundColor()) {
                    return false;
                }
                if (((ColorProblem)object2).getForegroundColor() != ((ColorProblem)object).getForegroundColor()) {
                    return false;
                }
            } else if (s2 == 5 ? ((ColorProblem)object2).getBackgroundColor() != ((ColorProblem)object).getBackgroundColor() : s2 == 6 && ((ColorProblem)object2).getForegroundColor() != ((ColorProblem)object).getForegroundColor()) {
                return false;
            }
        } else if (n == 2) {
            if (s2 == 4) {
                object2 = (CharacterSS)pageComponent;
                object = (CharacterSS)pageComponent2;
                if (((CharacterSS)object2).getForegroundColor() != ((CharacterSS)object).getForegroundColor()) {
                    return false;
                }
                if (((CharacterSS)object2).getBackgroundColor() != ((CharacterSS)object).getBackgroundColor()) {
                    return false;
                }
            } else if (s2 == 5 ? ((CharacterMS)pageComponent).getBackgroundColor() != ((CharacterMS)pageComponent2).getBackgroundColor() : s2 == 6 && ((CharacterSM)pageComponent).getForegroundColor() != ((CharacterSM)pageComponent2).getForegroundColor()) {
                return false;
            }
        } else {
            throw new LowVisionProblemException("Unknown problem type :" + n);
        }
        object2 = null;
        object2 = lowVisionProblem.getPageComponent().getContainer();
        if (object2 != null && ((PageComponent)object2).getWidth() <= 300 && ((PageComponent)object2).getHeight() <= 300) {
            return true;
        }
        int n2 = lowVisionProblem.getX();
        int n3 = n2 + lowVisionProblem.getWidth() - 1;
        int n4 = lowVisionProblem.getY();
        int n5 = n4 + lowVisionProblem.getHeight() - 1;
        int n6 = lowVisionProblem2.getX();
        int n7 = n6 + lowVisionProblem2.getWidth() - 1;
        int n8 = lowVisionProblem2.getY();
        int n9 = n8 + lowVisionProblem2.getHeight() - 1;
        if (n2 - n7 > 80 || n6 - n3 > 80) {
            return false;
        }
        return n4 - n9 <= 80 && n8 - n5 <= 80;
    }

    public static int getScoreMapColor(double d) {
        if (d <= 0.0) {
            return 0xAAAAAA;
        }
        if (d < 0.5) {
            return 0xFFFF00;
        }
        if (d < 1.0) {
            return 0xFF7700;
        }
        return 0xFF0000;
    }
}

