/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.xpath.jaxp;

import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.actf.util.dom.EmptyNodeListImpl;
import org.eclipse.actf.util.xpath.XPathService;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class XPathServiceImpl
extends XPathService {
    private static final XPathFactory xf = XPathFactory.newInstance();

    private XPath getXPath() {
        return xf.newXPath();
    }

    public Object compile(String string) {
        try {
            return this.getXPath().compile(string);
        }
        catch (XPathExpressionException xPathExpressionException) {
            return null;
        }
    }

    public NodeList evalForNodeList(Object object, Node node) {
        try {
            XPathExpression xPathExpression = (XPathExpression)object;
            return (NodeList)xPathExpression.evaluate(node, XPathConstants.NODESET);
        }
        catch (Exception exception) {
            return EmptyNodeListImpl.getInstance();
        }
    }

    public String evalForString(Object object, Node node) {
        try {
            XPathExpression xPathExpression = (XPathExpression)object;
            return (String)xPathExpression.evaluate(node, XPathConstants.STRING);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static XPathService newInstance() {
        if (xf == null) {
            return null;
        }
        return new XPathServiceImpl();
    }

    private XPathServiceImpl() {
    }
}

