/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.io;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.eclipse.actf.visualization.engines.lowvision.LowVisionIOException;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.BinaryImage;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.ImageUtil;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.Int2D;
import org.eclipse.actf.visualization.internal.engines.lowvision.io.BMPWriter;
import org.eclipse.actf.visualization.internal.engines.lowvision.io.IoUtil;
import org.eclipse.actf.visualization.internal.engines.lowvision.io.JPEGWriter;
import org.eclipse.actf.visualization.internal.engines.lowvision.io.PBMWriter;

public class ImageWriter {
    public static void writeBufferedImage(BufferedImage bufferedImage, String string) throws LowVisionIOException {
        short s = IoUtil.getFileType(string);
        if (s == 0) {
            throw new LowVisionIOException("Unknown image format.");
        }
        ImageWriter.writeBufferedImage(bufferedImage, string, s);
    }

    public static void writeBufferedImage(BufferedImage bufferedImage, String string, short s) throws LowVisionIOException {
        if (s == 1) {
            BMPWriter.writeBufferedImage(bufferedImage, string);
        } else if (s == 2) {
            JPEGWriter.writeBufferedImage(bufferedImage, string);
        } else if (s == 5) {
            File file = new File(string);
            boolean bl = true;
            try {
                bl = ImageIO.write((RenderedImage)bufferedImage, "GIF", file);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw new LowVisionIOException("An error occurs while writing a GIF image.");
            }
            if (!bl) {
                throw new LowVisionIOException("No appropriate writer is found while writing a GIF image.");
            }
        } else if (s == 6) {
            File file = new File(string);
            boolean bl = true;
            try {
                bl = ImageIO.write((RenderedImage)bufferedImage, "PNG", file);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw new LowVisionIOException("An error occurs while writing a PNG image.");
            }
            if (!bl) {
                throw new LowVisionIOException("No appropriate writer is found while writing a PNG image.");
            }
        } else {
            throw new LowVisionIOException("Unknown image format.");
        }
    }

    public static void writeInt2D(Int2D int2D, String string) throws LowVisionIOException {
        ImageWriter.writeBufferedImage(ImageUtil.int2DToBufferedImage(int2D), string);
    }

    public static void writeInt2D(Int2D int2D, String string, short s) throws LowVisionIOException {
        ImageWriter.writeBufferedImage(ImageUtil.int2DToBufferedImage(int2D), string, s);
    }

    public static void writeBinaryImage(BinaryImage binaryImage, String string) throws LowVisionIOException {
        short s = IoUtil.getFileType(string);
        if (s == 0) {
            throw new LowVisionIOException("Unknown image format.");
        }
        ImageWriter.writeBinaryImage(binaryImage, string, s);
    }

    public static void writeBinaryImage(BinaryImage binaryImage, String string, short s) throws LowVisionIOException {
        if (s != 3) {
            throw new LowVisionIOException("Unknown image format.");
        }
        PBMWriter.writeBinaryImage(binaryImage, string);
    }
}

