/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.dom.odf.table.impl;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.actf.model.dom.odf.ODFException;
import org.eclipse.actf.model.dom.odf.base.ContentBaseElement;
import org.eclipse.actf.model.dom.odf.base.ODFDocument;
import org.eclipse.actf.model.dom.odf.base.impl.ODFStylableElementImpl;
import org.eclipse.actf.model.dom.odf.office.BodyElement;
import org.eclipse.actf.model.dom.odf.office.DocumentContentElement;
import org.eclipse.actf.model.dom.odf.range.ITextElementContainer;
import org.eclipse.actf.model.dom.odf.range.impl.ITextElementContainerUtil;
import org.eclipse.actf.model.dom.odf.table.TableCellElement;
import org.eclipse.actf.model.dom.odf.table.TableColumnElement;
import org.eclipse.actf.model.dom.odf.table.TableElement;
import org.eclipse.actf.model.dom.odf.table.TableHeaderColumnsElement;
import org.eclipse.actf.model.dom.odf.table.TableHeaderRowsElement;
import org.eclipse.actf.model.dom.odf.table.TableRowElement;
import org.eclipse.actf.model.dom.odf.table.TableRowsElement;
import org.eclipse.actf.model.dom.odf.text.SequenceElement;
import org.eclipse.actf.util.xpath.XPathService;
import org.eclipse.actf.util.xpath.XPathServiceFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TableElementImpl
extends ODFStylableElementImpl
implements TableElement {
    private static final long serialVersionUID = -1072814785496953249L;
    private static final XPathService xpathService = XPathServiceFactory.newService();
    private static final Object EXP1 = xpathService.compile("./*[namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:table:1.0' and local-name()='table-header-columns']");
    private static final Object EXP2 = xpathService.compile("./*[namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:table:1.0' and local-name()='table-header-rows']");
    private static final Object EXP3 = xpathService.compile("following-sibling::*[namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:text:1.0' and local-name()='p'][1]/*[namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:text:1.0' and local-name()='sequence']");
    private static final Object EXP4 = xpathService.compile("preceding-sibling::*[namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:text:1.0' and local-name()='p'][1]/*[namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:text:1.0' and local-name()='sequence']");

    protected TableElementImpl(ODFDocument oDFDocument, Element element) {
        super(oDFDocument, element);
    }

    @Override
    public String getAttrTableName() {
        if (this.hasAttributeNS("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "name")) {
            return this.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "name");
        }
        return null;
    }

    @Override
    public String getAttrTableStyleName() {
        if (this.hasAttributeNS("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "style-name")) {
            return this.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "style-name");
        }
        return null;
    }

    @Override
    public boolean getAttrTableAttrPrint() {
        if (this.hasAttributeNS("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "attr-print")) {
            return new Boolean(this.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "attr-print"));
        }
        return false;
    }

    @Override
    public boolean getAttrTableProtected() {
        if (this.hasAttributeNS("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "protected")) {
            return new Boolean(this.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "protected"));
        }
        return false;
    }

    @Override
    public int getTableIndex() {
        NodeList nodeList = this.getContent().getElementsByTagNameNS("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "table");
        int n = 0;
        while (n < nodeList.getLength()) {
            if (nodeList.item(n).equals(this)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    public TableColumnElement getTableColumnChild(int n) {
        NodeList nodeList = this.getChildNodes();
        if (nodeList != null) {
            int n2 = 0;
            int n3 = 0;
            while (n2 < nodeList.getLength()) {
                if (nodeList.item(n2) instanceof TableColumnElement) {
                    if (n3 == n) {
                        return (TableColumnElement)nodeList.item(n2);
                    }
                    ++n3;
                }
                ++n2;
            }
        }
        return null;
    }

    @Override
    public TableRowElement getTableRowChild(int n) {
        NodeList nodeList = this.getChildNodes();
        if (nodeList != null) {
            int n2 = 0;
            int n3 = 0;
            while (n2 < nodeList.getLength()) {
                if (nodeList.item(n2) instanceof TableRowElement) {
                    if (n3 == n) {
                        return (TableRowElement)nodeList.item(n2);
                    }
                    ++n3;
                }
                ++n2;
            }
        }
        return null;
    }

    @Override
    public int getTableColumnSize() {
        int n = 0;
        NodeList nodeList = this.getChildNodes();
        if (nodeList != null) {
            int n2 = 0;
            while (n2 < nodeList.getLength()) {
                Node node = nodeList.item(n2);
                if (node instanceof TableColumnElement) {
                    int n3 = ((TableColumnElement)node).getAttrTableNumberColumnsRepeated();
                    n = n3 > 0 ? (n += n3) : ++n;
                } else if (node instanceof TableHeaderColumnsElement || node instanceof TableColumnElement) {
                    NodeList nodeList2 = node.getChildNodes();
                    int n4 = 0;
                    while (n4 < nodeList2.getLength()) {
                        Node node2 = nodeList2.item(n4);
                        if (node2 instanceof TableColumnElement) {
                            int n5 = ((TableColumnElement)node2).getAttrTableNumberColumnsRepeated();
                            n = n5 > 0 ? (n += n5) : ++n;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return n;
    }

    @Override
    public List<TableColumnElement> getTableColumnChildren() {
        Vector<TableColumnElement> vector = null;
        NodeList nodeList = this.getChildNodes();
        if (nodeList != null) {
            int n = 0;
            while (n < nodeList.getLength()) {
                Node node = nodeList.item(n);
                if (node instanceof TableColumnElement) {
                    if (vector == null) {
                        vector = new Vector<TableColumnElement>();
                    }
                    vector.add((TableColumnElement)node);
                } else if (node instanceof TableHeaderColumnsElement || node instanceof TableColumnElement) {
                    NodeList nodeList2 = node.getChildNodes();
                    int n2 = 0;
                    while (n2 < nodeList2.getLength()) {
                        Node node2 = nodeList2.item(n2);
                        if (node2 instanceof TableColumnElement) {
                            if (vector == null) {
                                vector = new Vector();
                            }
                            vector.add((TableColumnElement)node2);
                        }
                        ++n2;
                    }
                }
                ++n;
            }
        }
        return vector;
    }

    @Override
    public int getTableRowSize() {
        int n = 0;
        NodeList nodeList = this.getChildNodes();
        if (nodeList != null) {
            int n2 = 0;
            while (n2 < nodeList.getLength()) {
                Node node = nodeList.item(n2);
                if (node instanceof TableRowElement) {
                    int n3 = ((TableRowElement)node).getAttrTableNumberRowsRepeated();
                    n = n3 > 0 ? (n += n3) : ++n;
                } else if (node instanceof TableHeaderRowsElement || node instanceof TableRowElement) {
                    NodeList nodeList2 = node.getChildNodes();
                    int n4 = 0;
                    while (n4 < nodeList2.getLength()) {
                        Node node2 = nodeList2.item(n4);
                        if (node2 instanceof TableRowElement) {
                            int n5 = ((TableRowElement)node2).getAttrTableNumberRowsRepeated();
                            n = n5 > 0 ? (n += n5) : ++n;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return n;
    }

    @Override
    public List<TableRowElement> getTableRowChildren() {
        Vector<TableRowElement> vector = null;
        NodeList nodeList = this.getChildNodes();
        if (nodeList != null) {
            int n = 0;
            while (n < nodeList.getLength()) {
                if (nodeList.item(n) instanceof TableRowElement) {
                    if (vector == null) {
                        vector = new Vector<TableRowElement>();
                    }
                    vector.add((TableRowElement)nodeList.item(n));
                } else if (nodeList.item(n) instanceof TableHeaderRowsElement || nodeList.item(n) instanceof TableRowsElement) {
                    NodeList nodeList2 = nodeList.item(n).getChildNodes();
                    int n2 = 0;
                    while (n2 < nodeList2.getLength()) {
                        if (nodeList2.item(n2) instanceof TableRowElement) {
                            if (vector == null) {
                                vector = new Vector();
                            }
                            vector.add((TableRowElement)nodeList2.item(n2));
                        }
                        ++n2;
                    }
                }
                ++n;
            }
        }
        return vector;
    }

    @Override
    public ContentBaseElement getContent() {
        if (this.odfDoc == null) {
            return null;
        }
        ContentBaseElement contentBaseElement = null;
        Element element = this.odfDoc.getDocumentElement();
        if (element instanceof DocumentContentElement) {
            BodyElement bodyElement = ((DocumentContentElement)element).getBodyElement();
            contentBaseElement = bodyElement.getContent();
        }
        return contentBaseElement;
    }

    @Override
    public boolean hasTableCellStyle(int n, int n2) {
        TableRowElement tableRowElement = this.getTableRowChild(n2);
        List<TableCellElement> list = tableRowElement.getTableCellChildren();
        int n3 = 0;
        int n4 = 0;
        while (n3 < list.size()) {
            TableCellElement tableCellElement = list.get(n3);
            n4 = tableCellElement.hasAttributeNS("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "number-columns-repeated") ? (n4 += tableCellElement.getAttrTableNumberColumnsRepeated()) : ++n4;
            if (n4 - 1 >= n) {
                return tableCellElement.hasAttributeNS("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "style-name");
            }
            ++n3;
        }
        return false;
    }

    @Override
    public TableRowElement appendNewTableRowElement() {
        String string = this.lookupPrefix("urn:oasis:names:tc:opendocument:xmlns:table:1.0");
        TableRowElement tableRowElement = (TableRowElement)this.getOwnerDocument().createElement(String.valueOf(string) + ":" + "table-row");
        return (TableRowElement)this.appendChild(tableRowElement);
    }

    @Override
    public NodeList getTableHeaderColumns() {
        return xpathService.evalForNodeList(EXP1, (Node)this);
    }

    @Override
    public NodeList getTableHeaderRows() {
        return xpathService.evalForNodeList(EXP2, (Node)this);
    }

    @Override
    public SequenceElement getTextSequenceElement() {
        NodeList nodeList;
        NodeList nodeList2 = xpathService.evalForNodeList(EXP3, (Node)this);
        if (nodeList2 != null && nodeList2.getLength() == 1) {
            return (SequenceElement)nodeList2.item(0);
        }
        if (nodeList2 != null && nodeList2.getLength() > 1) {
            new ODFException("draw:image has more than one text:sequence elements.").printStackTrace();
        }
        if ((nodeList = xpathService.evalForNodeList(EXP4, (Node)this)) != null && nodeList.getLength() == 1) {
            return (SequenceElement)nodeList.item(0);
        }
        if (nodeList != null && nodeList.getLength() > 1) {
            new ODFException("draw:image has more than one text:sequence elements.").printStackTrace();
        }
        return null;
    }

    @Override
    public long getContentSize() {
        return ITextElementContainerUtil.getContentSize(this);
    }

    @Override
    public Iterator<ITextElementContainer> getChildIterator() {
        return ITextElementContainerUtil.getChildIterator(this);
    }
}

