/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.win32.comclutch.impl;

import java.util.HashMap;
import org.eclipse.actf.util.win32.comclutch.DispatchException;
import org.eclipse.actf.util.win32.comclutch.IDispatch;
import org.eclipse.actf.util.win32.comclutch.IResource;
import org.eclipse.actf.util.win32.comclutch.IUnknown;
import org.eclipse.actf.util.win32.comclutch.ResourceManager;
import org.eclipse.actf.util.win32.comclutch.impl.IUnknownImpl;

public class IDispatchImpl
extends IUnknownImpl
implements IDispatch {
    private static final String IS_NOT_AVAILABLE = " is not available.";
    private static final int LCID_SYSTEM_DEFAULT = 1024;
    private static final int DISPATCH_METHOD = 1;
    private static final int DISPATCH_PROPERTYGET = 2;
    private HashMap<String, Long> nameCache;

    private long getDispID(String string) {
        Object object;
        if (this.nameCache == null) {
            this.nameCache = new HashMap(4);
        } else {
            object = this.nameCache.get(string);
            if (object != null) {
                return (Long)object;
            }
        }
        object = this._getIDsOfNames(this.getPtr(), new String[]{string}, 1024);
        if (object == null) {
            return -1L;
        }
        Object object2 = object[0];
        this.nameCache.put(string.intern(), (long)object2);
        return (long)object2;
    }

    public void cacheDispIDs(String[] stringArray) {
        if (this.nameCache == null) {
            this.nameCache = new HashMap(stringArray.length);
        }
        long[] lArray = this._getIDsOfNames(this.getPtr(), stringArray, 1024);
        int n = 0;
        while (n < lArray.length) {
            this.nameCache.put(stringArray[n].intern(), lArray[n]);
            ++n;
        }
    }

    public Object invoke(String string, Object[] objectArray) {
        long l = this.getDispID(string);
        if (l == -1L) {
            throw new DispatchException(String.valueOf(string) + IS_NOT_AVAILABLE);
        }
        return this.invoke(l, objectArray);
    }

    public Object invoke(long l, Object[] objectArray) {
        Object object = this._invoke(this.getPtr(), l, 1024, 1, objectArray);
        return object;
    }

    public Object invoke0(String string) {
        long l = this.getDispID(string);
        if (l == -1L) {
            throw new DispatchException(String.valueOf(string) + IS_NOT_AVAILABLE);
        }
        return this.invoke0(l);
    }

    public Object invoke0(long l) {
        return this.invoke(l, null);
    }

    public Object invoke1(String string, Object object) {
        long l = this.getDispID(string);
        if (l == -1L) {
            throw new DispatchException(String.valueOf(string) + IS_NOT_AVAILABLE);
        }
        return this.invoke1(l, object);
    }

    public Object invoke1(long l, Object object) {
        return this.invoke(l, new Object[]{object});
    }

    public Object get(String string) {
        long l = this.getDispID(string);
        if (l == -1L) {
            return null;
        }
        return this.get(l);
    }

    public Object get(long l) {
        Object object = this._invoke(this.getPtr(), l, 1024, 2, null);
        return object;
    }

    public Object get(String string, Object[] objectArray) {
        long l = this.getDispID(string);
        if (l == -1L) {
            return null;
        }
        return this.get(l, objectArray);
    }

    public Object get(long l, Object[] objectArray) {
        Object object = this._invoke(this.getPtr(), l, 1024, 2, objectArray);
        return object;
    }

    public void put(String string, Object object) {
        long l = this.getDispID(string);
        if (l == -1L) {
            throw new DispatchException(String.valueOf(string) + IS_NOT_AVAILABLE);
        }
        this.put(l, object);
    }

    public void put(long l, Object object) {
        this._put(this.getPtr(), l, 1024, object);
    }

    public IDispatchImpl(ResourceManager resourceManager, long l, boolean bl) {
        super(resourceManager, l, bl);
    }

    public IDispatchImpl(ResourceManager resourceManager, IUnknown iUnknown) {
        super(resourceManager, iUnknown);
    }

    public IDispatchImpl(IUnknownImpl iUnknownImpl) {
        super(iUnknownImpl);
    }

    private native long[] _getIDsOfNames(long var1, String[] var3, int var4);

    private native Object _invoke(long var1, long var3, int var5, int var6, Object[] var7);

    private native void _put(long var1, long var3, int var5, Object var6);

    public static IDispatch newIDispatch(ResourceManager resourceManager, long l, boolean bl) {
        IDispatchImpl iDispatchImpl = new IDispatchImpl(resourceManager, l, bl);
        resourceManager.addResource(iDispatchImpl);
        return iDispatchImpl;
    }

    public IDispatch newIDispatch(long l) {
        IResource iResource = this.findInResource(l);
        if (iResource != null) {
            IDispatch iDispatch = (IDispatch)iResource;
            return iDispatch;
        }
        IDispatchImpl iDispatchImpl = new IDispatchImpl(this.getResourceManager(), l, false);
        this.addResource(iDispatchImpl);
        return iDispatchImpl;
    }
}

