/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.internal.httpproxy.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.actf.util.httpproxy.core.IBufferRange;
import org.eclipse.actf.util.httpproxy.core.IHTTPRequestMessage;
import org.eclipse.actf.util.httpproxy.core.IMessageBody;
import org.eclipse.actf.util.internal.httpproxy.core.BufferRange;
import org.eclipse.actf.util.internal.httpproxy.core.HTTPMessage;
import org.eclipse.actf.util.internal.httpproxy.core.HTTPMessageBuffer;
import org.eclipse.actf.util.internal.httpproxy.core.MessageBody;

public class HTTPRequestMessage
extends HTTPMessage
implements IHTTPRequestMessage {
    private IBufferRange fMethod = new BufferRange();
    private IBufferRange fRequestURI = new BufferRange();
    private String modifiedRequestURI;
    private IBufferRange fHTTPVersion = new BufferRange();
    private boolean contentLengthInvalidMessage;

    public HTTPRequestMessage(long l) {
        super(l);
    }

    public IBufferRange getMethod() {
        return this.fMethod;
    }

    public byte[] getMethodAsBytes() {
        return this.getBuffer().getAsBytes(this.fMethod);
    }

    public String getMethodAsString() {
        return this.getBuffer().getAsString(this.fMethod);
    }

    public IBufferRange getRequestURI() {
        if (this.modifiedRequestURI != null) {
            return null;
        }
        return this.fRequestURI;
    }

    public void setRequestURIString(String string) {
        this.modifiedRequestURI = string;
    }

    public String getOriginalRequestURIString() {
        return this.getBuffer().getAsString(this.fRequestURI);
    }

    public String getRequestURIString() {
        if (this.modifiedRequestURI != null) {
            return this.modifiedRequestURI;
        }
        return this.getOriginalRequestURIString();
    }

    public IBufferRange getHTTPVersion() {
        return this.fHTTPVersion;
    }

    public byte[] getHTTPVersionAsBytes() {
        return this.getBuffer().getAsBytes(this.fHTTPVersion);
    }

    public String getHTTPVersionAsString() {
        return this.getBuffer().getAsString(this.fHTTPVersion);
    }

    public boolean isMethodEqualsTo(byte[] byArray) {
        return this.getBuffer().equals(this.fMethod, byArray);
    }

    protected void writeFirstLine(OutputStream outputStream) throws IOException {
        HTTPMessageBuffer hTTPMessageBuffer = this.getBuffer();
        hTTPMessageBuffer.writeTo(outputStream, this.fMethod);
        outputStream.write(32);
        if (this.modifiedRequestURI == null) {
            hTTPMessageBuffer.writeTo(outputStream, this.fRequestURI);
        } else {
            outputStream.write(this.modifiedRequestURI.getBytes());
        }
        outputStream.write(32);
        hTTPMessageBuffer.writeTo(outputStream, this.fHTTPVersion);
        outputStream.write(13);
        outputStream.write(10);
    }

    protected boolean isBodyEmpty() {
        return false;
    }

    public boolean isResponseBodyEmpty() {
        return "CONNECT".equals(this.getMethodAsString()) || "HEAD".equals(this.getMethodAsString());
    }

    final void recalculateContentLength() {
        IMessageBody iMessageBody = this.getMessageBody();
        if (iMessageBody.getContentLength() == -1) {
            this.contentLengthInvalidMessage = true;
            InputStream inputStream = iMessageBody.getMessageBodyInputStream();
            this.setOriginalMessageBody(new MessageBody(inputStream, 0));
        }
    }

    public boolean isConnectionShutdownRequired() {
        if (!this.isConnectionToBeClosed()) {
            return false;
        }
        IMessageBody iMessageBody = this.getMessageBody();
        if (iMessageBody.isChunkedEncoding()) {
            return false;
        }
        return this.contentLengthInvalidMessage || iMessageBody.getContentLength() < 0;
    }

    protected void writeBodyWithoutContentLength(long l, IMessageBody iMessageBody, OutputStream outputStream) {
    }
}

