/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.blind;

import com.ibm.icu.text.MessageFormat;
import org.eclipse.actf.util.FileUtils;
import org.eclipse.actf.visualization.engines.blind.eval.PageEvaluation;
import org.eclipse.actf.visualization.eval.guideline.GuidelineHolder;
import org.eclipse.actf.visualization.eval.html.statistics.PageData;
import org.eclipse.actf.visualization.internal.engines.blind.Messages;

public class SummaryEvaluation {
    private static final String SPACE = " ";
    private PageEvaluation pe;
    private PageData pageData;
    private int noImageAltCount;
    private int wrongImageAltCount;
    private int redundantImageAltCount = 0;
    private GuidelineHolder guidelineHolder = GuidelineHolder.getInstance();
    private boolean hasError;

    public SummaryEvaluation(PageEvaluation pageEvaluation, PageData pageData, boolean bl) {
        this.pe = pageEvaluation;
        this.pageData = pageData;
        this.hasError = bl;
    }

    public String getOverview() {
        StringBuffer stringBuffer = new StringBuffer(512);
        StringBuffer stringBuffer2 = new StringBuffer();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        String[] stringArray = this.pe.getMetrics();
        String[] stringArray2 = this.pe.getLocalizedMetrics();
        int[] nArray = this.pe.getScores();
        int n = 0;
        int n2 = 0;
        int n3 = 100;
        int n4 = 100;
        int n5 = 0;
        while (n5 < stringArray.length) {
            int n6 = nArray[n5];
            if ((stringArray[n5].equalsIgnoreCase("perceivable") || stringArray[n5].equalsIgnoreCase("understandable") || stringArray[n5].equalsIgnoreCase("robust")) && this.guidelineHolder.isMatchedMetric(stringArray[n5])) {
                n += n6;
                ++n2;
                bl = true;
                if (n6 != 100) {
                    stringBuffer2.append(String.valueOf(stringArray2[n5]) + ",");
                }
            } else if (stringArray[n5].equalsIgnoreCase("operable") && this.guidelineHolder.isMatchedMetric(stringArray[n5])) {
                n3 = n6;
                n += n6;
                ++n2;
                bl2 = true;
            } else {
                bl3 = true;
                if (n4 > n6) {
                    n4 = n6;
                }
                if (n6 != 100) {
                    stringBuffer2.append(String.valueOf(stringArray2[n5]) + ",");
                }
            }
            ++n5;
        }
        this.noImageAltCount = this.pageData.getMissingAltNum();
        this.wrongImageAltCount = this.pageData.getWrongAltNum();
        n5 = this.noImageAltCount + this.wrongImageAltCount;
        StringBuffer stringBuffer3 = new StringBuffer();
        StringBuffer stringBuffer4 = new StringBuffer();
        boolean bl4 = false;
        if (n2 == 0) {
            return "";
        }
        if (n / n2 >= 75) {
            if (this.hasError) {
                stringBuffer3.append(String.valueOf(Messages.Eval_compliant_with_some_other_errors) + FileUtils.LINE_SEP);
                if (n5 > 0) {
                    stringBuffer3.append(String.valueOf(Messages.Eval_confirm_alt_attributes_first) + FileUtils.LINE_SEP);
                    stringBuffer3.append(this.getImageAltStatistics());
                } else {
                    stringBuffer3.append(Messages.Eval_confirm_errors_detailed_report);
                }
            } else if (bl3 && n4 != 100) {
                stringBuffer3.append(String.valueOf(Messages.Eval_some_errors_on_metrics) + FileUtils.LINE_SEP + MessageFormat.format((String)Messages.Eval_some_errors_on_metrics1, (Object[])new String[]{stringBuffer2.substring(0, stringBuffer2.length() - 1)}));
            } else if (n / n2 == 100) {
                bl4 = true;
                stringBuffer3.append(String.valueOf(Messages.Eval_completely_compliant) + FileUtils.LINE_SEP + Messages.Eval_user_check2);
            } else {
                bl4 = true;
                stringBuffer3.append(String.valueOf(Messages.Eval_completely_compliant_with_user_check_items) + FileUtils.LINE_SEP + Messages.Eval_user_check1);
            }
        } else {
            if (n / n2 >= 50) {
                stringBuffer3.append(String.valueOf(Messages.Eval_some_accessibility_issues) + FileUtils.LINE_SEP);
            } else {
                stringBuffer3.append(String.valueOf(Messages.Eval_many_accessibility_issues) + FileUtils.LINE_SEP);
            }
            if (n5 > 0) {
                stringBuffer3.append(String.valueOf(Messages.Eval_confirm_alt_attributes_first) + FileUtils.LINE_SEP);
                stringBuffer3.append(this.getImageAltStatistics());
            } else {
                stringBuffer3.append(Messages.Eval_confirm_errors_detailed_report);
            }
        }
        if (bl2 && this.guidelineHolder.isEnabledMetric("operable")) {
            if (n3 >= 75) {
                if (this.pageData.getMaxTime() > 240) {
                    stringBuffer4.append(String.valueOf(MessageFormat.format((String)Messages.Eval_navigability_long_time_error_msg, (Object[])new String[]{FileUtils.LINE_SEP, FileUtils.LINE_SEP, FileUtils.LINE_SEP, FileUtils.LINE_SEP})) + FileUtils.LINE_SEP);
                } else {
                    stringBuffer4.append(String.valueOf(MessageFormat.format((String)Messages.Eval_navigability_good_msg, (Object[])new String[]{FileUtils.LINE_SEP, FileUtils.LINE_SEP})) + FileUtils.LINE_SEP);
                }
            } else {
                bl4 = false;
                stringBuffer4.append(String.valueOf(MessageFormat.format((String)Messages.Eval_navigability_low_score_error_msg, (Object[])new String[]{FileUtils.LINE_SEP, FileUtils.LINE_SEP, FileUtils.LINE_SEP, FileUtils.LINE_SEP})) + FileUtils.LINE_SEP);
            }
        }
        if ((bl || bl2) && bl4) {
            stringBuffer.append(String.valueOf(Messages.Eval_excellent) + FileUtils.LINE_SEP + FileUtils.LINE_SEP);
        }
        stringBuffer.append(stringBuffer3 + FileUtils.LINE_SEP + FileUtils.LINE_SEP);
        stringBuffer.append(stringBuffer4);
        return stringBuffer.toString();
    }

    private String getImageAltStatistics() {
        StringBuffer stringBuffer = new StringBuffer(FileUtils.LINE_SEP);
        if (this.noImageAltCount > 0) {
            stringBuffer.append(" -" + Messages.Eval_no_img_alt_error_msg + FileUtils.LINE_SEP);
        }
        if (this.wrongImageAltCount > 0) {
            stringBuffer.append(" -" + Messages.Eval_wrong_img_alt_error_msg + FileUtils.LINE_SEP);
        }
        if (this.redundantImageAltCount > 0) {
            stringBuffer.append(" -" + Messages.Eval_redundant_img_alt_error_msg + FileUtils.LINE_SEP);
        }
        stringBuffer.append(FileUtils.LINE_SEP);
        if (this.noImageAltCount > 0) {
            stringBuffer.append(SPACE + Messages.Eval_no_img_alt + SPACE + this.noImageAltCount + FileUtils.LINE_SEP);
        }
        if (this.wrongImageAltCount > 0) {
            stringBuffer.append(SPACE + Messages.Eval_wrong_img_alt + SPACE + this.wrongImageAltCount + FileUtils.LINE_SEP);
        }
        if (this.redundantImageAltCount > 0) {
            stringBuffer.append(SPACE + Messages.Eval_redundant_img_alt + SPACE + this.redundantImageAltCount + FileUtils.LINE_SEP);
        }
        return stringBuffer.toString();
    }
}

