/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.library.build.model;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IProject;
import org.eclipse.tea.library.build.model.BundleData;
import org.eclipse.tea.library.build.model.FeatureAttributeComparator;
import org.eclipse.tea.library.build.model.PluginInfo;
import org.eclipse.tea.library.build.services.TeaBuildVersionService;
import org.eclipse.tea.library.build.util.FileUtils;
import org.eclipse.tea.library.build.util.StreamHelper;
import org.eclipse.tea.library.build.util.StringHelper;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class FeatureData
extends BundleData {
    private Document document;
    private String version;
    private final IProject project;
    private final TeaBuildVersionService bvService;

    public FeatureData(IProject project, TeaBuildVersionService bvService) {
        super(project.getName(), project.getLocation().toFile(), true, null);
        this.project = project;
        this.bvService = bvService;
        this.document = this.readFeatureXml();
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    private static String trim(String text) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        if ((text = text.trim()).isEmpty()) {
            return null;
        }
        return text;
    }

    @Override
    public boolean isMetadataOK() {
        return this.document != null;
    }

    @Override
    public final String getBundleVersion() {
        if (this.document != null) {
            Element rootElement = this.document.getDocumentElement();
            return FeatureData.trim(rootElement.getAttribute("version"));
        }
        if (this.version != null) {
            return this.version;
        }
        return this.bvService.getBuildVersion();
    }

    @Override
    public String getBundleName() {
        if (this.document != null) {
            Element rootElement = this.document.getDocumentElement();
            return FeatureData.trim(rootElement.getAttribute("id"));
        }
        return super.getBundleName();
    }

    public String getBundleLabel() {
        Element rootElement;
        String lbl;
        if (this.document != null && !StringHelper.isNullOrEmpty(lbl = FeatureData.trim((rootElement = this.document.getDocumentElement()).getAttribute("label")))) {
            return lbl;
        }
        return this.getBundleName();
    }

    @Override
    public final void setBundleVersion(String value) {
        if (this.document != null) {
            Element rootElement = this.document.getDocumentElement();
            rootElement.setAttribute("version", value);
        } else {
            this.version = value;
        }
    }

    public final String getBundleVendor() {
        if (this.document != null) {
            Element rootElement = this.document.getDocumentElement();
            return FeatureData.trim(rootElement.getAttribute("provider-name"));
        }
        return this.bvService.getDefaultVendor();
    }

    public final void setBundleVendor(String value) {
        Element rootElement = this.document.getDocumentElement();
        rootElement.setAttribute("provider-name", value);
    }

    public final List<PluginInfo> getPluginInfos() {
        ArrayList<PluginInfo> pluginInfos = new ArrayList<PluginInfo>();
        Element rootElement = this.document.getDocumentElement();
        NodeList rootNodes = rootElement.getChildNodes();
        int i = 0;
        while (i < rootNodes.getLength()) {
            Element child;
            Node node = rootNodes.item(i);
            if (node instanceof Element && "plugin".equals((child = (Element)node).getTagName())) {
                PluginInfo info = new PluginInfo();
                info.id = child.getAttribute("id");
                info.version = child.getAttribute("version");
                pluginInfos.add(info);
            }
            ++i;
        }
        return pluginInfos;
    }

    final void reloadFeatureXml() {
        this.document = this.readFeatureXml();
    }

    File getFeatureXmlFile() {
        return new File(this.bundleDir, "feature.xml");
    }

    Document readFeatureXml() {
        try {
            return FileUtils.readXml(this.getFeatureXmlFile());
        }
        catch (Exception ex) {
            throw new IllegalStateException("cannot read " + String.valueOf(this.jarFile), ex);
        }
    }

    public final boolean writeFeatureXml() {
        if (this.document == null) {
            return false;
        }
        File xmlFile = new File(this.bundleDir, "feature.xml");
        try {
            FeatureData.writeXml(this.document, xmlFile);
            return true;
        }
        catch (Exception ex) {
            throw new IllegalStateException("cannot write " + String.valueOf(xmlFile), ex);
        }
    }

    public static void writeXml(Document document, File xmlFile) throws IOException {
        OutputStreamWriter w = null;
        try {
            w = new OutputStreamWriter((OutputStream)new FileOutputStream(xmlFile), "UTF-8");
            w.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            Element rootElement = document.getDocumentElement();
            FeatureData.writeXml(rootElement, w, "");
        }
        catch (Throwable throwable) {
            StreamHelper.closeQuietly(w);
            throw throwable;
        }
        StreamHelper.closeQuietly(w);
    }

    /*
     * WARNING - void declaration
     */
    private static void writeXml(Element elem, Writer w, String rootIndent) throws IOException {
        void var10_11;
        String tagName = elem.getTagName();
        w.write(rootIndent);
        w.write(60);
        w.write(tagName);
        String childIndent = rootIndent + "   ";
        String attrIndent = childIndent + "   ";
        boolean isMain = tagName.equals("feature") || tagName.equals("plugin") || tagName.equals("includes");
        NamedNodeMap attrs = elem.getAttributes();
        int len = attrs.getLength();
        TreeMap<String, String> sortedAttributes = new TreeMap<String, String>(FeatureAttributeComparator.fromTag(tagName));
        boolean bl = false;
        while (var10_11 < len) {
            Attr attr = (Attr)attrs.item((int)var10_11);
            sortedAttributes.put(attr.getName(), attr.getValue());
            ++var10_11;
        }
        for (Map.Entry entry : sortedAttributes.entrySet()) {
            if (isMain) {
                w.write(10);
                w.write(attrIndent);
            } else {
                w.write(32);
            }
            w.write((String)entry.getKey());
            w.write("=\"");
            w.write((String)entry.getValue());
            w.write(34);
        }
        NodeList nodeList = elem.getChildNodes();
        len = nodeList.getLength();
        if (len == 0) {
            w.write("/>\n");
        } else {
            w.write(">\n");
            int i2 = 0;
            while (i2 < len) {
                Node child = nodeList.item(i2);
                if (child instanceof Element) {
                    if (isMain) {
                        w.write(10);
                    }
                    FeatureData.writeXml((Element)child, w, childIndent);
                } else if (child instanceof Text) {
                    String text = ((Text)child).getWholeText().trim();
                    if (!text.isEmpty()) {
                        w.write(childIndent);
                        w.write(text);
                        w.write(10);
                    }
                } else {
                    w.write("<!-- " + child.getClass().getSimpleName() + " -->\n");
                }
                ++i2;
            }
            if (rootIndent.isEmpty()) {
                w.write(10);
            } else {
                w.write(rootIndent);
            }
            w.write("</");
            w.write(tagName);
            w.write(">\n");
        }
    }

    public Document generateFeatureHeader() throws ParserConfigurationException {
        DocumentBuilderFactory dbfac = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = dbfac.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element root = doc.createElement("feature");
        root.setAttribute("id", this.getBundleName());
        root.setAttribute("label", this.getBundleLabel());
        root.setAttribute("version", this.getBundleVersion());
        root.setAttribute("provider-name", this.getBundleVendor());
        doc.appendChild(root);
        return doc;
    }
}

