/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.library.build.p2;

import java.io.File;
import java.net.URI;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetHandle;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.core.target.ITargetPlatformService;
import org.eclipse.pde.core.target.LoadTargetDefinitionJob;
import org.eclipse.tea.core.services.TaskingLog;
import org.eclipse.tea.library.build.internal.Activator;
import org.eclipse.tea.library.build.p2.P2InstallationHelper;
import org.osgi.framework.BundleContext;

public class TargetPlatformHelper {
    public static Job setTargetPlatform(TaskingLog log, String tp, IProject bep, boolean user) {
        if (tp == null || tp.isEmpty()) {
            throw new IllegalStateException("no target platform set, skipping");
        }
        ITargetPlatformService service = TargetPlatformHelper.getTargetPlatformService();
        ITargetDefinition definition = null;
        try {
            IResource member;
            URI tpDef = null;
            if (tp.startsWith("/")) {
                File f = new File(tp);
                if (f.isFile()) {
                    tpDef = f.toURI();
                }
            } else if (bep != null && (member = bep.findMember(tp)) != null && member.exists() && member.getType() == 1) {
                tpDef = member.getLocationURI();
            }
            log.debug("looking up target platform, trying file: " + tpDef);
            if (tpDef == null) {
                File installLoc = P2InstallationHelper.getInstallLocation(log, tp);
                log.debug("creating target from IU install location: " + installLoc);
                definition = TargetPlatformHelper.createTargetFromLocation(service, installLoc);
            } else {
                log.debug("loading target from: " + tpDef);
                ITargetHandle target = service.getTarget(tpDef);
                definition = target.getTargetDefinition();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("cannot resolve target definition", e);
        }
        if (definition == null) {
            throw new IllegalStateException("cannot resolve target definition");
        }
        log.debug("loading target definition");
        LoadTargetDefinitionJob job = new LoadTargetDefinitionJob(definition);
        job.setUser(user);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult() != Status.OK_STATUS) {
                    Activator.log(4, "failed to set the target platform: " + event.getResult(), null);
                }
            }
        });
        job.schedule();
        return job;
    }

    private static ITargetDefinition createTargetFromLocation(ITargetPlatformService service, File installLoc) throws CoreException {
        ITargetDefinition definition = service.newTarget();
        definition.setName("Anonymous Target for Build");
        ITargetLocation loc = service.newDirectoryLocation(installLoc.getAbsolutePath());
        definition.setTargetLocations(new ITargetLocation[]{loc});
        service.saveTargetDefinition(definition);
        return definition;
    }

    public static ITargetDefinition getCurrentTargetDefinition() throws CoreException {
        ITargetPlatformService service = TargetPlatformHelper.getTargetPlatformService();
        return service.getWorkspaceTargetHandle().getTargetDefinition();
    }

    public static ITargetPlatformService getTargetPlatformService() {
        return (ITargetPlatformService)ServiceHelper.getService((BundleContext)Activator.getContext(), (String)ITargetPlatformService.class.getName());
    }
}

