/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.views.expressions;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.AbstractSourceProvider;
import org.eclipse.ui.INullSelectionListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.ISourceProvider;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.services.IEvaluationService;
import org.eclipse.ui.services.IServiceLocator;

public class SelectionSourceProvider
extends AbstractSourceProvider
implements INullSelectionListener,
IWindowListener {
    public static final String systemManagerViewSelectionName = "systemManagerViewSelection";
    public static final String debugViewSelectionName = "debugViewSelection";
    private static final String[] PROVIDED_SOURCE_NAMES = new String[]{"systemManagerViewSelection", "debugViewSelection"};
    private static final String ID_DEBUG_VIEW = "org.eclipse.debug.ui.DebugView";
    private final Map<String, ISelection> cache = new HashMap<String, ISelection>();
    private IEvaluationService service = null;

    public void initialize(IServiceLocator locator) {
        super.initialize(locator);
        if (PlatformUI.getWorkbench() != null) {
            PlatformUI.getWorkbench().addWindowListener((IWindowListener)this);
            if (PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null) {
                this.windowOpened(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
            }
        }
        if (locator.hasService(IEvaluationService.class)) {
            this.service = (IEvaluationService)locator.getService(IEvaluationService.class);
            if (this.service != null) {
                this.service.addSourceProvider((ISourceProvider)this);
            }
        }
    }

    public void dispose() {
        if (PlatformUI.getWorkbench() != null) {
            PlatformUI.getWorkbench().removeWindowListener((IWindowListener)this);
            if (PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null) {
                this.windowClosed(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
            }
        }
        if (this.service != null) {
            this.service.removeSourceProvider((ISourceProvider)this);
            this.service = null;
        }
    }

    public String[] getProvidedSourceNames() {
        return PROVIDED_SOURCE_NAMES;
    }

    public Map getCurrentState() {
        HashMap<String, ISelection> state = new HashMap<String, ISelection>();
        ISelection selection = this.cache.get("org.eclipse.tcf.te.ui.views.View");
        state.put(systemManagerViewSelectionName, (ISelection)(selection != null ? selection : IEvaluationContext.UNDEFINED_VARIABLE));
        selection = this.cache.get(ID_DEBUG_VIEW);
        state.put(debugViewSelectionName, (ISelection)(selection != null ? selection : IEvaluationContext.UNDEFINED_VARIABLE));
        return state;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        String partId;
        String string = partId = part != null ? part.getSite().getId() : null;
        if (!"org.eclipse.tcf.te.ui.views.View".equals(partId) && !ID_DEBUG_VIEW.equals(partId)) {
            return;
        }
        if (selection != null) {
            this.cache.put(partId, selection);
        } else {
            this.cache.remove(partId);
        }
        this.fireSourceChanged(0, "org.eclipse.tcf.te.ui.views.View".equals(partId) ? systemManagerViewSelectionName : debugViewSelectionName, selection != null ? selection : IEvaluationContext.UNDEFINED_VARIABLE);
    }

    public void windowActivated(IWorkbenchWindow window) {
    }

    public void windowDeactivated(IWorkbenchWindow window) {
    }

    public void windowClosed(IWorkbenchWindow window) {
        if (window != null && window.getSelectionService() != null) {
            ISelectionService service = window.getSelectionService();
            service.removePostSelectionListener("org.eclipse.tcf.te.ui.views.View", (ISelectionListener)this);
            service.removePostSelectionListener(ID_DEBUG_VIEW, (ISelectionListener)this);
        }
    }

    public void windowOpened(IWorkbenchWindow window) {
        if (window != null && window.getSelectionService() != null) {
            ISelectionService service = window.getSelectionService();
            service.removePostSelectionListener("org.eclipse.tcf.te.ui.views.View", (ISelectionListener)this);
            service.removePostSelectionListener(ID_DEBUG_VIEW, (ISelectionListener)this);
            service.addPostSelectionListener("org.eclipse.tcf.te.ui.views.View", (ISelectionListener)this);
            service.addPostSelectionListener(ID_DEBUG_VIEW, (ISelectionListener)this);
            ISelection selection = service.getSelection("org.eclipse.tcf.te.ui.views.View");
            if (selection != null) {
                this.cache.put("org.eclipse.tcf.te.ui.views.View", selection);
            } else {
                this.cache.remove("org.eclipse.tcf.te.ui.views.View");
            }
            this.fireSourceChanged(0, systemManagerViewSelectionName, selection != null ? selection : IEvaluationContext.UNDEFINED_VARIABLE);
            selection = service.getSelection(ID_DEBUG_VIEW);
            if (selection != null) {
                this.cache.put(ID_DEBUG_VIEW, selection);
            } else {
                this.cache.remove(ID_DEBUG_VIEW);
            }
            this.fireSourceChanged(0, debugViewSelectionName, selection != null ? selection : IEvaluationContext.UNDEFINED_VARIABLE);
        }
    }
}

