/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.launch.cdt.tabs;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.dsf.gdb.internal.ui.launching.GdbDebuggerPage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tcf.te.tcf.launch.cdt.interfaces.IRemoteTEConfigurationConstants;
import org.eclipse.tcf.te.tcf.launch.cdt.nls.Messages;
import org.eclipse.tcf.te.tcf.launch.cdt.preferences.IPreferenceKeys;
import org.eclipse.tcf.te.tcf.launch.cdt.utils.TEHelper;
import org.eclipse.tcf.te.ui.controls.validator.PortNumberVerifyListener;

public class TEGdbDebuggerPage
extends GdbDebuggerPage {
    protected Text fGDBServerCommandText = null;
    protected Text fGDBServerPortNumberText = null;
    protected Text fGDBServerPortNumberMappedToText = null;
    private boolean fIsInitializing = false;
    private static final Pattern VARIABLE = Pattern.compile("\\$\\{[^\\}]+\\}");

    public String getName() {
        return Messages.Remote_GDB_Debugger_Options;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        super.setDefaults(configuration);
        configuration.setAttribute(IRemoteTEConfigurationConstants.ATTR_GDBSERVER_COMMAND, TEHelper.getStringPreferenceValue(IPreferenceKeys.PREF_GDBSERVER_COMMAND));
        configuration.setAttribute(IRemoteTEConfigurationConstants.ATTR_GDBSERVER_PORT, TEHelper.getStringPreferenceValue(IPreferenceKeys.PREF_GDBSERVER_PORT));
        configuration.setAttribute(IRemoteTEConfigurationConstants.ATTR_GDBSERVER_PORT_MAPPED_TO, TEHelper.getStringPreferenceValue(IPreferenceKeys.PREF_GDBSERVER_PORT_MAPPED_TO));
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.GDB_INIT_NEW", TEHelper.getStringPreferenceValue(IPreferenceKeys.PREF_GDB_INIT));
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.setInitializing(true);
        super.initializeFrom(configuration);
        String gdbserverCommand = null;
        String gdbinitFile = null;
        String gdbserverPortNumber = null;
        String portNumberMappedTo = null;
        try {
            gdbserverCommand = configuration.getAttribute(IRemoteTEConfigurationConstants.ATTR_GDBSERVER_COMMAND, TEHelper.getStringPreferenceValue(IPreferenceKeys.PREF_GDBSERVER_COMMAND));
        }
        catch (CoreException coreException) {}
        try {
            gdbserverPortNumber = configuration.getAttribute(IRemoteTEConfigurationConstants.ATTR_GDBSERVER_PORT, TEHelper.getStringPreferenceValue(IPreferenceKeys.PREF_GDBSERVER_PORT));
        }
        catch (CoreException coreException) {}
        try {
            portNumberMappedTo = configuration.getAttribute(IRemoteTEConfigurationConstants.ATTR_GDBSERVER_PORT_MAPPED_TO, TEHelper.getStringPreferenceValue(IPreferenceKeys.PREF_GDBSERVER_PORT_MAPPED_TO));
        }
        catch (CoreException coreException) {}
        try {
            gdbinitFile = configuration.getAttribute("org.eclipse.cdt.dsf.gdb.GDB_INIT_NEW", TEHelper.getStringPreferenceValue(IPreferenceKeys.PREF_GDB_INIT));
        }
        catch (CoreException coreException) {}
        if (this.fGDBServerCommandText != null) {
            this.fGDBServerCommandText.setText(gdbserverCommand);
        }
        if (this.fGDBServerPortNumberText != null) {
            this.fGDBServerPortNumberText.setText(gdbserverPortNumber);
        }
        if (this.fGDBServerPortNumberMappedToText != null) {
            this.fGDBServerPortNumberMappedToText.setText(portNumberMappedTo != null ? portNumberMappedTo : "");
        }
        if (this.fGDBInitText != null && gdbinitFile != null && !"".equals(gdbinitFile)) {
            this.fGDBInitText.setText(gdbinitFile);
        }
        this.setInitializing(false);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        super.performApply(configuration);
        String str = this.fGDBServerCommandText != null ? this.fGDBServerCommandText.getText().trim() : null;
        configuration.setAttribute(IRemoteTEConfigurationConstants.ATTR_GDBSERVER_COMMAND, str);
        str = this.fGDBServerPortNumberText != null ? this.fGDBServerPortNumberText.getText().trim() : null;
        configuration.setAttribute(IRemoteTEConfigurationConstants.ATTR_GDBSERVER_PORT, str);
        str = this.fGDBServerPortNumberMappedToText != null ? this.fGDBServerPortNumberMappedToText.getText().trim() : null;
        configuration.setAttribute(IRemoteTEConfigurationConstants.ATTR_GDBSERVER_PORT_MAPPED_TO, str != null && !"".equals(str) ? str : null);
        String string = str = this.fGDBInitText != null ? this.fGDBInitText.getText().trim() : null;
        if (str != null) {
            boolean hasVariables = false;
            Matcher matcher = VARIABLE.matcher(str);
            while (matcher.find()) {
                String var = matcher.group();
                if ("".equals(var)) continue;
                hasVariables = true;
                break;
            }
            if (!hasVariables) {
                str = null;
            }
        }
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.GDB_INIT_NEW", str);
    }

    protected void createGdbserverSettingsTab(TabFolder tabFolder) {
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(Messages.Gdbserver_Settings_Tab_Name);
        Composite comp = new Composite((Composite)tabFolder, 0);
        comp.setLayout((Layout)new GridLayout(1, false));
        comp.setLayoutData((Object)new GridData(1808));
        comp.setFont(tabFolder.getFont());
        tabItem.setControl((Control)comp);
        Composite subComp = new Composite(comp, 0);
        subComp.setLayout((Layout)new GridLayout(2, false));
        subComp.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        subComp.setFont(tabFolder.getFont());
        Label label = new Label(subComp, 16384);
        label.setText(Messages.Gdbserver_name_textfield_label);
        this.fGDBServerCommandText = new Text(subComp, 2052);
        GridData data = new GridData(4, 0x1000000, true, false);
        this.fGDBServerCommandText.setLayoutData((Object)data);
        this.fGDBServerCommandText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                TEGdbDebuggerPage.this.updateLaunchConfigurationDialog();
            }
        });
        label = new Label(subComp, 16384);
        label.setText(Messages.Port_number_textfield_label);
        this.fGDBServerPortNumberText = new Text(subComp, 2052);
        data = new GridData(4, 0x1000000, true, false);
        this.fGDBServerPortNumberText.setLayoutData((Object)data);
        this.fGDBServerPortNumberText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                TEGdbDebuggerPage.this.updateLaunchConfigurationDialog();
            }
        });
        this.fGDBServerPortNumberText.addVerifyListener((VerifyListener)new PortNumberVerifyListener(3));
        label = new Label(subComp, 16384);
        label.setText(Messages.Port_number_mapped_to_textfield_label);
        this.fGDBServerPortNumberMappedToText = new Text(subComp, 2052);
        data = new GridData(4, 0x1000000, true, false);
        this.fGDBServerPortNumberMappedToText.setLayoutData((Object)data);
        this.fGDBServerPortNumberMappedToText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                TEGdbDebuggerPage.this.updateLaunchConfigurationDialog();
            }
        });
        this.fGDBServerPortNumberMappedToText.addVerifyListener((VerifyListener)new PortNumberVerifyListener(3));
    }

    public void createTabs(TabFolder tabFolder) {
        super.createTabs(tabFolder);
        this.createGdbserverSettingsTab(tabFolder);
    }

    protected boolean isInitializing() {
        return this.fIsInitializing;
    }

    private void setInitializing(boolean isInitializing) {
        this.fIsInitializing = isInitializing;
    }
}

