/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.cdt.ui;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tcf.internal.cdt.ui.Activator;
import org.osgi.framework.Bundle;

public class ImageCache {
    public static final String IMG_TARGET_TAB = "icons/target_tab.gif";
    public static final String IMG_BREAKPOINT_SCOPE = "icons/obj16/bp_scope.gif";
    private static final Map<String, ImageDescriptor> desc_cache = new HashMap<String, ImageDescriptor>();
    private static final Map<ImageDescriptor, Image> image_cache = new HashMap<ImageDescriptor, Image>();

    public static synchronized ImageDescriptor getImageDescriptor(String name) {
        if (name == null) {
            return null;
        }
        ImageDescriptor descriptor = desc_cache.get(name);
        if (descriptor == null) {
            URL url;
            Bundle bundle = Activator.getDefault().getBundle();
            if (bundle != null && (url = FileLocator.find((Bundle)bundle, (IPath)new Path(name), null)) != null) {
                descriptor = ImageDescriptor.createFromURL((URL)url);
            }
            if (descriptor == null) {
                bundle = Platform.getBundle((String)"org.eclipse.tcf.debug.ui");
                if (bundle != null && (url = FileLocator.find((Bundle)bundle, (IPath)new Path(name), null)) != null) {
                    descriptor = ImageDescriptor.createFromURL((URL)url);
                }
                if (descriptor == null && (bundle = Platform.getBundle((String)"org.eclipse.debug.ui")) != null && (url = FileLocator.find((Bundle)bundle, (IPath)new Path(name), null)) != null) {
                    descriptor = ImageDescriptor.createFromURL((URL)url);
                }
            }
            if (descriptor == null) {
                descriptor = ImageDescriptor.getMissingImageDescriptor();
            }
            desc_cache.put(name, descriptor);
        }
        return descriptor;
    }

    public static synchronized Image getImage(ImageDescriptor desc) {
        Image image = image_cache.get(desc);
        if (image == null) {
            image = desc.createImage();
            image_cache.put(desc, image);
        }
        return image;
    }

    public static synchronized Image getImage(String name) {
        return ImageCache.getImage(ImageCache.getImageDescriptor(name));
    }
}

