/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.Launch;
import org.eclipse.tcf.internal.debug.model.TCFLaunch;
import org.eclipse.tcf.internal.debug.ui.Activator;
import org.eclipse.tcf.internal.debug.ui.model.TCFMemoryBlockRetrieval;
import org.eclipse.tcf.internal.debug.ui.model.TCFModel;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeLaunch;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.PlatformUI;

public class TCFModelManager {
    private static final Map<TCFLaunch, TCFModel> sync_model_map = Collections.synchronizedMap(new HashMap());
    private final Map<TCFLaunch, TCFModel> models = new HashMap<TCFLaunch, TCFModel>();
    private final List<ModelManagerListener> listeners = new ArrayList<ModelManagerListener>();
    private final TCFLaunch.LaunchListener tcf_launch_listener = new TCFLaunch.LaunchListener(){

        public void onCreated(TCFLaunch launch) {
            if (!$assertionsDisabled && !Protocol.isDispatchThread()) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && TCFModelManager.this.models.get(launch) != null) {
                throw new AssertionError();
            }
            TCFModel model = new TCFModel(launch);
            TCFModelManager.this.models.put(launch, model);
            sync_model_map.put(launch, model);
        }

        public void onConnected(TCFLaunch launch) {
            if (!$assertionsDisabled && !Protocol.isDispatchThread()) {
                throw new AssertionError();
            }
            TCFModel model = (TCFModel)TCFModelManager.this.models.get(launch);
            if (model != null) {
                model.onConnected();
            }
            for (ModelManagerListener l : TCFModelManager.this.listeners) {
                try {
                    l.onConnected(launch, model);
                }
                catch (Throwable x) {
                    Activator.log(x);
                }
            }
        }

        public void onDisconnected(TCFLaunch launch) {
            if (!$assertionsDisabled && !Protocol.isDispatchThread()) {
                throw new AssertionError();
            }
            TCFModel model = (TCFModel)TCFModelManager.this.models.get(launch);
            if (model != null) {
                model.onDisconnected();
            }
            for (ModelManagerListener l : TCFModelManager.this.listeners) {
                try {
                    l.onDisconnected(launch, model);
                }
                catch (Throwable x) {
                    Activator.log(x);
                }
            }
        }

        public void onProcessOutput(TCFLaunch launch, String process_id, int stream_id, byte[] data) {
            if (!$assertionsDisabled && !Protocol.isDispatchThread()) {
                throw new AssertionError();
            }
            TCFModel model = (TCFModel)TCFModelManager.this.models.get(launch);
            if (model != null) {
                model.onProcessOutput(process_id, stream_id, data);
            }
        }

        public void onProcessStreamError(TCFLaunch launch, String process_id, int stream_id, Exception error, int lost_size) {
            if (!$assertionsDisabled && !Protocol.isDispatchThread()) {
                throw new AssertionError();
            }
            TCFModel model = (TCFModel)TCFModelManager.this.models.get(launch);
            if (model != null) {
                model.onProcessStreamError(process_id, stream_id, error, lost_size);
            }
        }
    };
    private final ILaunchesListener debug_launch_listener = new ILaunchesListener(){

        public void launchesAdded(ILaunch[] launches) {
        }

        public void launchesChanged(final ILaunch[] launches) {
            Protocol.invokeAndWait((Runnable)new Runnable(){

                @Override
                public void run() {
                    ILaunch[] iLaunchArray = launches;
                    int n = launches.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ILaunch launch = iLaunchArray[n2];
                        TCFModel model = (TCFModel)TCFModelManager.this.models.get(launch);
                        if (model != null) {
                            model.launchChanged();
                        }
                        ++n2;
                    }
                }
            });
        }

        public void launchesRemoved(final ILaunch[] launches) {
            Protocol.invokeAndWait((Runnable)new Runnable(){

                @Override
                public void run() {
                    ILaunch[] iLaunchArray = launches;
                    int n = launches.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ILaunch launch = iLaunchArray[n2];
                        TCFModel model = (TCFModel)TCFModelManager.this.models.remove(launch);
                        if (model != null) {
                            sync_model_map.remove(launch);
                            model.dispose();
                        }
                        ++n2;
                    }
                }
            });
        }
    };
    private final IWorkbenchListener workbench_listener = new IWorkbenchListener(){

        public boolean preShutdown(IWorkbench workbench, boolean forced) {
            ILaunch[] iLaunchArray = DebugPlugin.getDefault().getLaunchManager().getLaunches();
            int n = iLaunchArray.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunch launch = iLaunchArray[n2];
                if (launch instanceof TCFLaunch) {
                    try {
                        ((TCFLaunch)launch).disconnect();
                        DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
                    }
                    catch (Exception x) {
                        Activator.log("Cannot disconnect TCF launch", x);
                    }
                }
                ++n2;
            }
            TCFMemoryBlockRetrieval.onWorkbenchShutdown();
            return true;
        }

        public void postShutdown(IWorkbench workbench) {
        }
    };

    public TCFModelManager() {
        assert (Protocol.isDispatchThread());
        try {
            PlatformUI.getWorkbench().addWorkbenchListener(this.workbench_listener);
        }
        catch (IllegalStateException illegalStateException) {}
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener(this.debug_launch_listener);
        TCFLaunch.addListener((TCFLaunch.LaunchListener)this.tcf_launch_listener);
    }

    public void dispose() {
        assert (Protocol.isDispatchThread());
        try {
            PlatformUI.getWorkbench().removeWorkbenchListener(this.workbench_listener);
        }
        catch (IllegalStateException illegalStateException) {}
        DebugPlugin.getDefault().getLaunchManager().removeLaunchListener(this.debug_launch_listener);
        TCFLaunch.removeListener((TCFLaunch.LaunchListener)this.tcf_launch_listener);
        Iterator<TCFModel> i = this.models.values().iterator();
        while (i.hasNext()) {
            TCFModel model = i.next();
            sync_model_map.remove(model.getLaunch());
            model.dispose();
            i.remove();
        }
        assert (this.models.isEmpty());
    }

    public void addListener(ModelManagerListener l) {
        this.listeners.add(l);
    }

    public void removeListener(ModelManagerListener l) {
        this.listeners.remove(l);
    }

    public Collection<TCFModel> getModels() {
        assert (Protocol.isDispatchThread());
        return this.models.values();
    }

    public TCFModel getModel(TCFLaunch launch) {
        assert (Protocol.isDispatchThread());
        return this.models.get(launch);
    }

    public TCFNodeLaunch getRootNode(TCFLaunch launch) {
        TCFModel model = this.getModel(launch);
        if (model == null) {
            return null;
        }
        return model.getRootNode();
    }

    public static TCFModelManager getModelManager() {
        return Activator.getModelManager();
    }

    public static TCFModel getModelSync(Launch launch) {
        if (launch instanceof TCFLaunch) {
            return sync_model_map.get((TCFLaunch)launch);
        }
        return null;
    }

    public static TCFNodeLaunch getRootNodeSync(Launch launch) {
        TCFModel model;
        if (launch instanceof TCFLaunch && (model = sync_model_map.get((TCFLaunch)launch)) != null) {
            return model.getRootNode();
        }
        return null;
    }

    public static interface ModelManagerListener {
        public void onConnected(TCFLaunch var1, TCFModel var2);

        public void onDisconnected(TCFLaunch var1, TCFModel var2);
    }
}

