/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.views.controls;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.model.interfaces.IContainerModelNode;
import org.eclipse.tcf.te.runtime.model.interfaces.IModelNode;
import org.eclipse.tcf.te.runtime.properties.PropertiesContainer;
import org.eclipse.tcf.te.runtime.services.ServiceManager;
import org.eclipse.tcf.te.runtime.services.interfaces.IPropertiesAccessService;
import org.eclipse.tcf.te.ui.controls.AbstractDecoratedDialogPageControl;
import org.eclipse.tcf.te.ui.jface.interfaces.IValidatingContainer;
import org.eclipse.tcf.te.ui.swt.SWTControlUtil;
import org.eclipse.tcf.te.ui.views.interfaces.ICategory;
import org.eclipse.tcf.te.ui.views.nls.Messages;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;
import org.eclipse.ui.navigator.CommonViewerSorter;

public abstract class AbstractContextSelectorControl
extends AbstractDecoratedDialogPageControl
implements ISelectionProvider {
    public static final String PROPERTY_SHOW_GHOST_MODEL_NODES = "showGhostModelNodes";
    public static final String PROPERTY_MULTI_CONTEXT_SELECTOR = "multiContextSelector";
    private Throwable lastFailureCause;
    private boolean requireSelection = true;
    private final List<ISelectionChangedListener> selectionListeners = new ArrayList<ISelectionChangedListener>();
    private final IPropertiesContainer properties = new PropertiesContainer();
    private TreeViewer viewer;
    ISelection selection;
    protected static final ViewerFilter[] NO_FILTERS = new ViewerFilter[0];
    protected static final IModelNode[] NO_CONTEXTS = new IModelNode[0];
    private ViewerFilter[] filters;
    private ICheckStateListener listener;

    boolean isGhost(IModelNode node) {
        Assert.isNotNull((Object)node);
        IPropertiesAccessService service = (IPropertiesAccessService)ServiceManager.getInstance().getService((Object)node, IPropertiesAccessService.class);
        if (service != null) {
            Object value = service.getProperty((Object)node, "isghost");
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            if (value instanceof String) {
                return Boolean.valueOf((String)value);
            }
            return false;
        }
        try {
            return node.isProperty("isghost", true);
        }
        catch (AssertionFailedException assertionFailedException) {
            return false;
        }
    }

    public AbstractContextSelectorControl(IDialogPage parentPage) {
        super(parentPage);
        this.selectionListeners.clear();
        this.initializeProperties(this.getPropertiesContainer());
    }

    public final IPropertiesContainer getPropertiesContainer() {
        return this.properties;
    }

    protected void initializeProperties(IPropertiesContainer properties) {
        Assert.isNotNull((Object)properties);
        properties.setProperty(PROPERTY_SHOW_GHOST_MODEL_NODES, false);
        properties.setProperty(PROPERTY_MULTI_CONTEXT_SELECTOR, false);
    }

    public final void setLastFailureCause(Throwable cause) {
        this.lastFailureCause = cause;
        if (this.getParentPage() instanceof IValidatingContainer) {
            ((IValidatingContainer)this.getParentPage()).validate();
        }
    }

    public final Throwable getLastFailureCause() {
        return this.lastFailureCause;
    }

    public String getDefaultTitle() {
        return null;
    }

    public void dispose() {
        this.viewer = null;
        super.dispose();
    }

    public IModelNode[] getCheckedModelContexts() {
        if (!this.getViewer().getControl().isDisposed() && this.getViewer() instanceof ContainerCheckedTreeViewer && (this.getTreeViewerStyle() & 0x20) != 0) {
            List grayed;
            ContainerCheckedTreeViewer viewer = (ContainerCheckedTreeViewer)this.getViewer();
            List checked = viewer.getCheckedElements() != null ? Arrays.asList(viewer.getCheckedElements()) : Collections.emptyList();
            List<Object> list = grayed = viewer.getGrayedElements() != null ? Arrays.asList(viewer.getGrayedElements()) : Collections.emptyList();
            if (!checked.isEmpty()) {
                ArrayList<IModelNode> contexts = new ArrayList<IModelNode>();
                for (Object element : checked) {
                    if (element instanceof IModelNode) {
                        IContainerModelNode parent;
                        IModelNode node = (IModelNode)element;
                        IPropertiesAccessService service = (IPropertiesAccessService)ServiceManager.getInstance().getService((Object)node, IPropertiesAccessService.class);
                        Object object = parent = service != null ? (IModelNode)service.getParent((Object)node) : node.getParent();
                        if (parent != null && checked.contains(parent) && !grayed.contains(parent)) continue;
                    }
                    if (!(element instanceof IModelNode) || grayed.contains(element)) continue;
                    contexts.add((IModelNode)element);
                }
                return contexts.toArray(new IModelNode[contexts.size()]);
            }
        }
        return NO_CONTEXTS;
    }

    protected void onCheckStateChanged(Object element, boolean checked) {
        if (checked && this.getPropertiesContainer().isProperty(PROPERTY_MULTI_CONTEXT_SELECTOR, false) && this.getViewer() instanceof ContextSelectorTreeViewer) {
            ContextSelectorTreeViewer viewer = (ContextSelectorTreeViewer)this.getViewer();
            Item[] childItems = viewer.getChildren(element);
            if (childItems != null && childItems.length > 1) {
                viewer.setCheckedElements(new Object[]{childItems[0].getData()});
            } else {
                viewer.setCheckedElements(new Object[]{element});
            }
        }
    }

    public void setCheckedModelContexts(IModelNode[] contexts) {
        Assert.isNotNull((Object)contexts);
        if (this.getViewer() instanceof ContainerCheckedTreeViewer && (this.getTreeViewerStyle() & 0x20) != 0) {
            ContainerCheckedTreeViewer viewer = (ContainerCheckedTreeViewer)this.getViewer();
            viewer.setCheckedElements((Object[])contexts);
            if (contexts.length > 0) {
                viewer.setSelection((ISelection)new StructuredSelection((Object)contexts[0]), true);
            }
        }
    }

    public final TreeViewer getViewer() {
        return this.viewer;
    }

    public void setupPanel(Composite parent) {
        super.setupPanel(parent);
        Composite composite = this.doCreateTopContainerComposite(parent);
        Assert.isNotNull((Object)composite);
        this.viewer = this.createTreeViewerControl(composite);
        this.configureControlListener();
        this.viewer.setSelection(this.viewer.getSelection());
    }

    protected Composite doCreateTopContainerComposite(Composite parent) {
        Assert.isNotNull((Object)parent);
        int style = 1808;
        int heightHint = -1;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData layoutData = new GridData(style);
        layoutData.heightHint = heightHint;
        composite.setLayoutData((Object)layoutData);
        return composite;
    }

    protected TreeViewer createTreeViewerControl(Composite parent) {
        Assert.isNotNull((Object)parent);
        CheckboxTreeViewer viewer = this.doCreateNewTreeViewerControl(parent, this.getTreeViewerStyle());
        this.doConfigureTreeViewerControl(viewer);
        viewer.setInput(this.getInitialViewerInput());
        this.doEnableControl((TreeViewer)viewer);
        return viewer;
    }

    protected CheckboxTreeViewer doCreateNewTreeViewerControl(Composite parent, int style) {
        return new ContextSelectorTreeViewer(parent, style);
    }

    protected void doConfigureTreeViewerControl(CheckboxTreeViewer viewer) {
        Assert.isNotNull((Object)viewer);
        viewer.setUseHashlookup(true);
        this.doConfigureTreeLayoutData(viewer.getTree());
        this.doConfigureTreeContentAndLabelProvider((TreeViewer)viewer);
        viewer.setSorter(this.doCreateViewerSorter());
        if ((this.getTreeViewerStyle() & 0x20) != 0 && this.getViewerCheckStateListener(viewer) != null) {
            viewer.addCheckStateListener(this.getViewerCheckStateListener(viewer));
        }
        if (this.hasViewerFilters()) {
            viewer.setFilters(this.getViewerFilters());
        }
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AbstractContextSelectorControl.this.selection = event.getSelection();
                AbstractContextSelectorControl.this.fireSelectionChanged();
            }
        });
        this.doCreateControlDecoration((Control)viewer.getTree());
    }

    protected void doConfigureTreeLayoutData(Tree tree) {
        GridData layoutData = new GridData(768);
        layoutData.heightHint = 150;
        tree.setLayoutData((Object)layoutData);
    }

    protected int getTreeViewerStyle() {
        return 2850;
    }

    protected ViewerSorter doCreateViewerSorter() {
        return new CommonViewerSorter();
    }

    protected boolean hasViewerFilters() {
        return true;
    }

    protected ViewerFilter[] doCreateViewerFilters() {
        return new ViewerFilter[]{new ContextSelectorViewerFilter()};
    }

    protected ViewerFilter[] getViewerFilters() {
        if (this.filters == null && this.hasViewerFilters()) {
            this.filters = this.doCreateViewerFilters();
        }
        return this.filters != null ? this.filters : NO_FILTERS;
    }

    protected ICheckStateListener doCreateViewerCheckStateListener(CheckboxTreeViewer viewer) {
        Assert.isNotNull((Object)viewer);
        return new ContextSelectedCheckStateListener();
    }

    protected ICheckStateListener getViewerCheckStateListener(CheckboxTreeViewer viewer) {
        Assert.isNotNull((Object)viewer);
        if (this.listener == null) {
            this.listener = this.doCreateViewerCheckStateListener(viewer);
        }
        return this.listener;
    }

    protected abstract Object getInitialViewerInput();

    protected abstract void doConfigureTreeContentAndLabelProvider(TreeViewer var1);

    protected void doEnableControl(TreeViewer viewer) {
        Assert.isNotNull((Object)viewer);
        SWTControlUtil.setEnabled((Control)viewer.getTree(), (viewer.getTree().getItemCount() > 0 ? 1 : 0) != 0);
    }

    public void refresh() {
        if (this.viewer != null && this.viewer.getControl() != null && !this.viewer.getControl().isDisposed()) {
            this.viewer.refresh(true);
            this.doEnableControl(this.viewer);
        }
    }

    protected void configureControlListener() {
    }

    public void setSelection(ISelection selection) {
        Assert.isNotNull((Object)selection);
        this.selection = selection;
        if (this.viewer != null) {
            this.viewer.setSelection(selection, true);
        }
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (listener != null && !this.selectionListeners.contains(listener)) {
            this.selectionListeners.add(listener);
        }
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        if (listener != null) {
            this.selectionListeners.remove(listener);
        }
    }

    void fireSelectionChanged() {
        if (this.selection != null) {
            SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.selection);
            for (ISelectionChangedListener listener : this.selectionListeners) {
                listener.selectionChanged(event);
            }
        }
    }

    public boolean isValid() {
        boolean valid = super.isValid();
        if (!valid) {
            return valid;
        }
        boolean bl = valid = this.getLastFailureCause() == null;
        if (!valid) {
            this.setMessage(this.getLastFailureCause().getLocalizedMessage(), 3);
        }
        if (valid && (this.getTreeViewerStyle() & 0x20) != 0 && this.requireSelection) {
            int count = this.getCheckedModelContexts().length;
            boolean bl2 = valid = count == 1 || count > 1 && this.getPropertiesContainer().isProperty(PROPERTY_MULTI_CONTEXT_SELECTOR, true);
            if (!valid) {
                String messageId = "AbstractContextSelectorControl_error_noContextSelected";
                messageId = this.getPropertiesContainer().isProperty(PROPERTY_MULTI_CONTEXT_SELECTOR, true) ? String.valueOf(messageId) + "_multi" : String.valueOf(messageId) + "_single";
                this.setMessage(this.getMessageForId(messageId), this.getMessageTypeForId(messageId, 3));
            }
        }
        if (this.getControlDecoration() != null) {
            if (this.isEnabled() && (!valid || this.getMessage() != null && this.getMessageType() != 0)) {
                this.updateControlDecoration(this.getMessage(), this.getMessageType());
            } else {
                this.updateControlDecoration(null, 0);
            }
        }
        return valid;
    }

    protected String getMessageForId(String messageId) {
        Assert.isNotNull((Object)messageId);
        return Messages.getString(messageId);
    }

    protected int getMessageTypeForId(String messageId, int proposed) {
        Assert.isNotNull((Object)messageId);
        return proposed;
    }

    public void setRequireSelection(boolean value) {
        this.requireSelection = value;
    }

    protected class ContextSelectedCheckStateListener
    implements ICheckStateListener {
        protected ContextSelectedCheckStateListener() {
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            Object element = event.getElement();
            boolean checked = event.getChecked();
            AbstractContextSelectorControl.this.onCheckStateChanged(element, checked);
            if (AbstractContextSelectorControl.this.getParentPage() instanceof IValidatingContainer) {
                ((IValidatingContainer)AbstractContextSelectorControl.this.getParentPage()).validate();
            }
        }
    }

    protected class ContextSelectorTreeViewer
    extends ContainerCheckedTreeViewer {
        public ContextSelectorTreeViewer(Composite parent, int style) {
            this(new Tree(parent, style));
        }

        public ContextSelectorTreeViewer(Composite parent) {
            super(parent);
        }

        public ContextSelectorTreeViewer(Tree tree) {
            super(tree);
        }

        public boolean isExpandable(Object element) {
            boolean expandable = super.isExpandable(element);
            if (expandable) {
                expandable = this.getFilteredChildren(element).length > 0;
            }
            return expandable;
        }

        public Item[] getChildren(Object element) {
            Widget item = this.findItem(element);
            return this.getChildren(item);
        }

        protected void doCheckStateChanged(Object element) {
            Widget item;
            boolean skipDoubleCheckParentState = false;
            if (!(skipDoubleCheckParentState |= !(element instanceof IModelNode))) {
                skipDoubleCheckParentState |= !AbstractContextSelectorControl.this.isGhost((IModelNode)element);
            }
            if (!skipDoubleCheckParentState) {
                IPropertiesAccessService service = (IPropertiesAccessService)ServiceManager.getInstance().getService(IPropertiesAccessService.class);
                IModelNode parent = service != null ? (IModelNode)service.getParent(element) : null;
                skipDoubleCheckParentState |= parent == null || !AbstractContextSelectorControl.this.isGhost(parent);
            }
            super.doCheckStateChanged(element);
            if (!skipDoubleCheckParentState && (item = this.findItem(element)) instanceof TreeItem) {
                TreeItem treeItem = ((TreeItem)item).getParentItem();
                while (treeItem != null) {
                    boolean isGhost;
                    Object data = treeItem.getData();
                    if (!treeItem.getExpanded()) {
                        treeItem.setExpanded(true);
                    }
                    boolean bl = isGhost = data instanceof IModelNode && AbstractContextSelectorControl.this.isGhost((IModelNode)data);
                    if (!treeItem.getGrayed() && isGhost) {
                        treeItem.setGrayed(true);
                    }
                    treeItem = treeItem.getParentItem();
                }
            }
        }
    }

    protected class ContextSelectorViewerFilter
    extends ViewerFilter {
        protected ContextSelectorViewerFilter() {
        }

        protected boolean doShowGhostModelElements() {
            return AbstractContextSelectorControl.this.getPropertiesContainer().getBooleanProperty(AbstractContextSelectorControl.PROPERTY_SHOW_GHOST_MODEL_NODES);
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof ICategory) {
                return ((ICategory)element).isEnabled();
            }
            if (element instanceof IModelNode) {
                if (AbstractContextSelectorControl.this.isGhost((IModelNode)element)) {
                    return this.doShowGhostModelElements();
                }
                return true;
            }
            return false;
        }
    }
}

