/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.core.activator;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.url.TcfURLStreamHandlerService;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.utils.PersistenceManager;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.url.URLStreamHandlerService;

public class CorePlugin
extends Plugin {
    private static final String PREFKEY_REVEAL_ON_CONNECT = "revealOnConnect";
    private static final String PLUGIN_ID = "org.eclipse.tcf.te.tcf.filesystem.core";
    private static BundleContext context;
    private static CorePlugin plugin;
    private ServiceRegistration<?> regURLStreamHandlerService;
    private Set<String> fRevealOnConnect;

    static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        context = bundleContext;
        plugin = this;
        Hashtable<String, String[]> properties = new Hashtable<String, String[]>();
        properties.put("url.handler.protocol", new String[]{"tcf"});
        this.regURLStreamHandlerService = context.registerService(URLStreamHandlerService.class.getName(), (Object)new TcfURLStreamHandlerService(), properties);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        if (PersistenceManager.needsDisposal()) {
            PersistenceManager.getInstance().dispose();
        }
        if (this.regURLStreamHandlerService != null) {
            this.regURLStreamHandlerService.unregister();
            this.regURLStreamHandlerService = null;
        }
        context = null;
        plugin = null;
        super.stop(bundleContext);
    }

    public static CorePlugin getDefault() {
        return plugin;
    }

    public static String getUniqueIdentifier() {
        return PLUGIN_ID;
    }

    public boolean addToRevealOnConnect(String location) {
        if (this.unsafeGetRevealOnConnect().add(location)) {
            this.storeRevealOnConnect();
            return true;
        }
        return false;
    }

    public boolean removeFromRevealOnConnect(String location) {
        if (this.unsafeGetRevealOnConnect().remove(location)) {
            this.storeRevealOnConnect();
            return true;
        }
        return false;
    }

    public boolean isRevealOnConnect(String location) {
        return this.unsafeGetRevealOnConnect().contains(location);
    }

    public Set<String> getRevealOnConnect() {
        return new HashSet<String>(this.unsafeGetRevealOnConnect());
    }

    private void storeRevealOnConnect() {
        if (this.fRevealOnConnect == null) {
            return;
        }
        StringBuilder buf = new StringBuilder();
        for (String reveal : this.fRevealOnConnect) {
            if (buf.length() > 0) {
                buf.append("\u0000");
            }
            buf.append(reveal);
        }
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode(PLUGIN_ID);
        node.put(PREFKEY_REVEAL_ON_CONNECT, buf.toString());
        try {
            node.flush();
        }
        catch (BackingStoreException backingStoreException) {}
    }

    private Set<String> unsafeGetRevealOnConnect() {
        if (this.fRevealOnConnect == null) {
            HashSet<String> favorites = new HashSet<String>();
            String favs = Platform.getPreferencesService().getString(PLUGIN_ID, PREFKEY_REVEAL_ON_CONNECT, "", null);
            String[] stringArray = favs.split("\u0000");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String fav = stringArray[n2];
                if (fav.length() > 0) {
                    favorites.add(fav);
                }
                ++n2;
            }
            this.fRevealOnConnect = favorites;
        }
        return this.fRevealOnConnect;
    }
}

