/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.core.utils.text;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Assert;

public final class StringUtil {
    private static final Pattern ALLOWED_STRING_PATTERN = Pattern.compile("[a-zA-Z0-9_@.-]*");

    public static String[] tokenize(String arguments, int maxArgs, boolean keepQuotes) {
        Assert.isNotNull((Object)arguments);
        ArrayList<String> result = maxArgs > 0 ? new ArrayList<String>(maxArgs) : new ArrayList();
        StreamTokenizer tok = new StreamTokenizer(new StringReader(arguments));
        tok.resetSyntax();
        tok.whitespaceChars(0, 32);
        tok.wordChars(33, 255);
        tok.whitespaceChars(160, 160);
        tok.quoteChar(34);
        for (int nArgs = 0; maxArgs <= 0 || nArgs < maxArgs; ++nArgs) {
            try {
                int ttype = tok.nextToken();
                if (ttype == -1) break;
                if (keepQuotes && ttype == 34) {
                    String quoted = StringUtil.enQuote(tok.sval);
                    if (quoted.length() < 2 || quoted.charAt(0) != '\"' || quoted.charAt(quoted.length() - 1) != '\"') {
                        quoted = String.valueOf('\"') + quoted + '\"';
                    }
                    result.add(quoted);
                    continue;
                }
                result.add(tok.sval);
                continue;
            }
            catch (IOException iOException) {
                break;
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public static String enQuote(String unqouted) {
        if (unqouted == null) {
            return "\"\"";
        }
        if (unqouted.length() == 0) {
            return "\"\"";
        }
        if (ALLOWED_STRING_PATTERN.matcher(unqouted).matches()) {
            return unqouted;
        }
        StringReader r = new StringReader(unqouted);
        StringBuffer buf = new StringBuffer(unqouted.length() + 16);
        boolean containsWhitespaces = Pattern.compile("\\s").matcher(unqouted).find();
        if (containsWhitespaces) {
            buf.append('\"');
        }
        try {
            int c = r.read();
            while (c >= 0) {
                switch (c) {
                    case 34: 
                    case 39: {
                        buf.append('\\');
                        buf.append((char)c);
                        break;
                    }
                    case 8: {
                        buf.append("\\b");
                        break;
                    }
                    case 12: {
                        buf.append("\\f");
                        break;
                    }
                    case 10: {
                        buf.append("\\n");
                        break;
                    }
                    case 13: {
                        buf.append("\\r");
                        break;
                    }
                    case 9: {
                        buf.append("\\t");
                        break;
                    }
                    default: {
                        if (c > 255) {
                            buf.append('\\');
                            buf.append('u');
                            String hexString = Integer.toHexString(c);
                            if (hexString.length() < 4) {
                                buf.append('0');
                            }
                            buf.append(hexString);
                            break;
                        }
                        if (c < 32 || c > 126) {
                            buf.append('\\');
                            buf.append(Integer.toOctalString(c));
                            break;
                        }
                        buf.append((char)c);
                    }
                }
                c = r.read();
            }
        }
        catch (IOException iOException) {}
        r.close();
        if (containsWhitespaces) {
            buf.append('\"');
        }
        return buf.toString();
    }
}

