/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.ui.internal.celleditor;

import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.tcf.te.tcf.filesystem.ui.activator.UIPlugin;

public class FSCellListener
implements ICellEditorListener {
    private TextCellEditor editor;
    private DefaultToolTip tooltip;

    public FSCellListener(TextCellEditor editor) {
        this.editor = editor;
    }

    public void applyEditorValue() {
        this.disposeToolTip();
    }

    public void cancelEditor() {
        this.disposeToolTip();
    }

    public void editorValueChanged(boolean oldValidState, boolean newValidState) {
        if (!newValidState) {
            if (this.tooltip == null) {
                this.tooltip = new DefaultToolTip(this.editor.getControl(), 1, true);
                this.tooltip.setImage(UIPlugin.getImage("ErrorImage"));
            }
            this.tooltip.setText(this.editor.getErrorMessage());
            Control control = this.editor.getControl();
            Point pOnScr = control.getSize();
            pOnScr.x = 0;
            this.tooltip.show(pOnScr);
        } else {
            this.disposeToolTip();
        }
    }

    private void disposeToolTip() {
        if (this.tooltip != null) {
            this.tooltip.hide();
            this.tooltip = null;
        }
    }
}

