/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.desktop.outline;

import java.security.Permission;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.scout.commons.OptimisticLock;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.ConfigPropertyValue;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.dnd.TransferObject;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.holders.Holder;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.tree.AbstractTree;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNodeFilter;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeVisitor;
import org.eclipse.scout.rt.client.ui.basic.tree.TreeAdapter;
import org.eclipse.scout.rt.client.ui.basic.tree.TreeEvent;
import org.eclipse.scout.rt.client.ui.desktop.outline.IOutline;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.AbstractPage;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.AbstractPageWithNodes;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPage;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPageWithNodes;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPageWithTable;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.ISearchForm;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.rt.shared.services.common.security.IAccessControlService;
import org.eclipse.scout.service.SERVICES;

public abstract class AbstractOutline
extends AbstractTree
implements IOutline {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractOutline.class);
    private boolean m_visibleGranted;
    private boolean m_visibleProperty;
    private IPage m_contextPage;
    private OptimisticLock m_contextPageOptimisticLock;

    @ConfigProperty(value="BOOLEAN")
    @Order(value=80.0)
    @ConfigPropertyValue(value="true")
    protected boolean getConfiguredEnabled() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=90.0)
    @ConfigPropertyValue(value="true")
    protected boolean getConfiguredVisible() {
        return true;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=100.0)
    @ConfigPropertyValue(value="0")
    protected int getConfiguredSortNo() {
        return 0;
    }

    @ConfigProperty(value="STRING")
    @Order(value=110.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredDoc() {
        return null;
    }

    @ConfigOperation
    @Order(value=90.0)
    protected void execCreateChildPages(Collection<IPage> pageList) throws ProcessingException {
    }

    @Override
    protected void execDrop(ITreeNode node, TransferObject t) {
        Object table;
        if (node instanceof IPageWithTable && (table = ((IPageWithTable)node).getTable()).getDropType() != 0) {
            table.getUIFacade().fireRowDropActionFromUI(null, t);
        }
    }

    @Override
    protected void initConfig() {
        this.m_visibleGranted = true;
        this.m_contextPageOptimisticLock = new OptimisticLock();
        this.addTreeListener(new P_OutlineListener());
        this.addNodeFilter(new P_TableFilterBasedTreeNodeFilter());
        super.initConfig();
        this.setRootNodeVisible(false);
        InvisibleRootPage rootPage = new InvisibleRootPage();
        this.setRootNode(rootPage);
        this.setEnabled(this.getConfiguredEnabled());
        this.setVisible(this.getConfiguredVisible());
    }

    @Override
    public IPage getActivePage() {
        return (IPage)this.getSelectedNode();
    }

    @Override
    public void refreshPages(final Class ... pageTypes) {
        ITreeVisitor v = new ITreeVisitor(){

            @Override
            public boolean visit(ITreeNode node) {
                IPage page = (IPage)node;
                Class<?> pageClass = page.getClass();
                Class[] classArray = pageTypes;
                int n = pageTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    Class c = classArray[n2];
                    if (c.isAssignableFrom(pageClass) && page instanceof AbstractPage) {
                        ((AbstractPage)page).dataChanged(new Object[0]);
                    }
                    ++n2;
                }
                return true;
            }
        };
        this.visitNode(this.getRootNode(), v);
    }

    @Override
    public void releaseUnusedPages() {
        block8: {
            final HashSet<IPage> preservationSet = new HashSet<IPage>();
            IPage oldSelection = (IPage)this.getSelectedNode();
            IPage p = oldSelection;
            if (p != null) {
                while (p != null) {
                    preservationSet.add(p);
                    p = p.getParentPage();
                }
            }
            ITreeVisitor v = new ITreeVisitor(){

                @Override
                public boolean visit(ITreeNode node) {
                    IPage page = (IPage)node;
                    if (!(preservationSet.contains(page) || !page.isChildrenLoaded() || page.isExpanded() && page.getParentPage() != null && page.getParentPage().isChildrenLoaded())) {
                        try {
                            AbstractOutline.this.unloadNode(page);
                        }
                        catch (ProcessingException e) {
                            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
                        }
                    }
                    return true;
                }
            };
            try {
                IPage selectedPage;
                this.setTreeChanging(true);
                this.visitNode(this.getRootNode(), v);
                if (oldSelection == null || (selectedPage = (IPage)this.getSelectedNode()) != null) break block8;
                try {
                    this.getRootNode().ensureChildrenLoaded();
                    ITreeNode[] children = this.getRootNode().getFilteredChildNodes();
                    if (children.length > 0) {
                        this.selectNode(children[0]);
                    }
                }
                catch (ProcessingException e) {
                    LOG.warn(null, (Throwable)e);
                }
            }
            finally {
                this.setTreeChanging(false);
            }
        }
    }

    @Override
    public <T extends IPage> T findPage(final Class<T> pageType) {
        final Holder result = new Holder(pageType, null);
        ITreeVisitor v = new ITreeVisitor(){

            @Override
            public boolean visit(ITreeNode node) {
                IPage page = (IPage)node;
                Class<?> pageClass = page.getClass();
                if (pageType.isAssignableFrom(pageClass)) {
                    result.setValue((Object)page);
                }
                return result.getValue() == null;
            }
        };
        this.visitNode(this.getRootNode(), v);
        return (T)((IPage)result.getValue());
    }

    @Override
    public void setVisiblePermission(Permission p) {
        boolean b = p != null ? ((IAccessControlService)SERVICES.getService(IAccessControlService.class)).checkPermission(p) : true;
        this.setVisibleGranted(b);
    }

    @Override
    public boolean isVisibleGranted() {
        return this.m_visibleGranted;
    }

    @Override
    public void setVisibleGranted(boolean b) {
        this.m_visibleGranted = b;
        this.calculateVisible();
    }

    @Override
    public boolean isVisible() {
        return this.propertySupport.getPropertyBool("visible");
    }

    @Override
    public void setVisible(boolean b) {
        this.m_visibleProperty = b;
        this.calculateVisible();
    }

    private void calculateVisible() {
        this.propertySupport.setPropertyBool("visible", this.m_visibleGranted && this.m_visibleProperty);
    }

    @Override
    public IForm getDetailForm() {
        return (IForm)this.propertySupport.getProperty("detailForm");
    }

    @Override
    public void setDetailForm(IForm form) {
        this.propertySupport.setProperty("detailForm", (Object)form);
    }

    @Override
    public ITable getDetailTable() {
        return (ITable)this.propertySupport.getProperty("detailTable");
    }

    @Override
    public void setDetailTable(ITable table) {
        this.propertySupport.setProperty("detailTable", (Object)table);
    }

    @Override
    public IForm getSearchForm() {
        return (IForm)this.propertySupport.getProperty("searchForm");
    }

    @Override
    public void setSearchForm(IForm form) {
        this.propertySupport.setProperty("searchForm", (Object)form);
    }

    @Override
    public IPage getRootPage() {
        return (IPage)this.getRootNode();
    }

    @Override
    public void unloadNode(ITreeNode node) throws ProcessingException {
        try {
            this.setTreeChanging(true);
            super.unloadNode(node);
            if (node instanceof IPageWithTable) {
                ((IPageWithTable)node).getTable().deleteAllRows();
            }
        }
        finally {
            this.setTreeChanging(false);
        }
    }

    @Override
    public void resetOutline() throws ProcessingException {
        if (this.getRootNode() != null) {
            ISearchForm searchForm;
            try {
                this.setTreeChanging(true);
                this.selectNode(null);
                this.unloadNode(this.getRootNode());
                this.getRootNode().ensureChildrenLoaded();
            }
            finally {
                this.setTreeChanging(false);
            }
            ITreeNode root = this.getRootNode();
            if (root instanceof IPageWithTable && (searchForm = ((IPageWithTable)root).getSearchFormInternal()) != null) {
                searchForm.doReset();
            }
            if (!this.isRootNodeVisible()) {
                root.setExpanded(true);
            }
            this.selectFirstNode();
            if (this.getSelectedNode() instanceof IPageWithTable) {
                this.getSelectedNode().setExpanded(true);
            }
        }
    }

    @Override
    public void makeActivePageToContextPage() {
        IPage activePage = this.getActivePage();
        if (activePage != null && this.m_contextPage != activePage) {
            this.m_contextPage = activePage;
            if (activePage instanceof AbstractPage) {
                activePage.pageActivatedNotify();
            }
        }
    }

    @Override
    public void clearContextPage() {
        IPage page = this.m_contextPage;
        if (page != null) {
            this.m_contextPage = null;
            if (page instanceof AbstractPage) {
                page.pageDeactivatedNotify();
            }
        }
    }

    private void handleActivePageChanged() {
        block18: {
            try {
                if (!this.m_contextPageOptimisticLock.acquire()) break block18;
                this.clearContextPage();
                IForm detailForm = null;
                ITable detailTable = null;
                ISearchForm searchForm = null;
                this.makeActivePageToContextPage();
                IPage activePage = this.getActivePage();
                if (activePage != null) {
                    try {
                        activePage.ensureChildrenLoaded();
                    }
                    catch (ProcessingException e1) {
                        ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e1);
                    }
                    if (activePage instanceof IPageWithTable) {
                        IPageWithTable tablePage = (IPageWithTable)activePage;
                        detailForm = activePage.getDetailForm();
                        if (activePage.isTableVisible()) {
                            detailTable = (ITable)tablePage.getTable();
                        }
                        if (tablePage.isSearchActive()) {
                            searchForm = tablePage.getSearchFormInternal();
                        }
                    } else if (activePage instanceof IPageWithNodes) {
                        IPageWithNodes nodePage = (IPageWithNodes)activePage;
                        detailForm = activePage.getDetailForm();
                        if (activePage.isTableVisible()) {
                            detailTable = nodePage.getInternalTable();
                        }
                    }
                }
                if (detailForm == null) {
                    this.setDetailForm(null);
                }
                if (detailTable == null) {
                    this.setDetailTable(null);
                }
                if (searchForm == null) {
                    this.setSearchForm(null);
                }
                if (detailForm != null) {
                    this.setDetailForm(detailForm);
                }
                if (detailTable != null) {
                    this.setDetailTable(detailTable);
                }
                if (searchForm != null) {
                    this.setSearchForm(searchForm);
                }
            }
            finally {
                this.m_contextPageOptimisticLock.release();
            }
        }
    }

    private class InvisibleRootPage
    extends AbstractPageWithNodes {
        private InvisibleRootPage() {
        }

        @Override
        protected void execCreateChildPages(Collection<IPage> pageList) throws ProcessingException {
            AbstractOutline.this.execCreateChildPages(pageList);
        }
    }

    private class P_OutlineListener
    extends TreeAdapter {
        private P_OutlineListener() {
        }

        @Override
        public void treeChanged(TreeEvent e) {
            switch (e.getType()) {
                case 40: {
                    AbstractOutline.this.handleActivePageChanged();
                }
            }
        }
    }

    private class P_TableFilterBasedTreeNodeFilter
    implements ITreeNodeFilter {
        private P_TableFilterBasedTreeNodeFilter() {
        }

        @Override
        public boolean accept(ITreeNode node, int level) {
            ITreeNode parentNode = node.getParentNode();
            if (parentNode != null && !parentNode.isFilterAccepted()) {
                return false;
            }
            if (parentNode instanceof IPageWithTable) {
                ITableRow tableRow = ((IPageWithTable)parentNode).getTableRowFor(node);
                return tableRow == null || tableRow.isFilterAccepted();
            }
            if (parentNode instanceof IPageWithNodes) {
                ITreeNode[] iTreeNodeArray = parentNode.getChildNodes();
                int n = iTreeNodeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ITreeNode child = iTreeNodeArray[n2];
                    if (child.equals(node)) {
                        return ((IPageWithNodes)parentNode).isFilterAcceptedForChildNode(node);
                    }
                    ++n2;
                }
            }
            return true;
        }
    }
}

