/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.services.common.icon;

import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.services.common.icon.AbstractIconProviderService;
import org.eclipse.scout.rt.client.services.common.icon.IIconProviderService;
import org.eclipse.scout.rt.client.services.common.icon.IconSpec;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceRegistration;

public class IconProviderService
extends AbstractIconProviderService
implements IIconProviderService {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(IconProviderService.class);
    private Bundle m_hostBundle;

    @Override
    public void initializeService(ServiceRegistration registration) {
        super.initializeService(registration);
        this.setHostBundle(registration.getReference().getBundle());
    }

    @Override
    public Bundle getHostBundle() {
        return this.m_hostBundle;
    }

    public void setHostBundle(Bundle bundle) {
        URL[] iconEntries = FileLocator.findEntries((Bundle)bundle, (IPath)new Path(this.getFolderName()));
        if (iconEntries != null && iconEntries.length > 0) {
            this.m_hostBundle = bundle;
        }
    }

    @Override
    public IconSpec getIconSpec(String iconName) {
        if (this.m_hostBundle == null) {
            return null;
        }
        return super.getIconSpec(iconName);
    }

    @Override
    protected URL findResource(String fullPath) {
        URL[] entries = FileLocator.findEntries((Bundle)this.m_hostBundle, (IPath)new Path(fullPath));
        if (entries != null && entries.length > 0) {
            URL url = entries[entries.length - 1];
            if (LOG.isDebugEnabled()) {
                LOG.debug("find image " + fullPath + " in bundle " + this.m_hostBundle.getSymbolicName() + "->" + url);
            }
            return url;
        }
        return null;
    }
}

