/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.http.servletfilter;

import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.Filter;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.scout.http.servletfilter.internal.FilterChainImpl;
import org.eclipse.scout.http.servletfilter.internal.FilterConfigImpl;
import org.eclipse.scout.http.servletfilter.internal.ServletFilterExtensionPoint;

public final class ServletFilterDelegate {
    public void delegateServiceMethod(ServletRequest req, ServletResponse res, IServiceCallback callback) throws ServletException, IOException {
        String servletPath = ((HttpServletRequest)req).getServletPath();
        if (servletPath == null) {
            servletPath = "/";
        } else if (!servletPath.startsWith("/")) {
            servletPath = "/" + servletPath;
        }
        ArrayList<Filter> filterList = new ArrayList<Filter>();
        ServletContext servletContext = callback.getServletContext();
        for (FilterConfigImpl ref : ServletFilterExtensionPoint.getExtensions()) {
            Filter f;
            if (!ref.isFiltering(servletPath) || (f = ref.getFilter(servletContext)) == null) continue;
            filterList.add(f);
        }
        new FilterChainImpl(filterList, callback).doFilter(req, res);
    }

    public static interface IServiceCallback {
        public void service(ServletRequest var1, ServletResponse var2) throws ServletException, IOException;

        public ServletContext getServletContext();
    }
}

