/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons.beans;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.scout.commons.beans.FastPropertyDescriptor;

public class FastBeanInfo {
    private final Class beanClass;
    private final Map<String, FastPropertyDescriptor> propertyMap;
    private final FastPropertyDescriptor[] propertyArray;
    private static final Pattern BEAN_METHOD_PAT = Pattern.compile("(get|set|is)([A-Z].*)");

    public FastBeanInfo(Class<?> beanClass, Class<?> stopClass) {
        this.beanClass = beanClass;
        this.propertyMap = Collections.unmodifiableMap(FastBeanInfo.createPropertyDescriptorMap(beanClass, stopClass));
        this.propertyArray = this.propertyMap.values().toArray(new FastPropertyDescriptor[this.propertyMap.size()]);
    }

    public Class getBeanClass() {
        return this.beanClass;
    }

    public Map<String, FastPropertyDescriptor> getPropertyDescriptorMap() {
        return this.propertyMap;
    }

    public FastPropertyDescriptor getPropertyDescriptor(String name) {
        FastPropertyDescriptor p = this.propertyMap.get(name);
        if (p == null && name.length() > 0) {
            p = Character.isUpperCase(name.charAt(0)) ? this.propertyMap.get(String.valueOf(Character.toLowerCase(name.charAt(0))) + name.substring(1)) : this.propertyMap.get(String.valueOf(Character.toUpperCase(name.charAt(0))) + name.substring(1));
        }
        return p;
    }

    public FastPropertyDescriptor[] getPropertyDescriptors() {
        return this.propertyArray;
    }

    private static String decapitalize(String s) {
        if (s == null || s.length() == 0) {
            return "";
        }
        if (s.length() >= 2 && Character.isUpperCase(s.charAt(0)) && Character.isUpperCase(s.charAt(1))) {
            return s;
        }
        return String.valueOf(Character.toLowerCase(s.charAt(0))) + s.substring(1);
    }

    private static Map<String, FastPropertyDescriptor> createPropertyDescriptorMap(Class beanClazz, Class stopClazz) {
        HashMap<String, FastPropertyDescriptor> map = new HashMap<String, FastPropertyDescriptor>();
        Class cl = beanClazz;
        while (cl != null && cl != stopClazz) {
            Method[] methods = FastBeanInfo.getDeclaredPublicMethods(cl);
            if (methods != null) {
                Method[] methodArray = methods;
                int n = methods.length;
                int n2 = 0;
                while (n2 < n) {
                    Matcher matcher;
                    Method m = methodArray[n2];
                    if (m != null && (matcher = BEAN_METHOD_PAT.matcher(m.getName())).matches()) {
                        Method w;
                        FastPropertyDescriptor desc;
                        String kind = matcher.group(1);
                        String name = FastBeanInfo.decapitalize(matcher.group(2));
                        Class<?>[] paramTypes = m.getParameterTypes();
                        if (paramTypes == null) {
                            paramTypes = new Class[]{};
                        }
                        Class<?> retType = m.getReturnType();
                        if (kind.equals("get") && paramTypes.length == 0 && retType != null && retType != Void.TYPE) {
                            desc = map.get(name);
                            if (desc == null) {
                                desc = new FastPropertyDescriptor(beanClazz, name);
                                map.put(name, desc);
                            }
                            if (desc.getReadMethod() == null) {
                                desc.setReadMethod(m);
                                desc.setPropertyType(retType);
                                w = desc.getWriteMethod();
                                if (w != null && w.getParameterTypes()[0] != desc.getPropertyType()) {
                                    desc.setWriteMethod(null);
                                }
                            }
                        } else if (kind.equals("is") && paramTypes.length == 0 && retType != null && retType == Boolean.TYPE) {
                            desc = map.get(name);
                            if (desc == null) {
                                desc = new FastPropertyDescriptor(beanClazz, name);
                                map.put(name, desc);
                            }
                            if (desc.getReadMethod() == null) {
                                desc.setReadMethod(m);
                                desc.setPropertyType(retType);
                                w = desc.getWriteMethod();
                                if (w != null && w.getParameterTypes()[0] != desc.getPropertyType()) {
                                    desc.setWriteMethod(null);
                                }
                            }
                        } else if (kind.equals("set") && paramTypes.length == 1 && (retType == null || retType == Void.TYPE)) {
                            desc = map.get(name);
                            if (desc == null) {
                                desc = new FastPropertyDescriptor(beanClazz, name);
                                map.put(name, desc);
                            }
                            if (desc.getWriteMethod() == null) {
                                if (desc.getPropertyType() == null) {
                                    desc.setWriteMethod(m);
                                    desc.setPropertyType(paramTypes[0]);
                                } else if (desc.getPropertyType() == paramTypes[0]) {
                                    desc.setWriteMethod(m);
                                }
                            }
                        }
                    }
                    ++n2;
                }
            }
            cl = cl.getSuperclass();
        }
        return map;
    }

    private static Method[] getDeclaredPublicMethods(Class c) {
        Method[] result = null;
        final Class fc = c;
        result = AccessController.doPrivileged(new PrivilegedAction<Method[]>(){

            @Override
            public Method[] run() {
                return fc.getDeclaredMethods();
            }
        });
        if (result != null) {
            int i = 0;
            while (i < result.length) {
                Method method = result[i];
                int mods = method.getModifiers();
                if (!Modifier.isPublic(mods)) {
                    result[i] = null;
                }
                ++i;
            }
        }
        return result;
    }
}

