/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class TTLCache<K, V> {
    private Map<K, CacheEntryTTL> m_itemMap;
    private long m_ttl;
    private final Object m_itemMapLock = new Object();

    public TTLCache() {
        this(60000L);
    }

    public TTLCache(long timeToLive) {
        this.m_ttl = timeToLive;
        this.m_itemMap = new HashMap<K, CacheEntryTTL>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.m_itemMapLock;
        synchronized (object) {
            this.m_itemMap.clear();
        }
    }

    public void setTTL(long millis) {
        this.m_ttl = millis;
    }

    public long getTTL() {
        return this.m_ttl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(K key, V value) {
        if (this.m_ttl > 0L) {
            Object object = this.m_itemMapLock;
            synchronized (object) {
                this.m_itemMap.put(key, new CacheEntryTTL(value));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(K key) {
        Object object = this.m_itemMapLock;
        synchronized (object) {
            this.m_itemMap.remove(key);
        }
    }

    public V get(K key) {
        CacheEntryTTL ce = this.getEntry(key);
        if (ce != null) {
            return ce.getValue();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<K> keySet() {
        HashSet<K> list = new HashSet<K>();
        Object object = this.m_itemMapLock;
        synchronized (object) {
            Iterator<K> it = this.m_itemMap.keySet().iterator();
            while (it.hasNext()) {
                K key = it.next();
                if (!this.isCacheTimeoutReached(this.m_itemMap.get(key))) {
                    list.add(key);
                    continue;
                }
                it.remove();
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.m_itemMapLock;
        synchronized (object) {
            return this.m_itemMap.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<V> values() {
        ArrayList list = new ArrayList();
        Object object = this.m_itemMapLock;
        synchronized (object) {
            Iterator<CacheEntryTTL> it = this.m_itemMap.values().iterator();
            while (it.hasNext()) {
                CacheEntryTTL cacheEntry = it.next();
                if (!this.isCacheTimeoutReached(cacheEntry)) {
                    list.add(cacheEntry.getValue());
                    continue;
                }
                it.remove();
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<K, V> getEntries() {
        HashMap map = new HashMap();
        Object object = this.m_itemMapLock;
        synchronized (object) {
            Iterator<Map.Entry<K, CacheEntryTTL>> it = this.m_itemMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<K, CacheEntryTTL> e = it.next();
                if (!this.isCacheTimeoutReached(e.getValue())) {
                    map.put(e.getKey(), e.getValue().getValue());
                    continue;
                }
                it.remove();
            }
        }
        return map;
    }

    public boolean containsKey(K key) {
        CacheEntryTTL ce;
        return this.m_ttl > 0L && (ce = this.getEntry(key)) != null;
    }

    public boolean contains(K key, V value) {
        Object ceVal;
        CacheEntryTTL ce;
        return this.m_ttl > 0L && (ce = this.getEntry(key)) != null && ((ceVal = ce.getValue()) == value || ceVal != null && ceVal.equals(value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CacheEntryTTL getEntry(K key) {
        if (this.m_ttl > 0L) {
            Object object = this.m_itemMapLock;
            synchronized (object) {
                CacheEntryTTL ce = this.m_itemMap.get(key);
                if (ce != null) {
                    if (!this.isCacheTimeoutReached(ce)) {
                        return ce;
                    }
                    this.m_itemMap.remove(key);
                }
            }
        }
        return null;
    }

    private boolean isCacheTimeoutReached(CacheEntryTTL value) {
        return value.getTimestamp() + this.m_ttl <= System.currentTimeMillis();
    }

    private class CacheEntryTTL {
        private long m_time = System.currentTimeMillis();
        private V m_value;

        public CacheEntryTTL(V value) {
            this.m_value = value;
        }

        public long getTimestamp() {
            return this.m_time;
        }

        public V getValue() {
            return this.m_value;
        }
    }
}

