/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import org.eclipse.scout.commons.exception.ProcessingException;

public class CompressedObjectWriter {
    private ObjectOutputStream out;
    private DeflaterOutputStream zipOut;
    private ByteArrayOutputStream bytesOut;

    public CompressedObjectWriter(int outputBufferSize, int zipBufferSize) throws ProcessingException {
        try {
            Deflater d = new Deflater();
            d.setLevel(9);
            this.bytesOut = new ByteArrayOutputStream(outputBufferSize);
            this.zipOut = new DeflaterOutputStream((OutputStream)this.bytesOut, d, zipBufferSize);
            this.out = new ObjectOutputStream(this.zipOut);
        }
        catch (IOException e) {
            throw new ProcessingException(e.getMessage(), e);
        }
    }

    public void compress(Object o) throws ProcessingException {
        try {
            this.out.writeObject(o);
        }
        catch (IOException e) {
            throw new ProcessingException(e.getMessage(), e);
        }
    }

    public byte[] getCompressedBytes() throws ProcessingException {
        try {
            this.out.flush();
            this.zipOut.finish();
            this.zipOut.flush();
            return this.bytesOut.toByteArray();
        }
        catch (IOException e) {
            throw new ProcessingException(e.getMessage(), e);
        }
    }

    public void close() {
        try {
            this.out.close();
        }
        catch (IOException iOException) {}
        try {
            this.zipOut.close();
        }
        catch (IOException iOException) {}
    }

    public void resetWrittenObjectCache() throws ProcessingException {
        try {
            this.out.reset();
        }
        catch (IOException e) {
            throw new ProcessingException(e.getMessage(), e);
        }
    }
}

