/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.visualization.jit;

import org.eclipse.rap.rwt.visualization.jit.JITVisualizationWidget;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;

public abstract class JITGraphWidget
extends JITVisualizationWidget {
    protected RGB nodeColor;
    protected RGB edgeColor;

    public JITGraphWidget(Composite parent, int style) {
        super(parent, style);
    }

    public void setNodeColor(RGB nodeColor) {
        this.nodeColor = nodeColor;
        this.setNodeProperty("color", this.convertRGBToCSSString(this.getNodeColor()));
    }

    public void setEdgeColor(RGB edgeColor) {
        this.edgeColor = edgeColor;
        this.setEdgeProperty("color", this.convertRGBToCSSString(this.getEdgeColor()));
    }

    public RGB getNodeColor() {
        return this.nodeColor;
    }

    public RGB getEdgeColor() {
        return this.edgeColor;
    }

    public void setProperty(String propName, Object propValue) {
        this.addCommand("setProperty", new Object[]{propName, propValue});
    }

    public void setNodeProperty(String propName, Object propValue) {
        this.addCommand("setNodeProperty", new Object[]{propName, propValue});
    }

    public void setEdgeProperty(String propName, Object propValue) {
        this.addCommand("setEdgeProperty", new Object[]{propName, propValue});
    }

    public void setZoom(double percent) {
        this.addCommand("setZoom", new Object[]{percent});
    }

    protected String convertRGBToCSSString(RGB color) {
        if (color == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer("rgb(");
        sb.append(color.red).append(",").append(color.green).append(",").append(color.blue).append(")").toString();
        return sb.toString();
    }
}

