/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.visualization.google;

import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public abstract class VisualizationWidget
extends Composite {
    public static final String CORE_CHART_API = "corechart";
    private String widgetData = "";
    String widgetOptions = "";
    String widgetSize = "";
    private String selectedItem = "";
    private String selectedRow = "";
    private String selectedColumn = "";
    private String selectedValue = "";
    private boolean dirty;

    protected VisualizationWidget(Composite parent, int style) {
        super(parent, style);
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Point psz = VisualizationWidget.this.getSize();
                if (VisualizationWidget.this.widgetOptions.matches(".*width:.*") && VisualizationWidget.this.widgetOptions.matches(".*height:.*")) {
                    VisualizationWidget.this.widgetSize = "";
                } else {
                    VisualizationWidget.this.widgetSize = "width: " + psz.x + ", height: " + psz.y;
                    if (VisualizationWidget.this.widgetOptions.length() != 0) {
                        VisualizationWidget.this.widgetSize = ", " + VisualizationWidget.this.widgetSize;
                    }
                }
                VisualizationWidget.this.redraw();
            }
        });
    }

    public String getGoogleAPI() {
        return CORE_CHART_API;
    }

    public String getWidgetData() {
        return this.widgetData;
    }

    public void setLayout(Layout layout) {
    }

    public void setWidgetData(String widgetData) {
        this.widgetData = widgetData == null ? "" : widgetData;
    }

    public void setWidgetOptions(String widgetOptions) {
        if (widgetOptions == null) {
            widgetOptions = "";
        } else {
            this.widgetOptions = widgetOptions;
        }
    }

    public String getWidgetOptions() {
        return String.valueOf(this.widgetOptions) + this.widgetSize;
    }

    public void redraw() {
        super.redraw();
        this.dirty = true;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setSelectedItem(String selectedItem) {
        this.selectedItem = selectedItem;
    }

    public String getSelectedItem() {
        return this.selectedItem;
    }

    public void setSelectedRow(String selectedRow) {
        this.selectedRow = selectedRow;
    }

    public String getSelectedRow() {
        return this.selectedRow;
    }

    public void setSelectedColumn(String selectedColumn) {
        this.selectedColumn = selectedColumn;
    }

    public String getSelectedColumn() {
        return this.selectedColumn;
    }

    public void setSelectedValue(String selectedValue) {
        this.selectedValue = selectedValue;
    }

    public String getSelectedValue() {
        return this.selectedValue;
    }
}

