/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.events;

import org.eclipse.rap.json.JsonValue;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetUtil;
import org.eclipse.rap.rwt.internal.protocol.ProtocolUtil;
import org.eclipse.rap.rwt.scripting.ClientListener;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public final class EventLCAUtil {
    public static int readStateMask(Widget widget, String eventName) {
        JsonValue altKey = ProtocolUtil.readEventPropertyValue(WidgetUtil.getId(widget), eventName, "altKey");
        JsonValue ctrlKey = ProtocolUtil.readEventPropertyValue(WidgetUtil.getId(widget), eventName, "ctrlKey");
        JsonValue shiftKey = ProtocolUtil.readEventPropertyValue(WidgetUtil.getId(widget), eventName, "shiftKey");
        return EventLCAUtil.translateModifier(JsonValue.TRUE.equals(altKey), JsonValue.TRUE.equals(ctrlKey), JsonValue.TRUE.equals(shiftKey));
    }

    static int translateModifier(boolean hasAltKey, boolean hasCtrlKey, boolean hasShiftKey) {
        int result = 0;
        if (hasCtrlKey) {
            result |= 0x40000;
        }
        if (hasAltKey) {
            result |= 0x10000;
        }
        if (hasShiftKey) {
            result |= 0x20000;
        }
        return result;
    }

    public static int translateButton(int value) {
        int result = 0;
        switch (value) {
            case 1: {
                result = 524288;
                break;
            }
            case 2: {
                result = 0x100000;
                break;
            }
            case 3: {
                result = 0x200000;
                break;
            }
            case 4: {
                result = 0x800000;
                break;
            }
            case 5: {
                result = 0x2000000;
            }
        }
        return result;
    }

    public static boolean isListening(Widget widget, int eventType) {
        Listener[] listenerArray = widget.getListeners(eventType);
        int n = listenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Listener listener = listenerArray[n2];
            if (!(listener instanceof ClientListener)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private EventLCAUtil() {
    }
}

