/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.realm;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.catalina.realm.JAASRealm;
import org.apache.tomcat.util.res.StringManager;

public class JAASCallbackHandler
implements CallbackHandler {
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.realm");
    protected String password = null;
    protected JAASRealm realm = null;
    protected String username = null;
    protected String nonce = null;
    protected String nc = null;
    protected String cnonce = null;
    protected String qop;
    protected String realmName;
    protected String md5a2;
    protected String authMethod;

    public JAASCallbackHandler(JAASRealm realm, String username, String password) {
        this.realm = realm;
        this.username = username;
        this.password = realm.hasMessageDigest() ? realm.digest(password) : password;
    }

    public JAASCallbackHandler(JAASRealm realm, String username, String password, String nonce, String nc, String cnonce, String qop, String realmName, String md5a2, String authMethod) {
        this(realm, username, password);
        this.nonce = nonce;
        this.nc = nc;
        this.cnonce = cnonce;
        this.qop = qop;
        this.realmName = realmName;
        this.md5a2 = md5a2;
        this.authMethod = authMethod;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        int i = 0;
        while (i < callbacks.length) {
            if (callbacks[i] instanceof NameCallback) {
                if (this.realm.getContainer().getLogger().isTraceEnabled()) {
                    this.realm.getContainer().getLogger().trace(sm.getString("jaasCallback.username", this.username));
                }
                ((NameCallback)callbacks[i]).setName(this.username);
            } else if (callbacks[i] instanceof PasswordCallback) {
                char[] passwordcontents = this.password != null ? this.password.toCharArray() : new char[]{};
                ((PasswordCallback)callbacks[i]).setPassword(passwordcontents);
            } else {
                if (!(callbacks[i] instanceof TextInputCallback)) throw new UnsupportedCallbackException(callbacks[i]);
                TextInputCallback cb = (TextInputCallback)callbacks[i];
                if (cb.getPrompt().equals("nonce")) {
                    cb.setText(this.nonce);
                } else if (cb.getPrompt().equals("nc")) {
                    cb.setText(this.nc);
                } else if (cb.getPrompt().equals("cnonce")) {
                    cb.setText(this.cnonce);
                } else if (cb.getPrompt().equals("qop")) {
                    cb.setText(this.qop);
                } else if (cb.getPrompt().equals("realmName")) {
                    cb.setText(this.realmName);
                } else if (cb.getPrompt().equals("md5a2")) {
                    cb.setText(this.md5a2);
                } else {
                    if (!cb.getPrompt().equals("authMethod")) throw new UnsupportedCallbackException(callbacks[i]);
                    cb.setText(this.authMethod);
                }
            }
            ++i;
        }
    }
}

