/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.loader;

import java.beans.Introspector;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.naming.Binding;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import org.apache.catalina.Globals;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.loader.ResourceEntry;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.naming.JndiPermission;
import org.apache.naming.resources.ProxyDirContext;
import org.apache.naming.resources.ResourceAttributes;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.res.StringManager;

public class WebappClassLoader
extends URLClassLoader
implements Lifecycle {
    private static final Log log = LogFactory.getLog(WebappClassLoader.class);
    private static final List<String> JVM_THREAD_GROUP_NAMES = new ArrayList<String>();
    private static final String JVN_THREAD_GROUP_SYSTEM = "system";
    protected static final String[] triggers;
    protected static final String[] packageTriggers;
    protected static final StringManager sm;
    boolean antiJARLocking = false;
    protected DirContext resources = null;
    protected HashMap<String, ResourceEntry> resourceEntries = new HashMap();
    protected HashMap<String, String> notFoundResources = new LinkedHashMap<String, String>(){
        private static final long serialVersionUID = 1L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, String> eldest) {
            return this.size() > 1000;
        }
    };
    protected boolean delegate = false;
    protected long lastJarAccessed = 0L;
    protected String[] repositories = new String[0];
    protected URL[] repositoryURLs = null;
    protected File[] files = new File[0];
    protected JarFile[] jarFiles = new JarFile[0];
    protected File[] jarRealFiles = new File[0];
    protected String jarPath = null;
    protected String[] jarNames = new String[0];
    protected long[] lastModifiedDates = new long[0];
    protected String[] paths = new String[0];
    protected ArrayList<Permission> permissionList = new ArrayList();
    protected File loaderDir = null;
    protected String canonicalLoaderDir = null;
    protected HashMap<String, PermissionCollection> loaderPC = new HashMap();
    protected SecurityManager securityManager = null;
    protected ClassLoader parent = null;
    protected ClassLoader system = null;
    protected boolean started = false;
    protected boolean hasExternalRepositories = false;
    protected boolean searchExternalFirst = false;
    protected boolean needConvert = false;
    protected Permission allPermission = new AllPermission();
    private boolean clearReferencesStatic = false;
    private boolean clearReferencesStopThreads = false;
    private boolean clearReferencesStopTimerThreads = false;
    private boolean clearReferencesLogFactoryRelease = true;
    private boolean clearReferencesHttpClientKeepAliveThread = true;
    private String contextName = "unknown";

    static {
        JVM_THREAD_GROUP_NAMES.add(JVN_THREAD_GROUP_SYSTEM);
        JVM_THREAD_GROUP_NAMES.add("RMI Runtime");
        triggers = new String[]{"javax.servlet.Servlet"};
        packageTriggers = new String[0];
        sm = StringManager.getManager("org.apache.catalina.loader");
    }

    public WebappClassLoader() {
        super(new URL[0]);
        this.parent = this.getParent();
        this.system = WebappClassLoader.getSystemClassLoader();
        this.securityManager = System.getSecurityManager();
        if (this.securityManager != null) {
            this.refreshPolicy();
        }
    }

    public WebappClassLoader(ClassLoader parent) {
        super(new URL[0], parent);
        this.parent = this.getParent();
        this.system = WebappClassLoader.getSystemClassLoader();
        this.securityManager = System.getSecurityManager();
        if (this.securityManager != null) {
            this.refreshPolicy();
        }
    }

    public DirContext getResources() {
        return this.resources;
    }

    public void setResources(DirContext resources) {
        this.resources = resources;
        if (resources instanceof ProxyDirContext) {
            this.contextName = ((ProxyDirContext)resources).getContextName();
        }
    }

    public String getContextName() {
        return this.contextName;
    }

    public boolean getDelegate() {
        return this.delegate;
    }

    public void setDelegate(boolean delegate) {
        this.delegate = delegate;
    }

    public boolean getAntiJARLocking() {
        return this.antiJARLocking;
    }

    public void setAntiJARLocking(boolean antiJARLocking) {
        this.antiJARLocking = antiJARLocking;
    }

    public boolean getSearchExternalFirst() {
        return this.searchExternalFirst;
    }

    public void setSearchExternalFirst(boolean searchExternalFirst) {
        this.searchExternalFirst = searchExternalFirst;
    }

    public void addPermission(String filepath) {
        if (filepath == null) {
            return;
        }
        String path = filepath;
        if (this.securityManager != null) {
            Permission permission = null;
            if (path.startsWith("jndi:") || path.startsWith("jar:jndi:")) {
                if (!path.endsWith("/")) {
                    path = String.valueOf(path) + "/";
                }
                permission = new JndiPermission(String.valueOf(path) + "*");
                this.addPermission(permission);
            } else {
                if (!path.endsWith(File.separator)) {
                    permission = new FilePermission(path, "read");
                    this.addPermission(permission);
                    path = String.valueOf(path) + File.separator;
                }
                permission = new FilePermission(String.valueOf(path) + "-", "read");
                this.addPermission(permission);
            }
        }
    }

    public void addPermission(URL url) {
        if (url != null) {
            this.addPermission(url.toString());
        }
    }

    public void addPermission(Permission permission) {
        if (this.securityManager != null && permission != null) {
            this.permissionList.add(permission);
        }
    }

    public String getJarPath() {
        return this.jarPath;
    }

    public void setJarPath(String jarPath) {
        this.jarPath = jarPath;
    }

    public void setWorkDir(File workDir) {
        this.loaderDir = new File(workDir, "loader");
        if (this.loaderDir == null) {
            this.canonicalLoaderDir = null;
        } else {
            try {
                this.canonicalLoaderDir = this.loaderDir.getCanonicalPath();
                if (!this.canonicalLoaderDir.endsWith(File.separator)) {
                    this.canonicalLoaderDir = String.valueOf(this.canonicalLoaderDir) + File.separator;
                }
            }
            catch (IOException iOException) {
                this.canonicalLoaderDir = null;
            }
        }
    }

    protected void setParentClassLoader(ClassLoader pcl) {
        this.parent = pcl;
    }

    public boolean getClearReferencesStatic() {
        return this.clearReferencesStatic;
    }

    public void setClearReferencesStatic(boolean clearReferencesStatic) {
        this.clearReferencesStatic = clearReferencesStatic;
    }

    public boolean getClearReferencesStopThreads() {
        return this.clearReferencesStopThreads;
    }

    public void setClearReferencesStopThreads(boolean clearReferencesStopThreads) {
        this.clearReferencesStopThreads = clearReferencesStopThreads;
    }

    public boolean getClearReferencesStopTimerThreads() {
        return this.clearReferencesStopTimerThreads;
    }

    public void setClearReferencesStopTimerThreads(boolean clearReferencesStopTimerThreads) {
        this.clearReferencesStopTimerThreads = clearReferencesStopTimerThreads;
    }

    public boolean getClearReferencesLogFactoryRelease() {
        return this.clearReferencesLogFactoryRelease;
    }

    public void setClearReferencesLogFactoryRelease(boolean clearReferencesLogFactoryRelease) {
        this.clearReferencesLogFactoryRelease = clearReferencesLogFactoryRelease;
    }

    public boolean getClearReferencesHttpClientKeepAliveThread() {
        return this.clearReferencesHttpClientKeepAliveThread;
    }

    public void setClearReferencesHttpClientKeepAliveThread(boolean clearReferencesHttpClientKeepAliveThread) {
        this.clearReferencesHttpClientKeepAliveThread = clearReferencesHttpClientKeepAliveThread;
    }

    public void addRepository(String repository) {
        if (repository.startsWith("/WEB-INF/lib") || repository.startsWith("/WEB-INF/classes")) {
            return;
        }
        try {
            URL url = new URL(repository);
            super.addURL(url);
            this.hasExternalRepositories = true;
            this.repositoryURLs = null;
        }
        catch (MalformedURLException e) {
            IllegalArgumentException iae = new IllegalArgumentException("Invalid repository: " + repository);
            iae.initCause(e);
            throw iae;
        }
    }

    synchronized void addRepository(String repository, File file) {
        if (repository == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("addRepository(" + repository + ")");
        }
        String[] result = new String[this.repositories.length + 1];
        int i = 0;
        while (i < this.repositories.length) {
            result[i] = this.repositories[i];
            ++i;
        }
        result[this.repositories.length] = repository;
        this.repositories = result;
        File[] result2 = new File[this.files.length + 1];
        i = 0;
        while (i < this.files.length) {
            result2[i] = this.files[i];
            ++i;
        }
        result2[this.files.length] = file;
        this.files = result2;
    }

    synchronized void addJar(String jar, JarFile jarFile, File file) throws IOException {
        int i;
        if (jar == null) {
            return;
        }
        if (jarFile == null) {
            return;
        }
        if (file == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("addJar(" + jar + ")");
        }
        if (this.jarPath != null && jar.startsWith(this.jarPath)) {
            String jarName = jar.substring(this.jarPath.length());
            while (jarName.startsWith("/")) {
                jarName = jarName.substring(1);
            }
            String[] result = new String[this.jarNames.length + 1];
            i = 0;
            while (i < this.jarNames.length) {
                result[i] = this.jarNames[i];
                ++i;
            }
            result[this.jarNames.length] = jarName;
            this.jarNames = result;
        }
        try {
            long lastModified = ((ResourceAttributes)this.resources.getAttributes(jar)).getLastModified();
            String[] result = new String[this.paths.length + 1];
            i = 0;
            while (i < this.paths.length) {
                result[i] = this.paths[i];
                ++i;
            }
            result[this.paths.length] = jar;
            this.paths = result;
            long[] result3 = new long[this.lastModifiedDates.length + 1];
            i = 0;
            while (i < this.lastModifiedDates.length) {
                result3[i] = this.lastModifiedDates[i];
                ++i;
            }
            result3[this.lastModifiedDates.length] = lastModified;
            this.lastModifiedDates = result3;
        }
        catch (NamingException namingException) {}
        if (!this.validateJarFile(file)) {
            return;
        }
        JarFile[] result2 = new JarFile[this.jarFiles.length + 1];
        i = 0;
        while (i < this.jarFiles.length) {
            result2[i] = this.jarFiles[i];
            ++i;
        }
        result2[this.jarFiles.length] = jarFile;
        this.jarFiles = result2;
        File[] result4 = new File[this.jarRealFiles.length + 1];
        i = 0;
        while (i < this.jarRealFiles.length) {
            result4[i] = this.jarRealFiles[i];
            ++i;
        }
        result4[this.jarRealFiles.length] = file;
        this.jarRealFiles = result4;
    }

    public String[] findRepositories() {
        return (String[])this.repositories.clone();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean modified() {
        int length2;
        int length;
        if (log.isDebugEnabled()) {
            log.debug("modified()");
        }
        if ((length = this.paths.length) > (length2 = this.lastModifiedDates.length)) {
            length = length2;
        }
        int i = 0;
        while (i < length) {
            try {
                long lastModified = ((ResourceAttributes)this.resources.getAttributes(this.paths[i])).getLastModified();
                if (lastModified != this.lastModifiedDates[i]) {
                    if (log.isDebugEnabled()) {
                        log.debug("  Resource '" + this.paths[i] + "' was modified; Date is now: " + new Date(lastModified) + " Was: " + new Date(this.lastModifiedDates[i]));
                    }
                    return true;
                }
            }
            catch (NamingException namingException) {
                log.error("    Resource '" + this.paths[i] + "' is missing");
                return true;
            }
            ++i;
        }
        length = this.jarNames.length;
        if (this.getJarPath() != null) {
            try {
                String name;
                NameClassPair ncPair;
                NamingEnumeration<Binding> enumeration = this.resources.listBindings(this.getJarPath());
                int i2 = 0;
                while (enumeration.hasMoreElements() && i2 < length) {
                    ncPair = (NameClassPair)enumeration.nextElement();
                    name = ncPair.getName();
                    if (!name.endsWith(".jar")) continue;
                    if (!name.equals(this.jarNames[i2])) {
                        log.info("    Additional JARs have been added : '" + name + "'");
                        return true;
                    }
                    ++i2;
                }
                if (enumeration.hasMoreElements()) {
                    while (enumeration.hasMoreElements()) {
                        ncPair = (NameClassPair)enumeration.nextElement();
                        name = ncPair.getName();
                        if (!name.endsWith(".jar")) continue;
                        log.info("    Additional JARs have been added");
                        return true;
                    }
                } else if (i2 < this.jarNames.length) {
                    log.info("    Additional JARs have been added");
                    return true;
                }
            }
            catch (NamingException namingException) {
                if (log.isDebugEnabled()) {
                    log.debug("    Failed tracking modifications of '" + this.getJarPath() + "'");
                }
            }
            catch (ClassCastException e) {
                log.error("    Failed tracking modifications of '" + this.getJarPath() + "' : " + e.getMessage());
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("WebappClassLoader\r\n");
        sb.append("  context: ");
        sb.append(this.contextName);
        sb.append("\r\n");
        sb.append("  delegate: ");
        sb.append(this.delegate);
        sb.append("\r\n");
        sb.append("  repositories:\r\n");
        if (this.repositories != null) {
            int i = 0;
            while (i < this.repositories.length) {
                sb.append("    ");
                sb.append(this.repositories[i]);
                sb.append("\r\n");
                ++i;
            }
        }
        if (this.parent != null) {
            sb.append("----------> Parent Classloader:\r\n");
            sb.append(this.parent.toString());
            sb.append("\r\n");
        }
        return sb.toString();
    }

    @Override
    protected void addURL(URL url) {
        super.addURL(url);
        this.hasExternalRepositories = true;
        this.repositoryURLs = null;
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        int i;
        if (log.isDebugEnabled()) {
            log.debug("    findClass(" + name + ")");
        }
        if (!this.started) {
            throw new ClassNotFoundException(name);
        }
        if (this.securityManager != null && (i = name.lastIndexOf(46)) >= 0) {
            try {
                if (log.isTraceEnabled()) {
                    log.trace("      securityManager.checkPackageDefinition");
                }
                this.securityManager.checkPackageDefinition(name.substring(0, i));
            }
            catch (Exception se) {
                if (log.isTraceEnabled()) {
                    log.trace("      -->Exception-->ClassNotFoundException", se);
                }
                throw new ClassNotFoundException(name, se);
            }
        }
        Class<?> clazz = null;
        try {
            if (log.isTraceEnabled()) {
                log.trace("      findClassInternal(" + name + ")");
            }
            if (this.hasExternalRepositories && this.searchExternalFirst) {
                try {
                    clazz = super.findClass(name);
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (AccessControlException ace) {
                    log.warn("WebappClassLoader.findClassInternal(" + name + ") security exception: " + ace.getMessage(), ace);
                    throw new ClassNotFoundException(name, ace);
                }
                catch (RuntimeException e) {
                    if (log.isTraceEnabled()) {
                        log.trace("      -->RuntimeException Rethrown", e);
                    }
                    throw e;
                }
            }
            if (clazz == null) {
                try {
                    clazz = this.findClassInternal(name);
                }
                catch (ClassNotFoundException cnfe) {
                    if (!this.hasExternalRepositories || this.searchExternalFirst) {
                        throw cnfe;
                    }
                }
                catch (AccessControlException ace) {
                    log.warn("WebappClassLoader.findClassInternal(" + name + ") security exception: " + ace.getMessage(), ace);
                    throw new ClassNotFoundException(name, ace);
                }
                catch (RuntimeException e) {
                    if (log.isTraceEnabled()) {
                        log.trace("      -->RuntimeException Rethrown", e);
                    }
                    throw e;
                }
            }
            if (clazz == null && this.hasExternalRepositories && !this.searchExternalFirst) {
                try {
                    clazz = super.findClass(name);
                }
                catch (AccessControlException ace) {
                    log.warn("WebappClassLoader.findClassInternal(" + name + ") security exception: " + ace.getMessage(), ace);
                    throw new ClassNotFoundException(name, ace);
                }
                catch (RuntimeException e) {
                    if (log.isTraceEnabled()) {
                        log.trace("      -->RuntimeException Rethrown", e);
                    }
                    throw e;
                }
            }
            if (clazz == null) {
                if (log.isDebugEnabled()) {
                    log.debug("    --> Returning ClassNotFoundException");
                }
                throw new ClassNotFoundException(name);
            }
        }
        catch (ClassNotFoundException e) {
            if (log.isTraceEnabled()) {
                log.trace("    --> Passing on ClassNotFoundException");
            }
            throw e;
        }
        if (log.isTraceEnabled()) {
            log.debug("      Returning class " + clazz);
        }
        if (log.isTraceEnabled()) {
            ClassLoader cl = Globals.IS_SECURITY_ENABLED ? AccessController.doPrivileged(new PrivilegedGetClassLoader(clazz)) : clazz.getClassLoader();
            log.debug("      Loaded by " + cl.toString());
        }
        return clazz;
    }

    @Override
    public URL findResource(String name) {
        if (log.isDebugEnabled()) {
            log.debug("    findResource(" + name + ")");
        }
        URL url = null;
        if (this.hasExternalRepositories && this.searchExternalFirst) {
            url = super.findResource(name);
        }
        if (url == null) {
            ResourceEntry entry = this.resourceEntries.get(name);
            if (entry == null) {
                if (this.securityManager != null) {
                    PrivilegedFindResourceByName dp = new PrivilegedFindResourceByName(name, name);
                    entry = AccessController.doPrivileged(dp);
                } else {
                    entry = this.findResourceInternal(name, name);
                }
            }
            if (entry != null) {
                url = entry.source;
            }
        }
        if (url == null && this.hasExternalRepositories && !this.searchExternalFirst) {
            url = super.findResource(name);
        }
        if (log.isDebugEnabled()) {
            if (url != null) {
                log.debug("    --> Returning '" + url.toString() + "'");
            } else {
                log.debug("    --> Resource not found, returning null");
            }
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        Object fullPath;
        Enumeration<URL> otherResourcePaths;
        if (log.isDebugEnabled()) {
            log.debug("    findResources(" + name + ")");
        }
        Vector<URL> result = new Vector<URL>();
        int jarFilesLength = this.jarFiles.length;
        int repositoriesLength = this.repositories.length;
        if (this.hasExternalRepositories && this.searchExternalFirst) {
            otherResourcePaths = super.findResources(name);
            while (otherResourcePaths.hasMoreElements()) {
                result.addElement(otherResourcePaths.nextElement());
            }
        }
        int i = 0;
        while (i < repositoriesLength) {
            try {
                fullPath = String.valueOf(this.repositories[i]) + name;
                this.resources.lookup((String)fullPath);
                try {
                    result.addElement(this.getURI(new File(this.files[i], name)));
                }
                catch (MalformedURLException malformedURLException) {}
            }
            catch (NamingException namingException) {}
            ++i;
        }
        fullPath = this.jarFiles;
        synchronized (this.jarFiles) {
            if (this.openJARs()) {
                i = 0;
                while (i < jarFilesLength) {
                    JarEntry jarEntry = this.jarFiles[i].getJarEntry(name);
                    if (jarEntry != null) {
                        try {
                            String jarFakeUrl = this.getURI(this.jarRealFiles[i]).toString();
                            jarFakeUrl = "jar:" + jarFakeUrl + "!/" + name;
                            result.addElement(new URL(jarFakeUrl));
                        }
                        catch (MalformedURLException malformedURLException) {}
                    }
                    ++i;
                }
            }
            // ** MonitorExit[fullPath /* !! */ ] (shouldn't be in output)
            if (this.hasExternalRepositories && !this.searchExternalFirst) {
                otherResourcePaths = super.findResources(name);
                while (otherResourcePaths.hasMoreElements()) {
                    result.addElement(otherResourcePaths.nextElement());
                }
            }
            return result.elements();
        }
    }

    @Override
    public URL getResource(String name) {
        ClassLoader loader;
        if (log.isDebugEnabled()) {
            log.debug("getResource(" + name + ")");
        }
        URL url = null;
        if (this.delegate) {
            if (log.isDebugEnabled()) {
                log.debug("  Delegating to parent classloader " + this.parent);
            }
            if ((loader = this.parent) == null) {
                loader = this.system;
            }
            if ((url = loader.getResource(name)) != null) {
                if (log.isDebugEnabled()) {
                    log.debug("  --> Returning '" + url.toString() + "'");
                }
                return url;
            }
        }
        if ((url = this.findResource(name)) != null) {
            if (this.antiJARLocking) {
                ResourceEntry entry = this.resourceEntries.get(name);
                try {
                    String repository = entry.codeBase.toString();
                    if (repository.endsWith(".jar") && !name.endsWith(".class")) {
                        File resourceFile = new File(this.loaderDir, name);
                        url = this.getURI(resourceFile);
                    }
                }
                catch (Exception exception) {}
            }
            if (log.isDebugEnabled()) {
                log.debug("  --> Returning '" + url.toString() + "'");
            }
            return url;
        }
        if (!this.delegate) {
            loader = this.parent;
            if (loader == null) {
                loader = this.system;
            }
            if ((url = loader.getResource(name)) != null) {
                if (log.isDebugEnabled()) {
                    log.debug("  --> Returning '" + url.toString() + "'");
                }
                return url;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("  --> Resource not found, returning null");
        }
        return null;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        URL url;
        if (log.isDebugEnabled()) {
            log.debug("getResourceAsStream(" + name + ")");
        }
        InputStream stream = null;
        stream = this.findLoadedResource(name);
        if (stream != null) {
            if (log.isDebugEnabled()) {
                log.debug("  --> Returning stream from cache");
            }
            return stream;
        }
        if (this.delegate) {
            ClassLoader loader;
            if (log.isDebugEnabled()) {
                log.debug("  Delegating to parent classloader " + this.parent);
            }
            if ((loader = this.parent) == null) {
                loader = this.system;
            }
            if ((stream = loader.getResourceAsStream(name)) != null) {
                if (log.isDebugEnabled()) {
                    log.debug("  --> Returning stream from parent");
                }
                return stream;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("  Searching local repositories");
        }
        if ((url = this.findResource(name)) != null) {
            if (log.isDebugEnabled()) {
                log.debug("  --> Returning stream from local");
            }
            stream = this.findLoadedResource(name);
            try {
                if (this.hasExternalRepositories && stream == null) {
                    stream = url.openStream();
                }
            }
            catch (IOException iOException) {}
            if (stream != null) {
                return stream;
            }
        }
        if (!this.delegate) {
            ClassLoader loader;
            if (log.isDebugEnabled()) {
                log.debug("  Delegating to parent classloader unconditionally " + this.parent);
            }
            if ((loader = this.parent) == null) {
                loader = this.system;
            }
            if ((stream = loader.getResourceAsStream(name)) != null) {
                if (log.isDebugEnabled()) {
                    log.debug("  --> Returning stream from parent");
                }
                return stream;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("  --> Resource not found, returning null");
        }
        return null;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    @Override
    public synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        ClassLoader loader;
        boolean delegateLoad;
        int i;
        if (log.isDebugEnabled()) {
            log.debug("loadClass(" + name + ", " + resolve + ")");
        }
        Class<?> clazz = null;
        if (!this.started) {
            try {
                throw new IllegalStateException();
            }
            catch (IllegalStateException e) {
                log.info(sm.getString("webappClassLoader.stopped", name), e);
            }
        }
        if ((clazz = this.findLoadedClass0(name)) != null) {
            if (log.isDebugEnabled()) {
                log.debug("  Returning class from cache");
            }
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        clazz = this.findLoadedClass(name);
        if (clazz != null) {
            if (log.isDebugEnabled()) {
                log.debug("  Returning class from cache");
            }
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        try {
            clazz = this.system.loadClass(name);
            if (clazz != null) {
                if (resolve) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {}
        if (this.securityManager != null && (i = name.lastIndexOf(46)) >= 0) {
            try {
                this.securityManager.checkPackageAccess(name.substring(0, i));
            }
            catch (SecurityException se) {
                String error = "Security Violation, attempt to use Restricted Class: " + name;
                log.info(error, se);
                throw new ClassNotFoundException(error, se);
            }
        }
        boolean bl = delegateLoad = this.delegate || this.filter(name);
        if (delegateLoad) {
            if (log.isDebugEnabled()) {
                log.debug("  Delegating to parent classloader1 " + this.parent);
            }
            if ((loader = this.parent) == null) {
                loader = this.system;
            }
            try {
                clazz = Class.forName(name, false, loader);
                if (clazz != null) {
                    if (log.isDebugEnabled()) {
                        log.debug("  Loading class from parent");
                    }
                    if (resolve) {
                        this.resolveClass(clazz);
                    }
                    return clazz;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        if (log.isDebugEnabled()) {
            log.debug("  Searching local repositories");
        }
        try {
            clazz = this.findClass(name);
            if (clazz != null) {
                if (log.isDebugEnabled()) {
                    log.debug("  Loading class from local repository");
                }
                if (resolve) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {}
        if (!delegateLoad) {
            if (log.isDebugEnabled()) {
                log.debug("  Delegating to parent classloader at end: " + this.parent);
            }
            if ((loader = this.parent) == null) {
                loader = this.system;
            }
            try {
                clazz = Class.forName(name, false, loader);
                if (clazz != null) {
                    if (log.isDebugEnabled()) {
                        log.debug("  Loading class from parent");
                    }
                    if (resolve) {
                        this.resolveClass(clazz);
                    }
                    return clazz;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource codeSource) {
        String codeUrl = codeSource.getLocation().toString();
        PermissionCollection pc = this.loaderPC.get(codeUrl);
        if (pc == null && (pc = super.getPermissions(codeSource)) != null) {
            for (Permission p : this.permissionList) {
                pc.add(p);
            }
            this.loaderPC.put(codeUrl, pc);
        }
        return pc;
    }

    @Override
    public URL[] getURLs() {
        if (this.repositoryURLs != null) {
            return (URL[])this.repositoryURLs.clone();
        }
        URL[] external = super.getURLs();
        int filesLength = this.files.length;
        int jarFilesLength = this.jarRealFiles.length;
        int externalsLength = external.length;
        int off = 0;
        try {
            int i;
            URL[] urls = new URL[filesLength + jarFilesLength + externalsLength];
            if (this.searchExternalFirst) {
                i = 0;
                while (i < externalsLength) {
                    urls[i] = external[i];
                    ++i;
                }
                off = externalsLength;
            }
            i = 0;
            while (i < filesLength) {
                urls[off + i] = this.getURL(this.files[i], true);
                ++i;
            }
            off += filesLength;
            i = 0;
            while (i < jarFilesLength) {
                urls[off + i] = this.getURL(this.jarRealFiles[i], true);
                ++i;
            }
            off += jarFilesLength;
            if (!this.searchExternalFirst) {
                i = 0;
                while (i < externalsLength) {
                    urls[off + i] = external[i];
                    ++i;
                }
            }
            this.repositoryURLs = urls;
        }
        catch (MalformedURLException malformedURLException) {
            this.repositoryURLs = new URL[0];
        }
        return (URL[])this.repositoryURLs.clone();
    }

    @Override
    public void addLifecycleListener(LifecycleListener listener) {
    }

    @Override
    public LifecycleListener[] findLifecycleListeners() {
        return new LifecycleListener[0];
    }

    @Override
    public void removeLifecycleListener(LifecycleListener listener) {
    }

    @Override
    public LifecycleState getState() {
        return LifecycleState.NEW;
    }

    @Override
    public String getStateName() {
        return this.getState().toString();
    }

    @Override
    public void init() {
    }

    @Override
    public void start() throws LifecycleException {
        this.started = true;
        String encoding = null;
        try {
            encoding = System.getProperty("file.encoding");
        }
        catch (SecurityException securityException) {
            return;
        }
        if (encoding.indexOf("EBCDIC") != -1) {
            this.needConvert = true;
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    @Override
    public void stop() throws LifecycleException {
        this.clearReferences();
        this.started = false;
        int length = this.files.length;
        int i = 0;
        while (i < length) {
            this.files[i] = null;
            ++i;
        }
        length = this.jarFiles.length;
        i = 0;
        while (i < length) {
            try {
                if (this.jarFiles[i] != null) {
                    this.jarFiles[i].close();
                }
            }
            catch (IOException iOException) {}
            this.jarFiles[i] = null;
            ++i;
        }
        this.notFoundResources.clear();
        this.resourceEntries.clear();
        this.resources = null;
        this.repositories = null;
        this.repositoryURLs = null;
        this.files = null;
        this.jarFiles = null;
        this.jarRealFiles = null;
        this.jarPath = null;
        this.jarNames = null;
        this.lastModifiedDates = null;
        this.paths = null;
        this.hasExternalRepositories = false;
        this.parent = null;
        this.permissionList.clear();
        this.loaderPC.clear();
        if (this.loaderDir != null) {
            WebappClassLoader.deleteDir(this.loaderDir);
        }
    }

    @Override
    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void closeJARs(boolean force) {
        if (this.jarFiles.length <= 0) return;
        JarFile[] jarFileArray = this.jarFiles;
        synchronized (this.jarFiles) {
            if (!force && System.currentTimeMillis() <= this.lastJarAccessed + 90000L) return;
            int i = 0;
            while (i < this.jarFiles.length) {
                block7: {
                    try {
                        if (this.jarFiles[i] != null) {
                            this.jarFiles[i].close();
                            this.jarFiles[i] = null;
                        }
                    }
                    catch (IOException e) {
                        if (!log.isDebugEnabled()) break block7;
                        log.debug("Failed to close JAR", e);
                    }
                }
                ++i;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    protected void clearReferences() {
        this.clearReferencesJdbc();
        this.clearReferencesThreads();
        this.checkThreadLocalsForLeaks();
        this.clearReferencesRmiTargets();
        if (this.clearReferencesStatic) {
            this.clearReferencesStaticFinal();
        }
        IntrospectionUtils.clear();
        if (this.clearReferencesLogFactoryRelease) {
            LogFactory.release(this);
        }
        this.clearReferencesResourceBundles();
        Introspector.flushCaches();
    }

    private final void clearReferencesJdbc() {
        block17: {
            InputStream is = this.getResourceAsStream("org/apache/catalina/loader/JdbcLeakPrevention.class");
            byte[] classBytes = new byte[2048];
            int offset = 0;
            try {
                try {
                    int read = is.read(classBytes, offset, classBytes.length - offset);
                    while (read > -1) {
                        if ((offset += read) == classBytes.length) {
                            byte[] tmp = new byte[classBytes.length * 2];
                            System.arraycopy(classBytes, 0, tmp, 0, classBytes.length);
                            classBytes = tmp;
                        }
                        read = is.read(classBytes, offset, classBytes.length - offset);
                    }
                    Class<?> lpClass = this.defineClass("org.apache.catalina.loader.JdbcLeakPrevention", classBytes, 0, offset, this.getClass().getProtectionDomain());
                    Object obj = lpClass.newInstance();
                    List driverNames = (List)obj.getClass().getMethod("clearJdbcDriverRegistrations", new Class[0]).invoke(obj, new Object[0]);
                    for (String name : driverNames) {
                        log.error(sm.getString("webappClassLoader.clearJdbc", this.contextName, name));
                    }
                }
                catch (Exception e) {
                    log.warn(sm.getString("webappClassLoader.jdbcRemoveFailed", this.contextName), e);
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException ioe) {
                            log.warn(sm.getString("webappClassLoader.jdbcRemoveStreamError", this.contextName), ioe);
                        }
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException ioe) {
                        log.warn(sm.getString("webappClassLoader.jdbcRemoveStreamError", this.contextName), ioe);
                    }
                }
                throw throwable;
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ioe) {
                    log.warn(sm.getString("webappClassLoader.jdbcRemoveStreamError", this.contextName), ioe);
                }
            }
        }
    }

    private final void clearReferencesStaticFinal() {
        int i;
        Field[] fields;
        Class<?> clazz;
        Collection values = ((HashMap)this.resourceEntries.clone()).values();
        block6: for (ResourceEntry entry : values) {
            if (entry.loadedClass == null) continue;
            clazz = entry.loadedClass;
            try {
                fields = clazz.getDeclaredFields();
                i = 0;
                while (i < fields.length) {
                    if (Modifier.isStatic(fields[i].getModifiers())) {
                        fields[i].get(null);
                        continue block6;
                    }
                    ++i;
                }
            }
            catch (Throwable throwable) {}
        }
        for (ResourceEntry entry : values) {
            if (entry.loadedClass == null) continue;
            clazz = entry.loadedClass;
            try {
                fields = clazz.getDeclaredFields();
                i = 0;
                while (i < fields.length) {
                    block16: {
                        Field field = fields[i];
                        int mods = field.getModifiers();
                        if (!field.getType().isPrimitive() && field.getName().indexOf("$") == -1 && Modifier.isStatic(mods)) {
                            try {
                                field.setAccessible(true);
                                if (Modifier.isFinal(mods)) {
                                    if (!field.getType().getName().startsWith("java.") && !field.getType().getName().startsWith("javax.")) {
                                        this.nullInstance(field.get(null));
                                    }
                                } else {
                                    field.set(null, null);
                                    if (log.isDebugEnabled()) {
                                        log.debug("Set field " + field.getName() + " to null in class " + clazz.getName());
                                    }
                                }
                            }
                            catch (Throwable t) {
                                ExceptionUtils.handleThrowable(t);
                                if (!log.isDebugEnabled()) break block16;
                                log.debug("Could not set field " + field.getName() + " to null in class " + clazz.getName(), t);
                            }
                        }
                    }
                    ++i;
                }
            }
            catch (Throwable t) {
                ExceptionUtils.handleThrowable(t);
                if (!log.isDebugEnabled()) continue;
                log.debug("Could not clean fields for class " + clazz.getName(), t);
            }
        }
    }

    private void nullInstance(Object instance) {
        if (instance == null) {
            return;
        }
        Field[] fields = instance.getClass().getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            block10: {
                Field field = fields[i];
                int mods = field.getModifiers();
                if (!field.getType().isPrimitive() && field.getName().indexOf("$") == -1) {
                    try {
                        Object value;
                        field.setAccessible(true);
                        if (!(Modifier.isStatic(mods) && Modifier.isFinal(mods) || (value = field.get(instance)) == null)) {
                            Class<?> valueClass = value.getClass();
                            if (!this.loadedByThisOrChild(valueClass)) {
                                if (log.isDebugEnabled()) {
                                    log.debug("Not setting field " + field.getName() + " to null in object of class " + instance.getClass().getName() + " because the referenced object was of type " + valueClass.getName() + " which was not loaded by this WebappClassLoader.");
                                }
                            } else {
                                field.set(instance, null);
                                if (log.isDebugEnabled()) {
                                    log.debug("Set field " + field.getName() + " to null in class " + instance.getClass().getName());
                                }
                            }
                        }
                    }
                    catch (Throwable t) {
                        ExceptionUtils.handleThrowable(t);
                        if (!log.isDebugEnabled()) break block10;
                        log.debug("Could not set field " + field.getName() + " to null in object instance of class " + instance.getClass().getName(), t);
                    }
                }
            }
            ++i;
        }
    }

    private void clearReferencesThreads() {
        Thread[] threads;
        Thread[] threadArray = threads = this.getThreads();
        int n = threads.length;
        int n2 = 0;
        while (n2 < n) {
            ClassLoader ccl;
            Thread thread = threadArray[n2];
            if (thread != null && (ccl = thread.getContextClassLoader()) == this && thread != Thread.currentThread() && thread.isAlive()) {
                ThreadGroup tg = thread.getThreadGroup();
                if (tg != null && JVM_THREAD_GROUP_NAMES.contains(tg.getName())) {
                    if (this.clearReferencesHttpClientKeepAliveThread && thread.getName().equals("Keep-Alive-Timer")) {
                        thread.setContextClassLoader(this.parent);
                        log.debug(sm.getString("webappClassLoader.checkThreadsHttpClient"));
                    }
                } else if (thread.getClass().getName().equals("java.util.TimerThread") && this.clearReferencesStopTimerThreads) {
                    this.clearReferencesStopTimerThread(thread);
                } else {
                    if (this.isRequestThread(thread)) {
                        log.error(sm.getString("webappClassLoader.warnRequestThread", this.contextName, thread.getName()));
                    } else {
                        log.error(sm.getString("webappClassLoader.warnThread", this.contextName, thread.getName()));
                    }
                    if (this.clearReferencesStopThreads) {
                        try {
                            Field targetField = thread.getClass().getDeclaredField("target");
                            targetField.setAccessible(true);
                            Object target = targetField.get(thread);
                            if (target != null && target.getClass().getCanonicalName().equals("java.util.concurrent.ThreadPoolExecutor.Worker")) {
                                Field executorField = target.getClass().getDeclaredField("this$0");
                                executorField.setAccessible(true);
                                Object executor = executorField.get(target);
                                if (executor instanceof ThreadPoolExecutor) {
                                    ((ThreadPoolExecutor)executor).shutdownNow();
                                }
                            }
                        }
                        catch (SecurityException e) {
                            log.warn(sm.getString("webappClassLoader.stopThreadFail", thread.getName(), this.contextName), e);
                        }
                        catch (NoSuchFieldException e) {
                            log.warn(sm.getString("webappClassLoader.stopThreadFail", thread.getName(), this.contextName), e);
                        }
                        catch (IllegalArgumentException e) {
                            log.warn(sm.getString("webappClassLoader.stopThreadFail", thread.getName(), this.contextName), e);
                        }
                        catch (IllegalAccessException e) {
                            log.warn(sm.getString("webappClassLoader.stopThreadFail", thread.getName(), this.contextName), e);
                        }
                        thread.stop();
                    }
                }
            }
            ++n2;
        }
    }

    private boolean isRequestThread(Thread thread) {
        StackTraceElement[] elements = thread.getStackTrace();
        if (elements == null || elements.length == 0) {
            return false;
        }
        int i = 0;
        while (i < elements.length) {
            StackTraceElement element = elements[elements.length - (i + 1)];
            if ("org.apache.catalina.connector.CoyoteAdapter".equals(element.getClassName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearReferencesStopTimerThread(Thread thread) {
        try {
            Field newTasksMayBeScheduledField = thread.getClass().getDeclaredField("newTasksMayBeScheduled");
            newTasksMayBeScheduledField.setAccessible(true);
            Field queueField = thread.getClass().getDeclaredField("queue");
            queueField.setAccessible(true);
            Object queue = queueField.get(thread);
            Method clearMethod = queue.getClass().getDeclaredMethod("clear", new Class[0]);
            clearMethod.setAccessible(true);
            Object object = queue;
            synchronized (object) {
                newTasksMayBeScheduledField.setBoolean(thread, false);
                clearMethod.invoke(queue, new Object[0]);
                queue.notify();
            }
            log.error(sm.getString("webappClassLoader.warnTimerThread", this.contextName, thread.getName()));
        }
        catch (NoSuchFieldException e) {
            log.warn(sm.getString("webappClassLoader.stopTimerThreadFail", thread.getName(), this.contextName), e);
        }
        catch (IllegalAccessException e) {
            log.warn(sm.getString("webappClassLoader.stopTimerThreadFail", thread.getName(), this.contextName), e);
        }
        catch (NoSuchMethodException e) {
            log.warn(sm.getString("webappClassLoader.stopTimerThreadFail", thread.getName(), this.contextName), e);
        }
        catch (InvocationTargetException e) {
            log.warn(sm.getString("webappClassLoader.stopTimerThreadFail", thread.getName(), this.contextName), e);
        }
    }

    private void checkThreadLocalsForLeaks() {
        Thread[] threads = this.getThreads();
        try {
            Field threadLocalsField = Thread.class.getDeclaredField("threadLocals");
            threadLocalsField.setAccessible(true);
            Field inheritableThreadLocalsField = Thread.class.getDeclaredField("inheritableThreadLocals");
            inheritableThreadLocalsField.setAccessible(true);
            Class<?> tlmClass = Class.forName("java.lang.ThreadLocal$ThreadLocalMap");
            Field tableField = tlmClass.getDeclaredField("table");
            tableField.setAccessible(true);
            int i = 0;
            while (i < threads.length) {
                if (threads[i] != null) {
                    Object threadLocalMap = threadLocalsField.get(threads[i]);
                    this.checkThreadLocalMapForLeaks(threadLocalMap, tableField);
                    threadLocalMap = inheritableThreadLocalsField.get(threads[i]);
                    this.checkThreadLocalMapForLeaks(threadLocalMap, tableField);
                }
                ++i;
            }
        }
        catch (SecurityException e) {
            log.warn(sm.getString("webappClassLoader.checkThreadLocalsForLeaksFail", this.contextName), e);
        }
        catch (NoSuchFieldException e) {
            log.warn(sm.getString("webappClassLoader.checkThreadLocalsForLeaksFail", this.contextName), e);
        }
        catch (ClassNotFoundException e) {
            log.warn(sm.getString("webappClassLoader.checkThreadLocalsForLeaksFail", this.contextName), e);
        }
        catch (IllegalArgumentException e) {
            log.warn(sm.getString("webappClassLoader.checkThreadLocalsForLeaksFail", this.contextName), e);
        }
        catch (IllegalAccessException e) {
            log.warn(sm.getString("webappClassLoader.checkThreadLocalsForLeaksFail", this.contextName), e);
        }
    }

    private void checkThreadLocalMapForLeaks(Object map, Field internalTableField) throws IllegalAccessException, NoSuchFieldException {
        Object[] table;
        if (map != null && (table = (Object[])internalTableField.get(map)) != null) {
            int j = 0;
            while (j < table.length) {
                if (table[j] != null) {
                    boolean potentialLeak = false;
                    Object key = ((Reference)table[j]).get();
                    if (this.equals(key) || this.loadedByThisOrChild(key)) {
                        potentialLeak = true;
                    }
                    Field valueField = table[j].getClass().getDeclaredField("value");
                    valueField.setAccessible(true);
                    Object value = valueField.get(table[j]);
                    if (this.equals(value) || this.loadedByThisOrChild(value)) {
                        potentialLeak = true;
                    }
                    if (potentialLeak) {
                        Object[] args = new Object[5];
                        args[0] = this.contextName;
                        if (key != null) {
                            args[1] = this.getPrettyClassName(key.getClass());
                            try {
                                args[2] = key.toString();
                            }
                            catch (Exception e) {
                                log.error(sm.getString("webappClassLoader.checkThreadLocalsForLeaks.badKey", args[1]), e);
                                args[2] = sm.getString("webappClassLoader.checkThreadLocalsForLeaks.unknown");
                            }
                        }
                        if (value != null) {
                            args[3] = this.getPrettyClassName(value.getClass());
                            try {
                                args[4] = value.toString();
                            }
                            catch (Exception e) {
                                log.error(sm.getString("webappClassLoader.checkThreadLocalsForLeaks.badValue", args[3]), e);
                                args[4] = sm.getString("webappClassLoader.checkThreadLocalsForLeaks.unknown");
                            }
                        }
                        if (value == null) {
                            if (log.isDebugEnabled()) {
                                log.debug(sm.getString("webappClassLoader.checkThreadLocalsForLeaksDebug", args));
                            }
                        } else {
                            log.error(sm.getString("webappClassLoader.checkThreadLocalsForLeaks", args));
                        }
                    }
                }
                ++j;
            }
        }
    }

    private String getPrettyClassName(Class<?> clazz) {
        String name = clazz.getCanonicalName();
        if (name == null) {
            name = clazz.getName();
        }
        return name;
    }

    private boolean loadedByThisOrChild(Object o) {
        if (o == null) {
            return false;
        }
        Class<?> clazz = o instanceof Class ? (Class<?>)o : o.getClass();
        ClassLoader cl = clazz.getClassLoader();
        while (cl != null) {
            if (cl == this) {
                return true;
            }
            cl = cl.getParent();
        }
        return false;
    }

    private Thread[] getThreads() {
        ThreadGroup tg = Thread.currentThread().getThreadGroup();
        while (tg.getParent() != null) {
            tg = tg.getParent();
        }
        int threadCountGuess = tg.activeCount() + 50;
        Thread[] threads = new Thread[threadCountGuess];
        int threadCountActual = tg.enumerate(threads);
        while (threadCountActual == threadCountGuess) {
            threads = new Thread[threadCountGuess *= 2];
            threadCountActual = tg.enumerate(threads);
        }
        return threads;
    }

    private void clearReferencesRmiTargets() {
        try {
            Class<?> objectTargetClass = Class.forName("sun.rmi.transport.Target");
            Field cclField = objectTargetClass.getDeclaredField("ccl");
            cclField.setAccessible(true);
            Class<?> objectTableClass = Class.forName("sun.rmi.transport.ObjectTable");
            Field objTableField = objectTableClass.getDeclaredField("objTable");
            objTableField.setAccessible(true);
            Object objTable = objTableField.get(null);
            if (objTable == null) {
                return;
            }
            if (objTable instanceof Map) {
                Iterator iter = ((Map)objTable).values().iterator();
                while (iter.hasNext()) {
                    Object obj = iter.next();
                    Object cclObject = cclField.get(obj);
                    if (this != cclObject) continue;
                    iter.remove();
                }
            }
            Field implTableField = objectTableClass.getDeclaredField("implTable");
            implTableField.setAccessible(true);
            Object implTable = implTableField.get(null);
            if (implTable == null) {
                return;
            }
            if (implTable instanceof Map) {
                Iterator iter = ((Map)implTable).values().iterator();
                while (iter.hasNext()) {
                    Object obj = iter.next();
                    Object cclObject = cclField.get(obj);
                    if (this != cclObject) continue;
                    iter.remove();
                }
            }
        }
        catch (ClassNotFoundException e) {
            log.info(sm.getString("webappClassLoader.clearRmiInfo", this.contextName), e);
        }
        catch (SecurityException e) {
            log.warn(sm.getString("webappClassLoader.clearRmiFail", this.contextName), e);
        }
        catch (NoSuchFieldException e) {
            log.warn(sm.getString("webappClassLoader.clearRmiFail", this.contextName), e);
        }
        catch (IllegalArgumentException e) {
            log.warn(sm.getString("webappClassLoader.clearRmiFail", this.contextName), e);
        }
        catch (IllegalAccessException e) {
            log.warn(sm.getString("webappClassLoader.clearRmiFail", this.contextName), e);
        }
    }

    private void clearReferencesResourceBundles() {
        try {
            Field cacheListField = ResourceBundle.class.getDeclaredField("cacheList");
            cacheListField.setAccessible(true);
            Map cacheList = (Map)cacheListField.get(null);
            Set keys = cacheList.keySet();
            Field loaderRefField = null;
            Iterator keysIter = keys.iterator();
            int countRemoved = 0;
            while (keysIter.hasNext()) {
                Object key = keysIter.next();
                if (loaderRefField == null) {
                    loaderRefField = key.getClass().getDeclaredField("loaderRef");
                    loaderRefField.setAccessible(true);
                }
                WeakReference loaderRef = (WeakReference)loaderRefField.get(key);
                ClassLoader loader = (ClassLoader)loaderRef.get();
                while (loader != null && loader != this) {
                    loader = loader.getParent();
                }
                if (loader == null) continue;
                keysIter.remove();
                ++countRemoved;
            }
            if (countRemoved > 0 && log.isDebugEnabled()) {
                log.debug(sm.getString("webappClassLoader.clearReferencesResourceBundlesCount", countRemoved, this.contextName));
            }
        }
        catch (SecurityException e) {
            log.error(sm.getString("webappClassLoader.clearReferencesResourceBundlesFail", this.contextName), e);
        }
        catch (NoSuchFieldException e) {
            if (System.getProperty("java.vendor").startsWith("Sun")) {
                log.error(sm.getString("webappClassLoader.clearReferencesResourceBundlesFail", this.contextName), e);
            } else {
                log.debug(sm.getString("webappClassLoader.clearReferencesResourceBundlesFail", this.contextName), e);
            }
        }
        catch (IllegalArgumentException e) {
            log.error(sm.getString("webappClassLoader.clearReferencesResourceBundlesFail", this.contextName), e);
        }
        catch (IllegalAccessException e) {
            log.error(sm.getString("webappClassLoader.clearReferencesResourceBundlesFail", this.contextName), e);
        }
    }

    protected boolean openJARs() {
        if (this.started && this.jarFiles.length > 0) {
            this.lastJarAccessed = System.currentTimeMillis();
            if (this.jarFiles[0] == null) {
                int i = 0;
                while (i < this.jarFiles.length) {
                    try {
                        this.jarFiles[i] = new JarFile(this.jarRealFiles[i]);
                    }
                    catch (IOException e) {
                        if (log.isDebugEnabled()) {
                            log.debug("Failed to open JAR", e);
                        }
                        return false;
                    }
                    ++i;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class<?> findClassInternal(String name) throws ClassNotFoundException {
        if (!this.validate(name)) {
            throw new ClassNotFoundException(name);
        }
        String tempPath = name.replace('.', '/');
        String classPath = String.valueOf(tempPath) + ".class";
        ResourceEntry entry = null;
        if (this.securityManager != null) {
            PrivilegedFindResourceByName dp = new PrivilegedFindResourceByName(name, classPath);
            entry = AccessController.doPrivileged(dp);
        } else {
            entry = this.findResourceInternal(name, classPath);
        }
        if (entry == null) {
            throw new ClassNotFoundException(name);
        }
        Class<?> clazz = entry.loadedClass;
        if (clazz != null) {
            return clazz;
        }
        WebappClassLoader webappClassLoader = this;
        synchronized (webappClassLoader) {
            clazz = entry.loadedClass;
            if (clazz != null) {
                return clazz;
            }
            if (entry.binaryContent == null) {
                throw new ClassNotFoundException(name);
            }
            String packageName = null;
            int pos = name.lastIndexOf(46);
            if (pos != -1) {
                packageName = name.substring(0, pos);
            }
            Package pkg = null;
            if (packageName != null && (pkg = this.getPackage(packageName)) == null) {
                try {
                    if (entry.manifest == null) {
                        this.definePackage(packageName, null, null, null, null, null, null, null);
                    } else {
                        this.definePackage(packageName, entry.manifest, entry.codeBase);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                pkg = this.getPackage(packageName);
            }
            if (this.securityManager != null && pkg != null) {
                boolean sealCheck = true;
                if (pkg.isSealed()) {
                    sealCheck = pkg.isSealed(entry.codeBase);
                } else {
                    boolean bl = sealCheck = entry.manifest == null || !this.isPackageSealed(packageName, entry.manifest);
                }
                if (!sealCheck) {
                    throw new SecurityException("Sealing violation loading " + name + " : Package " + packageName + " is sealed.");
                }
            }
            try {
                clazz = this.defineClass(name, entry.binaryContent, 0, entry.binaryContent.length, new CodeSource(entry.codeBase, entry.certificates));
            }
            catch (UnsupportedClassVersionError ucve) {
                throw new UnsupportedClassVersionError(String.valueOf(ucve.getLocalizedMessage()) + " " + sm.getString("webappClassLoader.wrongVersion", name));
            }
            entry.loadedClass = clazz;
            entry.binaryContent = null;
            entry.source = null;
            entry.codeBase = null;
            entry.manifest = null;
            entry.certificates = null;
        }
        return clazz;
    }

    protected ResourceEntry findResourceInternal(File file, String path) {
        ResourceEntry entry = new ResourceEntry();
        try {
            entry.source = this.getURI(new File(file, path));
            entry.codeBase = this.getURL(new File(file, path), false);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        return entry;
    }

    /*
     * Exception decompiling
     */
    protected ResourceEntry findResourceInternal(String name, String path) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[TRYBLOCK], 8[TRYBLOCK]], but top level block is 76[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected boolean isPackageSealed(String name, Manifest man) {
        String path = String.valueOf(name.replace('.', '/')) + '/';
        Attributes attr = man.getAttributes(path);
        String sealed = null;
        if (attr != null) {
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        if (sealed == null && (attr = man.getMainAttributes()) != null) {
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        return "true".equalsIgnoreCase(sealed);
    }

    protected InputStream findLoadedResource(String name) {
        ResourceEntry entry = this.resourceEntries.get(name);
        if (entry != null && entry.binaryContent != null) {
            return new ByteArrayInputStream(entry.binaryContent);
        }
        return null;
    }

    protected Class<?> findLoadedClass0(String name) {
        ResourceEntry entry = this.resourceEntries.get(name);
        if (entry != null) {
            return entry.loadedClass;
        }
        return null;
    }

    protected void refreshPolicy() {
        try {
            Policy policy = Policy.getPolicy();
            policy.refresh();
        }
        catch (AccessControlException accessControlException) {}
    }

    protected boolean filter(String name) {
        if (name == null) {
            return false;
        }
        String packageName = null;
        int pos = name.lastIndexOf(46);
        if (pos == -1) {
            return false;
        }
        packageName = name.substring(0, pos);
        int i = 0;
        while (i < packageTriggers.length) {
            if (packageName.startsWith(packageTriggers[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean validate(String name) {
        if (name == null) {
            return false;
        }
        if (name.startsWith("java.")) {
            return false;
        }
        if (name.startsWith("javax.servlet.jsp.jstl")) {
            return true;
        }
        return !name.startsWith("javax.servlet.");
    }

    protected boolean validateJarFile(File jarfile) throws IOException {
        if (triggers == null) {
            return true;
        }
        JarFile jarFile = new JarFile(jarfile);
        int i = 0;
        while (i < triggers.length) {
            Class<?> clazz = null;
            try {
                clazz = this.parent != null ? this.parent.loadClass(triggers[i]) : Class.forName(triggers[i]);
            }
            catch (Exception exception) {
                clazz = null;
            }
            if (clazz != null) {
                JarEntry jarEntry;
                String name = String.valueOf(triggers[i].replace('.', '/')) + ".class";
                if (log.isDebugEnabled()) {
                    log.debug(" Checking for " + name);
                }
                if ((jarEntry = jarFile.getJarEntry(name)) != null) {
                    log.info("validateJarFile(" + jarfile + ") - jar not loaded. See Servlet Spec 2.3, " + "section 9.7.2. Offending class: " + name);
                    jarFile.close();
                    return false;
                }
            }
            ++i;
        }
        jarFile.close();
        return true;
    }

    protected URL getURL(File file, boolean encoded) throws MalformedURLException {
        File realFile = file;
        try {
            realFile = realFile.getCanonicalFile();
        }
        catch (IOException iOException) {}
        if (encoded) {
            return this.getURI(realFile);
        }
        return realFile.toURI().toURL();
    }

    protected URL getURI(File file) throws MalformedURLException {
        File realFile = file;
        try {
            realFile = realFile.getCanonicalFile();
        }
        catch (IOException iOException) {}
        return realFile.toURI().toURL();
    }

    protected static void deleteDir(File dir) {
        String[] files = dir.list();
        if (files == null) {
            files = new String[]{};
        }
        int i = 0;
        while (i < files.length) {
            File file = new File(dir, files[i]);
            if (file.isDirectory()) {
                WebappClassLoader.deleteDir(file);
            } else {
                file.delete();
            }
            ++i;
        }
        dir.delete();
    }

    protected class PrivilegedFindResourceByName
    implements PrivilegedAction<ResourceEntry> {
        protected String name;
        protected String path;

        PrivilegedFindResourceByName(String name, String path) {
            this.name = name;
            this.path = path;
        }

        @Override
        public ResourceEntry run() {
            return WebappClassLoader.this.findResourceInternal(this.name, this.path);
        }
    }

    protected static final class PrivilegedGetClassLoader
    implements PrivilegedAction<ClassLoader> {
        public Class<?> clazz;

        public PrivilegedGetClassLoader(Class<?> clazz) {
            this.clazz = clazz;
        }

        @Override
        public ClassLoader run() {
            return this.clazz.getClassLoader();
        }
    }
}

