/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.theme;

import java.io.Serializable;
import java.util.zip.CRC32;
import org.eclipse.rap.rwt.internal.theme.CssDimension;
import org.eclipse.rap.rwt.internal.theme.CssValue;
import org.eclipse.rap.rwt.theme.BoxDimensions;

public class CssBoxDimensions
implements CssValue,
Serializable {
    public static final CssBoxDimensions ZERO = new CssBoxDimensions(0, 0, 0, 0);
    public final BoxDimensions dimensions;

    private CssBoxDimensions(int top, int right, int bottom, int left) {
        this.dimensions = new BoxDimensions(top, right, bottom, left);
    }

    public static CssBoxDimensions create(int top, int right, int bottom, int left) {
        if (top == 0 && right == 0 && bottom == 0 && left == 0) {
            return ZERO;
        }
        return new CssBoxDimensions(top, right, bottom, left);
    }

    public static CssBoxDimensions valueOf(String input) {
        int left;
        if (input == null) {
            throw new NullPointerException("null argument");
        }
        String[] parts = input.split("\\s+");
        if (parts.length == 0 || parts.length > 4) {
            String msg = "Illegal number of arguments for box dimensions";
            throw new IllegalArgumentException(msg);
        }
        int bottom = left = CssBoxDimensions.parsePxValue(parts[0]);
        int right = left;
        int top = left;
        if (parts.length >= 2) {
            right = left = CssBoxDimensions.parsePxValue(parts[1]);
        }
        if (parts.length >= 3) {
            bottom = CssBoxDimensions.parsePxValue(parts[2]);
        }
        if (parts.length == 4) {
            left = CssBoxDimensions.parsePxValue(parts[3]);
        }
        return CssBoxDimensions.create(top, right, bottom, left);
    }

    @Override
    public String toDefaultString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(String.valueOf(this.dimensions.top) + "px");
        if (this.dimensions.right != this.dimensions.top || this.dimensions.bottom != this.dimensions.top || this.dimensions.left != this.dimensions.top) {
            buffer.append(" " + this.dimensions.right + "px");
        }
        if (this.dimensions.bottom != this.dimensions.top || this.dimensions.left != this.dimensions.right) {
            buffer.append(" " + this.dimensions.bottom + "px");
        }
        if (this.dimensions.left != this.dimensions.right) {
            buffer.append(" " + this.dimensions.left + "px");
        }
        return buffer.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof CssBoxDimensions) {
            CssBoxDimensions other = (CssBoxDimensions)object;
            return other.dimensions.equals(this.dimensions);
        }
        return false;
    }

    public int hashCode() {
        CRC32 result = new CRC32();
        result.update(this.dimensions.top);
        result.update(this.dimensions.right);
        result.update(this.dimensions.bottom);
        result.update(this.dimensions.left);
        return (int)result.getValue();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("CssBoxDimensions{ ");
        buffer.append(this.dimensions.top);
        buffer.append(", ");
        buffer.append(this.dimensions.right);
        buffer.append(", ");
        buffer.append(this.dimensions.bottom);
        buffer.append(", ");
        buffer.append(this.dimensions.left);
        buffer.append(" }");
        return buffer.toString();
    }

    private static int parsePxValue(String part) {
        Integer result = CssDimension.parseLength(part);
        if (result == null) {
            throw new IllegalArgumentException("Illegal parameter: " + part);
        }
        return result;
    }
}

