/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.felix.gogo.command.Util;
import org.apache.felix.service.command.Descriptor;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;

public class Inspect {
    public static final String NONSTANDARD_SERVICE_NAMESPACE = "service";
    public static final String CAPABILITY = "capability";
    public static final String REQUIREMENT = "requirement";
    private static final String EMPTY_MESSAGE = "[EMPTY]";
    private static final String UNUSED_MESSAGE = "[UNUSED]";
    private static final String UNRESOLVED_MESSAGE = "[UNRESOLVED]";
    private final BundleContext m_bc;

    public Inspect(BundleContext bc) {
        this.m_bc = bc;
    }

    @Descriptor(value="inspects bundle capabilities and requirements")
    public String inspect(@Descriptor(value="('capability' | 'requirement')") String direction, @Descriptor(value="(<namespace> | 'service')") String namespace, @Descriptor(value="target bundles") Bundle[] bundles) {
        return Inspect.inspect(this.m_bc, direction, namespace, bundles);
    }

    private static String inspect(BundleContext bc, String direction, String namespace, Bundle[] bundles) {
        if (Inspect.isValidDirection(direction)) {
            Bundle[] bundleArray = bundles = bundles == null || bundles.length == 0 ? bc.getBundles() : bundles;
            if (CAPABILITY.startsWith(direction)) {
                return Inspect.printCapabilities(bc, Util.parseSubstring(namespace), bundles);
            }
            return Inspect.printRequirements(bc, Util.parseSubstring(namespace), bundles);
        }
        return "Invalid argument: " + direction;
    }

    public static String printCapabilities(BundleContext bc, List<String> namespace, Bundle[] bundles) {
        try (Formatter f = new Formatter();){
            for (Bundle b : bundles) {
                BundleWiring wiring = (BundleWiring)b.adapt(BundleWiring.class);
                if (wiring != null) {
                    String title = b + " provides:";
                    f.format("%s%n%s%n", title, Util.getUnderlineString(title.length()));
                    boolean matches = Inspect.printMatchingCapabilities(wiring, namespace, f);
                    if (Inspect.matchNamespace(namespace, NONSTANDARD_SERVICE_NAMESPACE)) {
                        matches |= Inspect.printServiceCapabilities(b, f);
                    }
                    if (matches) continue;
                    f.format("%s %s%n", Util.unparseSubstring(namespace), EMPTY_MESSAGE);
                    continue;
                }
                f.format("Bundle %s is not resolved.", b.getBundleId());
            }
            String string = f.toString();
            return string;
        }
    }

    private static boolean printMatchingCapabilities(BundleWiring wiring, List<String> namespace, Formatter f) {
        List wires = wiring.getProvidedWires(null);
        Map<BundleCapability, List<BundleWire>> aggregateCaps = Inspect.aggregateCapabilities(namespace, wires);
        List allCaps = wiring.getCapabilities(null);
        boolean matches = false;
        for (BundleCapability cap : allCaps) {
            if (!Inspect.matchNamespace(namespace, cap.getNamespace()) || "osgi.service".equals(cap.getNamespace())) continue;
            matches = true;
            List<BundleWire> dependents = aggregateCaps.get(cap);
            Object keyAttr = cap.getAttributes().get(cap.getNamespace());
            if ("osgi.native".equals(cap.getNamespace())) {
                f.format("%s with properties:%n", cap.getNamespace());
                cap.getAttributes().entrySet().stream().sorted((e1, e2) -> ((String)e1.getKey()).compareTo((String)e2.getKey())).forEach(e -> f.format("   %s = %s%n", e.getKey(), e.getValue()));
                if (dependents != null) {
                    f.format("   required by:%n", new Object[0]);
                    dependents.forEach(wire -> f.format("      %s%n", wire.getRequirerWiring().getBundle()));
                    continue;
                }
                f.format("   %s%n", UNUSED_MESSAGE);
                continue;
            }
            if (dependents != null) {
                if (keyAttr != null) {
                    f.format("%s; %s %s required by:%n", cap.getNamespace(), Inspect.format(keyAttr), Inspect.getVersionFromCapability(cap));
                } else {
                    f.format("%s required by:%n", cap.toString());
                }
                for (BundleWire wire2 : dependents) {
                    f.format("   %s%n", wire2.getRequirerWiring().getBundle());
                }
                continue;
            }
            if (keyAttr != null) {
                f.format("%s; %s %s %s%n", cap.getNamespace(), Inspect.format(keyAttr), Inspect.getVersionFromCapability(cap), UNUSED_MESSAGE);
                continue;
            }
            f.format("%s %s%n", cap, UNUSED_MESSAGE);
        }
        return matches;
    }

    private static String format(Object object) {
        if (object.getClass().isArray()) {
            return Arrays.stream((Object[])object).map(Object::toString).collect(Collectors.joining(","));
        }
        if (object instanceof Collection) {
            return ((Collection)object).stream().map(Object::toString).collect(Collectors.joining(","));
        }
        return String.valueOf(object);
    }

    private static Map<BundleCapability, List<BundleWire>> aggregateCapabilities(List<String> namespace, List<BundleWire> wires) {
        HashMap<BundleCapability, List<BundleWire>> map = new HashMap<BundleCapability, List<BundleWire>>();
        for (BundleWire wire : wires) {
            if (!Inspect.matchNamespace(namespace, wire.getCapability().getNamespace())) continue;
            ArrayList<BundleWire> dependents = (ArrayList<BundleWire>)map.get(wire.getCapability());
            if (dependents == null) {
                dependents = new ArrayList<BundleWire>();
                map.put(wire.getCapability(), dependents);
            }
            dependents.add(wire);
        }
        return map;
    }

    static boolean printServiceCapabilities(Bundle b, Formatter f) {
        boolean matches = false;
        try {
            ServiceReference[] refs = b.getRegisteredServices();
            if (refs != null && refs.length > 0) {
                matches = true;
                for (ServiceReference ref : refs) {
                    String[] keys;
                    f.format("%s; %s with properties:%n", NONSTANDARD_SERVICE_NAMESPACE, Util.getValueString(ref.getProperty("objectClass")));
                    for (String key : keys = ref.getPropertyKeys()) {
                        if (key.equalsIgnoreCase("objectClass")) continue;
                        Object v = ref.getProperty(key);
                        f.format("   %s = %s%n", key, Util.getValueString(v));
                    }
                    Bundle[] users = ref.getUsingBundles();
                    if (users == null || users.length <= 0) continue;
                    f.format("   Used by:%n", new Object[0]);
                    for (Bundle user : users) {
                        f.format("      %s%n", user);
                    }
                }
            }
        }
        catch (Exception ex) {
            f.format("%s%n", ex.toString());
        }
        return matches;
    }

    public static String printRequirements(BundleContext bc, List<String> namespace, Bundle[] bundles) {
        try (Formatter f = new Formatter();){
            for (Bundle b : bundles) {
                BundleWiring wiring = (BundleWiring)b.adapt(BundleWiring.class);
                if (wiring != null) {
                    String title = b + " requires:";
                    f.format("%s%n%s%n", title, Util.getUnderlineString(title.length()));
                    boolean matches = Inspect.printMatchingRequirements(wiring, namespace, f);
                    if (Inspect.matchNamespace(namespace, NONSTANDARD_SERVICE_NAMESPACE)) {
                        matches |= Inspect.printServiceRequirements(b, f);
                    }
                    if (matches) continue;
                    f.format("%s %s%n", Util.unparseSubstring(namespace), EMPTY_MESSAGE);
                    continue;
                }
                f.format("Bundle %s is not resolved.%n", b.getBundleId());
            }
            String string = f.toString();
            return string;
        }
    }

    private static boolean printMatchingRequirements(BundleWiring wiring, List<String> namespace, Formatter f) {
        List wires = wiring.getRequiredWires(null);
        Map<BundleRequirement, List<BundleWire>> aggregateReqs = Inspect.aggregateRequirements(namespace, wires);
        List allReqs = wiring.getRequirements(null);
        boolean matches = false;
        for (BundleRequirement req : allReqs) {
            if (!Inspect.matchNamespace(namespace, req.getNamespace())) continue;
            matches = true;
            List<BundleWire> providers = aggregateReqs.get(req);
            if (providers != null) {
                f.format("%s; %s resolved by:%n", req.getNamespace(), req.getDirectives().get("filter"));
                for (BundleWire wire : providers) {
                    Object keyAttr = wire.getCapability().getAttributes().get(wire.getCapability().getNamespace());
                    String msg = keyAttr != null ? wire.getCapability().getNamespace() + "; " + keyAttr + " " + Inspect.getVersionFromCapability(wire.getCapability()) : wire.getCapability().toString();
                    f.format("   %s from %s%n", msg, wire.getProviderWiring().getBundle());
                }
                continue;
            }
            f.format("%s; %s %s%n", req.getNamespace(), req.getDirectives().get("filter"), UNRESOLVED_MESSAGE);
        }
        return matches;
    }

    private static Map<BundleRequirement, List<BundleWire>> aggregateRequirements(List<String> namespace, List<BundleWire> wires) {
        HashMap<BundleRequirement, List<BundleWire>> map = new HashMap<BundleRequirement, List<BundleWire>>();
        for (BundleWire wire : wires) {
            if (!Inspect.matchNamespace(namespace, wire.getRequirement().getNamespace())) continue;
            ArrayList<BundleWire> providers = (ArrayList<BundleWire>)map.get(wire.getRequirement());
            if (providers == null) {
                providers = new ArrayList<BundleWire>();
                map.put(wire.getRequirement(), providers);
            }
            providers.add(wire);
        }
        return map;
    }

    static boolean printServiceRequirements(Bundle b, Formatter f) {
        boolean matches = false;
        try {
            ServiceReference[] refs = b.getServicesInUse();
            if (refs != null && refs.length > 0) {
                matches = true;
                for (ServiceReference ref : refs) {
                    f.format("%s; %s provided by:%n   %s%n", NONSTANDARD_SERVICE_NAMESPACE, Util.getValueString(ref.getProperty("objectClass")), ref.getBundle());
                }
            }
        }
        catch (Exception ex) {
            System.err.println(ex.toString());
        }
        return matches;
    }

    private static String getVersionFromCapability(BundleCapability c) {
        Object o = c.getAttributes().get("version");
        if (o == null) {
            o = c.getAttributes().get("bundle-version");
        }
        return o == null ? "" : o.toString();
    }

    private static boolean matchNamespace(List<String> namespace, String actual) {
        return Util.compareSubstring(namespace, actual);
    }

    private static boolean isValidDirection(String direction) {
        return CAPABILITY.startsWith(direction) || REQUIREMENT.startsWith(direction);
    }
}

